/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.entity.IItemHolding;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityStatue
extends TileEntity
implements IArmorWearing<HumanArmorShape>,
IItemHolding {
    private final @Nullable ItemStack @NotNull [] armorPieces = new ItemStack[HumanArmorShape.values().length];
    @Nullable
    private ItemStack heldItem = null;
    @NotNull
    private Pose pose = Pose.DEFAULT;

    @Override
    public void writeAdditionalData(@NotNull CompoundTag compoundTag) {
        @NotNull ListTag list = new ListTag();
        for (int i = 0; i < this.getNumArmorSlots(); ++i) {
            ItemStack itemInSlot;
            @Nullable HumanArmorShape slot = this.getArmorSlotByIndex(i);
            if (slot == null || (itemInSlot = this.getItemInArmorSlot(slot)) == null) continue;
            @NotNull CompoundTag armorTag = new CompoundTag();
            armorTag.putByte("Slot", (byte)i);
            itemInSlot.writeToNBT(armorTag);
            list.addTag(armorTag);
        }
        compoundTag.putList("Armor", list);
        compoundTag.putByte("Pose", (byte)this.pose.ordinal());
        if (this.getHeldItem() != null) {
            @NotNull CompoundTag heldItemTag = new CompoundTag();
            this.getHeldItem().writeToNBT(heldItemTag);
            compoundTag.putCompound("HeldItem", heldItemTag);
        }
    }

    @Override
    public void readAdditionalData(@NotNull CompoundTag compoundTag) {
        ItemStack heldItem;
        byte pose;
        @Nullable ListTag list = compoundTag.getList("Armor");
        if (list != null) {
            for (Tag<?> t : list) {
                ItemStack stack;
                HumanArmorShape armorSlot;
                CompoundTag ct;
                Tag<?> t2;
                if (!(t instanceof CompoundTag) || !((t2 = (ct = (CompoundTag)t).getTag("Slot")) instanceof ByteTag) || (armorSlot = this.getArmorSlotByIndex(((Byte)((ByteTag)t2).getValue()).byteValue())) == null || (stack = ItemStack.readItemStackFromNbt(ct)) == null) continue;
                this.setItemInArmorSlot(armorSlot, stack);
            }
        }
        if ((pose = compoundTag.getByteOrDefault("Pose", (byte)Pose.DEFAULT.ordinal())) < 0 || pose >= Pose.values().length) {
            pose = (byte)Pose.DEFAULT.ordinal();
        }
        this.pose = Pose.values()[pose];
        @Nullable CompoundTag heldItemTag = compoundTag.getCompoundOrDefault("HeldItem", null);
        if (heldItemTag != null && (heldItem = ItemStack.readItemStackFromNbt(heldItemTag)) != null) {
            this.setHeldItem(heldItem);
        }
    }

    @NotNull
    public Pose getPose() {
        return this.pose;
    }

    public void setPose(@NotNull Pose pose) {
        this.pose = pose;
        this.setChanged();
    }

    public void nextPose() {
        this.setPose(Pose.values()[(this.getPose().ordinal() + 1) % Pose.values().length]);
    }

    @Override
    @Nullable
    public ItemStack getItemInArmorSlot(@NotNull HumanArmorShape slot) {
        return this.armorPieces[slot.getSlotIndex()];
    }

    @Override
    public void setItemInArmorSlot(@NotNull HumanArmorShape slot, @Nullable ItemStack item) {
        this.armorPieces[slot.getSlotIndex()] = item;
        this.setChanged();
    }

    @Override
    public int getNumArmorSlots() {
        return HumanArmorShape.values().length;
    }

    @Override
    @Nullable
    public HumanArmorShape getArmorSlotByIndex(int index) {
        if (index < 0 || index >= HumanArmorShape.values().length) {
            return null;
        }
        return HumanArmorShape.values()[index];
    }

    @Override
    @Nullable
    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    @Override
    public void setHeldItem(@Nullable ItemStack item) {
        this.heldItem = item;
    }

    @Override
    public boolean isLeftHanded() {
        return false;
    }

    @Override
    public Packet getDescriptionPacket() {
        return new PacketTileEntityData(this);
    }

    public static enum Pose {
        DEFAULT(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f),
        LEFT_ARM_UP(-2.2f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f),
        RIGHT_ARM_UP(0.0f, -2.2f, 0.0f, 0.0f, 0.0f, 0.0f),
        BOTH_ARMS_UP(-2.2f, -2.2f, 0.0f, 0.0f, 0.0f, 0.0f),
        WALKING(0.75f, -0.75f, -0.5f, 0.5f, 0.0f, 0.0f),
        LOOK_UP(0.0f, 0.0f, 0.0f, 0.0f, -0.3f, 0.0f),
        LOOK_DOWN(0.0f, 0.0f, 0.0f, 0.0f, 0.3f, 0.0f),
        LOOK_LEFT(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f),
        LOOK_RIGHT(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

        public final float leftArmPitch;
        public final float rightArmPitch;
        public final float leftLegPitch;
        public final float rightLegPitch;
        public final float headPitch;
        public final float headYaw;

        private Pose(float leftArmPitch, float rightArmPitch, float leftLegPitch, float rightLegPitch, float headPitch, float headYaw) {
            this.leftArmPitch = leftArmPitch;
            this.rightArmPitch = rightArmPitch;
            this.leftLegPitch = leftLegPitch;
            this.rightLegPitch = rightLegPitch;
            this.headPitch = headPitch;
            this.headYaw = headYaw;
        }
    }
}

