/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.lang.text.FormattedText;
import net.minecraft.core.lang.text.FunctionText;
import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class ChainText
extends Text {
    @NotNull
    private final @NotNull List<@NotNull Text> chain = new ArrayList<Text>();

    public ChainText(Text ... chain) {
        this.chain.addAll(Arrays.asList(chain));
    }

    @Override
    void toString(@NotNull StringBuilder sb) {
        for (Text text : this.chain) {
            text.toString(sb);
        }
    }

    @Override
    @NotNull
    public Text trans(@NotNull String languageKey) {
        this.chain.add(new TranslatableText(languageKey));
        return this;
    }

    @Override
    @NotNull
    public Text func(@NotNull FunctionText.TextGenerator generator) {
        this.chain.add(new FunctionText(generator));
        return this;
    }

    @Override
    @NotNull
    public Text lit(@NotNull String literal) {
        this.chain.add(new LiteralText(literal));
        return this;
    }

    @Override
    @NotNull
    public Text fmt(@NotNull TextFormatting formatting, @NotNull Text text) {
        this.chain.add(new FormattedText(formatting, text));
        return this;
    }
}

