/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor.components;

import com.mojang.nbt.tags.ByteArrayTag;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.DoubleArrayTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongArrayTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.ShortArrayTag;
import com.mojang.nbt.tags.ShortTag;
import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.ByteArrayTagComponent;
import net.minecraft.client.gui.nbteditor.components.ByteTagComponent;
import net.minecraft.client.gui.nbteditor.components.CompoundTagComponent;
import net.minecraft.client.gui.nbteditor.components.DoubleArrayTagComponent;
import net.minecraft.client.gui.nbteditor.components.DoubleTagComponent;
import net.minecraft.client.gui.nbteditor.components.FloatTagComponent;
import net.minecraft.client.gui.nbteditor.components.IntTagComponent;
import net.minecraft.client.gui.nbteditor.components.ListTagComponent;
import net.minecraft.client.gui.nbteditor.components.LongArrayTagComponent;
import net.minecraft.client.gui.nbteditor.components.LongTagComponent;
import net.minecraft.client.gui.nbteditor.components.ShortArrayTagComponent;
import net.minecraft.client.gui.nbteditor.components.ShortTagComponent;
import net.minecraft.client.gui.nbteditor.components.StringTagComponent;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTagComponent<T>
extends Gui {
    public static final int COLOR_BACKGROUND = -2002739040;
    public static final int COLOR_BACKGROUND_HIGHLIGHTED = -2006949728;
    public static final int SHIFT_RIGHT = 13;
    public static final int COMPONENT_PADDING = 1;
    public static final int TEXT_PADDING = 2;
    @NotNull
    public final Screen attachedScreen;
    @NotNull
    public final Tag<T> tag;

    public AbstractTagComponent(@NotNull Screen attachedScreen, @NotNull Tag<T> tag) {
        this.attachedScreen = attachedScreen;
        this.tag = tag;
    }

    public void render(@NotNull TessellatorGeneral t, int offX, int offY, int mx, int my, float partialTick) {
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawGuiIcon(offX, offY, 12, 12, this.getIcon(mx, my, partialTick));
    }

    public int height(int mx, int my, float partialTick) {
        return 12;
    }

    public int width(int mx, int my, float partialTick) {
        return this.attachedScreen.width / 2;
    }

    public boolean isHovered(int mx, int my, float partialTick) {
        int h = this.height(mx, my, partialTick);
        int w = this.width(mx, my, partialTick);
        return mx >= 0 && mx <= w && my >= 0 && my <= h;
    }

    public void onMouseClick(int mx, int my, int mouseButton, float partialTick) {
    }

    public void onMouseRelease(int mx, int my, int mouseButton, float partialTick) {
    }

    @NotNull
    public abstract IconCoordinate getIcon(int var1, int var2, float var3);

    @Nullable
    public static AbstractTagComponent componentForTag(@NotNull Screen attachedScreen, @NotNull Tag<?> tag) {
        switch (Tag.TagID.fromId(tag.getId())) {
            case TAG_BYTE: {
                return new ByteTagComponent(attachedScreen, (ByteTag)tag);
            }
            case TAG_SHORT: {
                return new ShortTagComponent(attachedScreen, (ShortTag)tag);
            }
            case TAG_INT: {
                return new IntTagComponent(attachedScreen, (IntTag)tag);
            }
            case TAG_LONG: {
                return new LongTagComponent(attachedScreen, (LongTag)tag);
            }
            case TAG_FLOAT: {
                return new FloatTagComponent(attachedScreen, (FloatTag)tag);
            }
            case TAG_DOUBLE: {
                return new DoubleTagComponent(attachedScreen, (DoubleTag)tag);
            }
            case TAG_BYTE_ARRAY: {
                return new ByteArrayTagComponent(attachedScreen, (ByteArrayTag)tag);
            }
            case TAG_STRING: {
                return new StringTagComponent(attachedScreen, (StringTag)tag);
            }
            case TAG_LIST: {
                return new ListTagComponent(attachedScreen, (ListTag)tag);
            }
            case TAG_COMPOUND: {
                return new CompoundTagComponent(attachedScreen, (CompoundTag)tag);
            }
            case TAG_SHORT_ARRAY: {
                return new ShortArrayTagComponent(attachedScreen, (ShortArrayTag)tag);
            }
            case TAG_DOUBLE_ARRAY: {
                return new DoubleArrayTagComponent(attachedScreen, (DoubleArrayTag)tag);
            }
            case TAG_LONG_ARRAY: {
                return new LongArrayTagComponent(attachedScreen, (LongArrayTag)tag);
            }
        }
        return null;
    }
}

