/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.util.Random;
import net.minecraft.client.sound.NamedSoundRepository;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundEvent {
    private final WeightedRandomBag<SoundEntry> entryBag = new WeightedRandomBag();
    @NotNull
    public final NamedSoundRepository parentRepo;
    @NotNull
    private final String id;
    @Nullable
    protected String subtitleKey;

    public SoundEvent(@NotNull NamedSoundRepository parentRepo, @NotNull String eventID, @Nullable String subtitleKey) {
        this.parentRepo = parentRepo;
        this.id = eventID;
        this.subtitleKey = subtitleKey;
    }

    public void addSoundEntry(SoundEntry entry) {
        this.entryBag.addEntry(entry, entry.weight);
    }

    protected void clearSoundEntries() {
        this.entryBag.clear();
    }

    public String getEventID() {
        return this.id;
    }

    public SoundEntry getRandomEntry() {
        return this.entryBag.getRandom();
    }

    public SoundEntry getRandomEntry(Random r) {
        return this.entryBag.getRandom(r);
    }

    @Nullable
    public String getSubtitleKey() {
        return this.subtitleKey;
    }

    @Nullable
    public String getSubtitleTranslated() {
        return I18n.getInstance().translateKey(this.subtitleKey);
    }

    public boolean hasSubtitle() {
        return this.subtitleKey != null;
    }

    public WeightedRandomBag<SoundEntry> getEntryBag() {
        return this.entryBag;
    }

    public String toString() {
        return "SoundEvent{entryBag=" + String.valueOf(this.entryBag) + ", id='" + this.id + "', subtitleKey='" + this.subtitleKey + "'}";
    }
}

