/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.drift.BiomeDrift;
import net.minecraft.core.world.biome.nether.BiomeCrystalForest;
import net.minecraft.core.world.biome.nether.BiomeNether;
import net.minecraft.core.world.biome.nether.BiomeSulfurPools;
import net.minecraft.core.world.biome.nether.BiomeVolcanoIslands;
import net.minecraft.core.world.biome.overworld.BiomeBirchForest;
import net.minecraft.core.world.biome.overworld.BiomeBorealForest;
import net.minecraft.core.world.biome.overworld.BiomeCaatinga;
import net.minecraft.core.world.biome.overworld.BiomeDesert;
import net.minecraft.core.world.biome.overworld.BiomeForest;
import net.minecraft.core.world.biome.overworld.BiomeOutback;
import net.minecraft.core.world.biome.overworld.BiomePlains;
import net.minecraft.core.world.biome.overworld.BiomeRainforest;
import net.minecraft.core.world.biome.overworld.BiomeRetro;
import net.minecraft.core.world.biome.overworld.BiomeSeasonalForest;
import net.minecraft.core.world.biome.overworld.BiomeShrubland;
import net.minecraft.core.world.biome.overworld.BiomeSwamp;
import net.minecraft.core.world.biome.overworld.BiomeTaiga;
import net.minecraft.core.world.biome.overworld.legacy.BiomeDesertLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeForestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeRainforestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeSwampLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeTaigaLegacy;
import net.minecraft.core.world.weather.Weathers;

public class Biomes {
    public static final Biome OVERWORLD_RAINFOREST = Biomes.register("minecraft:overworld.rainforest", new BiomeRainforest("overworld.rainforest").setColor(1896704).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.975f, 0.925f, 0.5f));
    public static final Biome OVERWORLD_SWAMPLAND = Biomes.register("minecraft:overworld.swampland", new BiomeSwamp("overworld.swampland").setColor(65400).setDefaults(0.85f, 0.925f, 0.5f));
    public static final Biome OVERWORLD_SEASONAL_FOREST = Biomes.register("minecraft:overworld.seasonal_forest", new BiomeSeasonalForest("overworld.seasonal_forest").setColor(6606357).setDefaults(0.675f, 0.75f, 0.5f));
    public static final Biome OVERWORLD_FOREST = Biomes.register("minecraft:overworld.forest", new BiomeForest("overworld.forest").setColor(2532885).setDefaults(0.875f, 0.675f, 0.5f));
    public static final Biome OVERWORLD_GRASSLANDS = Biomes.register("minecraft:overworld.grasslands", new Biome("overworld.grasslands").setColor(15790152).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.75f, 0.025f, 0.5f));
    public static final Biome OVERWORLD_OUTBACK = Biomes.register("minecraft:overworld.outback", new BiomeOutback("overworld.outback").setColor(14245408).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setTopBlock(Blocks.DIRT_SCORCHED.id()).setFillerBlock(Blocks.DIRT_SCORCHED.id()).setDefaults(0.825f, 0.1f, 0.5f));
    public static final Biome OVERWORLD_SHRUBLAND = Biomes.register("minecraft:overworld.shrubland", new BiomeShrubland("overworld.shrubland").setColor(12237368).setDefaults(0.675f, 0.175f, 0.5f));
    public static final Biome OVERWORLD_TAIGA = Biomes.register("minecraft:overworld.taiga", new BiomeTaiga("overworld.taiga").setColor(9092351).setSurfaceSnow().setSurfaceIce().setDefaults(0.15f, 0.55f, 0.5f));
    public static final Biome OVERWORLD_BOREAL_FOREST = Biomes.register("minecraft:overworld.boreal_forest", new BiomeBorealForest("overworld.boreal_forest").setColor(1344868).setDefaults(0.4f, 0.525f, 0.5f));
    public static final Biome OVERWORLD_DESERT = Biomes.register("minecraft:overworld.desert", new BiomeDesert("overworld.desert").setColor(15589999).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).setTopBlock(Blocks.SAND.id()).setFillerBlock(Blocks.SAND.id()).setDefaults(0.925f, 0.05f, 0.5f));
    public static final Biome OVERWORLD_PLAINS = Biomes.register("minecraft:overworld.plains", new BiomePlains("overworld.plains").setColor(10733129).setDefaults(0.875f, 0.25f, 0.5f));
    public static final Biome OVERWORLD_GLACIER = Biomes.register("minecraft:overworld.glacier", new Biome("overworld.glacier").setColor(13367039).setSurfaceSnow().setTopBlock(Blocks.BLOCK_SNOW.id()).setFillerBlock(Blocks.BLOCK_SNOW.id()).setDefaults(0.15f, 0.005f, 0.5f));
    public static final Biome OVERWORLD_TUNDRA = Biomes.register("minecraft:overworld.tundra", new Biome("overworld.tundra").setColor(5759231).setSurfaceSnow().setSurfaceIce().setDefaults(0.15f, 0.055f, 0.5f));
    public static final Biome OVERWORLD_MEADOW = Biomes.register("minecraft:overworld.meadow", new BiomeBorealForest("overworld.meadow").setColor(0x8C8C22).setDefaults(0.4f, 0.025f, 0.5f));
    public static final Biome DRIFT_DRIFT = Biomes.register("minecraft:drift.drift", new BiomeDrift("drift.drift").setColor(0x8080FF).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setDefaults(0.5f, 0.0f, 0.0f));
    public static final Biome OVERWORLD_BIRCH_FOREST = Biomes.register("minecraft:overworld.birch_forest", new BiomeBirchForest("overworld.birch_forest").setColor(4967262).setDefaults(0.675f, 0.4f, 0.5f));
    public static final Biome OVERWORLD_RETRO = Biomes.register("minecraft:overworld.retro", new BiomeRetro("overworld.retro").setColor(7778634).setTopBlock(Blocks.GRASS_RETRO.id()));
    public static final Biome OVERWORLD_HELL = Biomes.register("minecraft:overworld.hell", new Biome("overworld.hell").setColor(14246435).setTopBlock(Blocks.DIRT_SCORCHED.id()).setTopBlock(Blocks.DIRT_SCORCHED.id()));
    public static final Biome OVERWORLD_SWAMPLAND_MUDDY = Biomes.register("minecraft:overworld.swampland.muddy", new BiomeSwamp("overworld.swampland.muddy").setColor(5383936).setDefaults(0.85f, 0.925f, 0.5f));
    public static final Biome OVERWORLD_OUTBACK_GRASSY = Biomes.register("minecraft:overworld.outback.grassy", new BiomeOutback("overworld.outback.grassy").setColor(15765559).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setTopBlock(Blocks.GRASS_SCORCHED.id()).setFillerBlock(Blocks.DIRT_SCORCHED.id()).setDefaults(0.825f, 0.1f, 1.0f));
    public static final Biome OVERWORLD_CAATINGA = Biomes.register("minecraft:overworld.caatinga", new BiomeCaatinga("overworld.caatinga").setColor(14601638).setTopBlock(Blocks.MUD_BAKED.id()).setFillerBlock(Blocks.MUD_BAKED.id()).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.95f, 0.015f, 0.5f));
    public static final Biome OVERWORLD_CAATINGA_PLAINS = Biomes.register("minecraft:overworld.caatinga.plains", new Biome("overworld.caatinga.plains").setColor(10589303).setTopBlock(Blocks.MUD_BAKED.id()).setFillerBlock(Blocks.MUD_BAKED.id()).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.95f, 0.015f, 0.0f));
    public static final Biome NETHER_CRAG = Biomes.register("minecraft:nether.crag", new BiomeNether("nether.crag").setColor(6503997).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_VOLCANIC_ISLANDS = Biomes.register("minecraft:nether.volcanic_islands", new BiomeVolcanoIslands("nether.volcanic_islands").setColor(0xFFA333).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.BRIMSAND.id()).setFillerBlock(Blocks.BRIMSAND.id()));
    public static final Biome NETHER_SULFUR_POOLS = Biomes.register("minecraft:nether.sulfur_pools", new BiomeSulfurPools("nether.sulfur_pools").setColor(10721600).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.BRIMSAND.id()).setFillerBlock(Blocks.BRIMSAND.id()));
    public static final Biome NETHER_CRYSTAL_FIELD = Biomes.register("minecraft:nether.crystal_field", new BiomeCrystalForest("nether.crystal_field").setColor(0xAA0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_CRYSTAL_FOREST = Biomes.register("minecraft:nether.crystal_forest", new BiomeCrystalForest("nether.crystal_forest").setColor(0xDD0000).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_OLD_WORLD = Biomes.register("minecraft:nether.old_world", new BiomeNether("nether.old_world").setColor(6513792).setSurfaceSnow().setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome NETHER_SHELF = Biomes.register("minecraft:nether.shelf", new BiomeNether("nether.shelf").setColor(9865839).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).setTopBlock(Blocks.COBBLE_NETHERRACK.id()).setFillerBlock(Blocks.COBBLE_NETHERRACK.id()));
    public static final Biome OVERWORLD_LEGACY_RAINFOREST = Biomes.register("minecraft:overworld.legacy.rainforest", new BiomeRainforestLegacy("overworld.legacy.rainforest").setColor(14278691).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.985f, 0.95f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_SWAMPLAND = Biomes.register("minecraft:overworld.legacy.swampland", new BiomeSwampLegacy("overworld.legacy.swampland").setColor(522674).setDefaults(0.75f, 0.4f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_SEASONAL_FOREST = Biomes.register("minecraft:overworld.legacy.seasonal_forest", new Biome("overworld.legacy.seasonal_forest").setColor(10215459).setDefaults(0.985f, 0.675f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_FOREST = Biomes.register("minecraft:overworld.legacy.forest", new BiomeForestLegacy("overworld.legacy.forest").setColor(353825).setDefaults(0.735f, 0.425f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_SAVANNA = Biomes.register("minecraft:overworld.legacy.savanna", new BiomeDesertLegacy("overworld.legacy.savanna").setColor(14278691).setBlockedWeathers(Weathers.OVERWORLD_SNOW).setDefaults(0.725f, 0.1f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_SHRUBLAND = Biomes.register("minecraft:overworld.legacy.shrubland", new Biome("overworld.legacy.shrubland").setColor(10595616).setDefaults(0.735f, 0.275f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_TAIGA = Biomes.register("minecraft:overworld.legacy.taiga", new BiomeTaigaLegacy("overworld.legacy.taiga").setColor(3060051).setSurfaceSnow().setSurfaceIce().setDefaults(0.3f, 0.35f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_DESERT = Biomes.register("minecraft:overworld.legacy.desert", new BiomeDesertLegacy("overworld.legacy.desert").setColor(16421912).setBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).setTopBlock(Blocks.SAND.id()).setFillerBlock(Blocks.SAND.id()).setDefaults(0.975f, 0.1f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_PLAINS = Biomes.register("minecraft:overworld.legacy.plains", new BiomeDesertLegacy("overworld.legacy.plains").setColor(16767248).setDefaults(0.985f, 0.325f, 0.5f));
    public static final Biome OVERWORLD_LEGACY_TUNDRA = Biomes.register("minecraft:overworld.legacy.tundra", new Biome("overworld.legacy.tundra").setColor(5762041).setSurfaceSnow().setSurfaceIce().setDefaults(0.05f, 0.5f, 0.5f));

    public static Biome register(String key, Biome biome) {
        Registries.BIOMES.register(key, biome);
        return biome;
    }

    public static void init() {
    }
}

