/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontDefault;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL41;

public class FontRendererDefault
extends FontRenderer {
    @NotNull
    public final Font fallbackFont;
    @Nullable
    public final Font font;
    protected final long @NotNull [] configStack = new long[32];
    protected byte stackIndex = 0;
    protected long currentConfig = 0L;
    protected int currentTex = -1;
    protected final Random random;
    protected final List<@NotNull String> localStringList = new ArrayList<String>();
    protected final double[] localXPosBuffer = new double[1];
    protected final double[] localYPosBuffer = new double[1];
    protected final long[] localConfigBuffer = new long[1];
    protected TessellatorFont tessellatorFont;
    private final StringBuilder renderStringInternal_colorValue = new StringBuilder();
    private final StringBuilder splitLineIntoConstrainedLine_lineBuilder = new StringBuilder();
    private final StringBuilder splitLineIntoConstrainedLine_wordBuilder = new StringBuilder();

    public FontRendererDefault() {
        this(null);
    }

    public FontRendererDefault(@Nullable Font font) {
        this.fallbackFont = Fonts.UNICODE;
        this.font = font;
        this.random = new Random();
    }

    @Override
    public void init() {
        this.tessellatorFont = new TessellatorFont("FontRenderDefault Base Tessellator", 262144);
    }

    protected void renderStringInternal(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        double currX = x;
        this.random.setSeed(System.currentTimeMillis() / 50L);
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == '\u00a7' && i + 1 < chars.length()) {
                char cNext = chars.charAt(i + 1);
                if (cNext == '<') {
                    int offAmount = 1;
                    this.renderStringInternal_colorValue.setLength(0);
                    boolean ended = false;
                    for (int j = 0; j < 8; ++j) {
                        ++offAmount;
                        char pChar = chars.charAt(i + 2 + j);
                        if (pChar == '>') {
                            ended = true;
                            break;
                        }
                        this.renderStringInternal_colorValue.append(pChar);
                    }
                    if (ended) {
                        long colorInt = 0xFFFFFFL;
                        try {
                            colorInt = FontRendererDefault.decodeHexToLong(this.renderStringInternal_colorValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.currentConfig = SF.setColor(this.currentConfig, (colorInt & 0xFF000000L) == 0L ? (int)(colorInt & 0xFFFFFFL) | SF.getColor(baseConfig) & 0xFF000000 : (int)colorInt);
                        i += offAmount;
                        continue;
                    }
                } else {
                    int formatCode = "0123456789abcdefklmnor+-".indexOf(cNext);
                    if (formatCode != -1) {
                        switch (cNext) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                this.currentConfig = SF.setColor(this.currentConfig, Colors.allChatColors[MathHelper.clamp((int)formatCode, (int)0, (int)15)].value);
                                break;
                            }
                            case 'k': {
                                this.currentConfig = SF.setObfuscated(this.currentConfig);
                                break;
                            }
                            case 'l': {
                                this.currentConfig = SF.setBold(this.currentConfig);
                                break;
                            }
                            case 'm': {
                                this.currentConfig = SF.setStrikethrough(this.currentConfig);
                                break;
                            }
                            case 'n': {
                                this.currentConfig = SF.setUnderline(this.currentConfig);
                                break;
                            }
                            case 'o': {
                                this.currentConfig = SF.setItalic(this.currentConfig);
                                break;
                            }
                            case 'r': {
                                this.currentConfig = Integer.toUnsignedLong(SF.getColor(baseConfig)) | baseConfig & 0x2000000000L;
                                break;
                            }
                            case '+': {
                                if (this.stackIndex == this.configStack.length - 1) break;
                                this.configStack[this.stackIndex] = this.currentConfig;
                                this.stackIndex = (byte)(this.stackIndex + 1);
                                break;
                            }
                            case '-': {
                                if (this.stackIndex == 0) break;
                                this.stackIndex = (byte)(this.stackIndex - 1);
                                this.currentConfig = this.configStack[this.stackIndex];
                            }
                        }
                        ++i;
                        continue;
                    }
                }
            }
            Font charFont = font.canRenderChar(c) ? font : this.fallbackFont;
            this.tessellatorFont.setTexture(charFont.textureForChar(c));
            currX += this.renderCharInternal(charFont, this.tessellatorFont, c, currX, y, z, shadow);
        }
        if (xPosBuffer != null) {
            xPosBuffer[0] = currX;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = y + (double)font.fontHeight() + 1.0;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.currentConfig;
        }
    }

    @NotNull
    public TessellatorFont getTessellator() {
        return this.tessellatorFont;
    }

    public void renderStringRaw(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig) {
        this.currentConfig = baseConfig;
        this.renderStringInternal(font, chars, x, y, z, shadow, baseConfig, null, null, null);
    }

    protected double renderCharInternal(@NotNull Font font, @NotNull TessellatorFont tessellator, char c, double x, double y, double z, boolean shadow) {
        double shift;
        tessellator.setShadow(shadow);
        tessellator.setConfig(this.currentConfig);
        int fontIndex = FontDefault.ALLOWED_CHARACTER_INDICES[c];
        if (SF.isObfuscated(this.currentConfig) && c != ' ' && fontIndex > 0) {
            shift = font.charWidth(c);
            char randomChar = font.getObfuscatedChar(c, this.random);
            font.renderChar(tessellator, randomChar, x, y, z);
        } else {
            shift = font.renderChar(tessellator, c, x, y, z);
        }
        return shift + (double)(SF.isBold(this.currentConfig) ? 1 : 0);
    }

    @Override
    public void renderDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        this.tessellatorFont.startDrawing();
        this.renderStringInternal(font, chars, x, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
        Shaders.FONT.bind();
        this.tessellatorFont.draw();
        GLRenderer.popFrame();
    }

    @Override
    public void renderImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderDoubleImpl(font, chars, x, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderCenteredDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderDoubleImpl(font, chars, x - this.stringWidthDouble(chars) / 2.0, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderCenteredImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderImpl(font, chars, x - this.stringWidth(chars) / 2, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderWidthConstrainedDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double maxWidth, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        this.tessellatorFont.startDrawing();
        double currY = y;
        switch (alignment) {
            case LEFT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
            case RIGHT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)), currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)) / 2.0, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
        }
        Shaders.FONT.bind();
        this.tessellatorFont.draw();
        GLRenderer.popFrame();
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderWidthConstrainedImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, int maxWidth, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        this.tessellatorFont.startDrawing();
        int currY = y;
        switch (alignment) {
            case LEFT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
            case RIGHT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidth(line)), currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidth(line)) / 2, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
        }
        Shaders.FONT.bind();
        this.tessellatorFont.draw();
        GLRenderer.popFrame();
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderConstrainedDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double maxWidth, double maxHeight, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        double currY = y;
        this.localConfigBuffer[0] = baseConfig;
        block0 : switch (alignment) {
            case LEFT: {
                GLRenderer.pushFrame();
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                GLRenderer.globalSetUniforms(Shaders.FONT);
                Shaders.FONT.bind();
                GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
                this.tessellatorFont.startDrawing();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break;
                }
                Shaders.FONT.bind();
                this.tessellatorFont.draw();
                GLRenderer.popFrame();
                break;
            }
            case RIGHT: {
                GLRenderer.pushFrame();
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                GLRenderer.globalSetUniforms(Shaders.FONT);
                Shaders.FONT.bind();
                GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
                this.tessellatorFont.startDrawing();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)), currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break;
                }
                Shaders.FONT.bind();
                this.tessellatorFont.draw();
                GLRenderer.popFrame();
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderCenteredDoubleImpl(font, line, x + maxWidth / 2.0, currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break block0;
                }
                break;
            }
        }
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderConstrainedImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, int maxWidth, int maxHeight, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderConstrainedDoubleImpl(font, chars, x, y, z, shadow, baseConfig, maxWidth, maxHeight, alignment, xPosBuffer, yPosBuffer, configBuffer);
    }

    protected void splitLineIntoConstrainedLine(@NotNull Font font, @NotNull CharSequence line, double maxWidth, @NotNull List<String> output) {
        double dashWidth = font.charWidthDouble('-');
        double spaceWidth = font.charWidthDouble(' ');
        double currLineWidth = 0.0;
        double currWordWidth = 0.0;
        this.splitLineIntoConstrainedLine_lineBuilder.setLength(0);
        this.splitLineIntoConstrainedLine_wordBuilder.setLength(0);
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            double charWidth;
            char c = line.charAt(i);
            if (c == '\n') {
                this.splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)this.splitLineIntoConstrainedLine_wordBuilder);
                this.splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                currWordWidth = 0.0;
                output.add(this.splitLineIntoConstrainedLine_lineBuilder.toString());
                this.splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (c == '\t') {
                this.splitLineIntoConstrainedLine_wordBuilder.append("   ");
                currWordWidth += spaceWidth * 3.0;
                continue;
            }
            if (c == '\u00a7' && i + 1 < length) {
                char cN = line.charAt(i + 1);
                if (cN == '<') {
                    int offAmount = 1;
                    boolean ended = false;
                    for (int j = 0; j < 8; ++j) {
                        ++offAmount;
                        if (line.charAt(j + i + 2) != '>') continue;
                        ended = true;
                        break;
                    }
                    if (ended) {
                        this.splitLineIntoConstrainedLine_wordBuilder.append(line, i, i + offAmount + 1);
                        i += offAmount;
                        continue;
                    }
                } else if ("0123456789abcdefklmnor+-".indexOf(cN) != -1) {
                    this.splitLineIntoConstrainedLine_wordBuilder.append(line, i, i + 2);
                    ++i;
                    continue;
                }
            }
            double d = charWidth = font.canRenderChar(c) ? font.charWidthDouble(c) : this.fallbackFont.charWidthDouble(c);
            if (currWordWidth + charWidth + dashWidth > maxWidth) {
                this.splitLineIntoConstrainedLine_wordBuilder.append('-');
                this.splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)this.splitLineIntoConstrainedLine_wordBuilder);
                this.splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                this.splitLineIntoConstrainedLine_wordBuilder.append(c);
                currWordWidth = charWidth;
                output.add(this.splitLineIntoConstrainedLine_lineBuilder.toString().trim());
                this.splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (currLineWidth + currWordWidth + charWidth > maxWidth) {
                this.splitLineIntoConstrainedLine_wordBuilder.append(c);
                currWordWidth += charWidth;
                output.add(this.splitLineIntoConstrainedLine_lineBuilder.toString().trim());
                this.splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (c == ' ') {
                this.splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)this.splitLineIntoConstrainedLine_wordBuilder).append(' ');
                currLineWidth += currWordWidth + spaceWidth;
                this.splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                currWordWidth = 0.0;
                continue;
            }
            this.splitLineIntoConstrainedLine_wordBuilder.append(c);
            currWordWidth += charWidth;
        }
        this.splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)this.splitLineIntoConstrainedLine_wordBuilder);
        String remainder = this.splitLineIntoConstrainedLine_lineBuilder.toString().trim();
        if (!remainder.isEmpty()) {
            output.add(remainder);
        }
    }

    @Override
    @NotNull
    public List<String> splitCharsIntoLines(@NotNull Font font, @NotNull CharSequence chars, double maxWidth, @Nullable List<String> output) {
        @NotNull ArrayList<String> o = output == null ? new ArrayList<String>() : output;
        o.clear();
        this.splitLineIntoConstrainedLine(font, chars, maxWidth, o);
        return o;
    }

    @Override
    @NotNull
    public List<String> splitLinesIntoConstrainedLines(@NotNull Font font, @NotNull List<String> lines, double maxWidth, @Nullable List<String> output) {
        @NotNull ArrayList<String> o = output == null ? new ArrayList<String>() : output;
        o.clear();
        for (int i = 0; i < lines.size(); ++i) {
            this.splitLineIntoConstrainedLine(font, lines.get(i), maxWidth, o);
        }
        return o;
    }

    @Override
    public double heightOfConstrainedChars(@NotNull Font font, @NotNull CharSequence chars, double maxWidth) {
        this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        return this.localStringList.size() * (font.fontHeight() + 1);
    }

    @Override
    public double heightOfLines(@NotNull Font font, @NotNull @NotNull List<@NotNull String> lines, double maxWidth) {
        this.splitLinesIntoConstrainedLines(lines, maxWidth, this.localStringList);
        return this.localStringList.size() * (font.fontHeight() + 1);
    }

    @Override
    public double stringWidthDouble(@NotNull Font font, @NotNull CharSequence chars) {
        double width = 0.0;
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            if (c == '\u00a7' && i + 1 < length) {
                char cN = chars.charAt(i + 1);
                if (cN == '<') {
                    int offAmount = 1;
                    boolean ended = false;
                    for (int j = i + 2; j < length; ++j) {
                        ++offAmount;
                        if (chars.charAt(j) != '>') continue;
                        ended = true;
                        break;
                    }
                    if (ended) {
                        i += offAmount;
                        continue;
                    }
                } else if ("0123456789abcdefklmnor+-".indexOf(cN) != -1) {
                    ++i;
                    continue;
                }
            }
            width += font.canRenderChar(c) ? font.charWidthDouble(c) : this.fallbackFont.charWidthDouble(c);
        }
        return width;
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.font == null ? (Font)GameSettings.FONT.value : this.font;
    }

    public static int decodeHexToInt(@NotNull CharSequence hexSequence) throws NumberFormatException {
        int value = 0;
        int length = hexSequence.length();
        block18: for (int i = 0; i < length; ++i) {
            char c = hexSequence.charAt(length - i - 1);
            switch (c) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    value |= 1 << 4 * i;
                    continue block18;
                }
                case '2': {
                    value |= 2 << 4 * i;
                    continue block18;
                }
                case '3': {
                    value |= 3 << 4 * i;
                    continue block18;
                }
                case '4': {
                    value |= 4 << 4 * i;
                    continue block18;
                }
                case '5': {
                    value |= 5 << 4 * i;
                    continue block18;
                }
                case '6': {
                    value |= 6 << 4 * i;
                    continue block18;
                }
                case '7': {
                    value |= 7 << 4 * i;
                    continue block18;
                }
                case '8': {
                    value |= 8 << 4 * i;
                    continue block18;
                }
                case '9': {
                    value |= 9 << 4 * i;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    value |= 10 << 4 * i;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    value |= 11 << 4 * i;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    value |= 12 << 4 * i;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    value |= 13 << 4 * i;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    value |= 14 << 4 * i;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    value |= 15 << 4 * i;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("Illegal non hex char '" + c + "'");
                }
            }
        }
        return value;
    }

    public static long decodeHexToLong(@NotNull CharSequence hexSequence) throws NumberFormatException {
        long value = 0L;
        int length = hexSequence.length();
        block18: for (int i = 0; i < length; ++i) {
            char c = hexSequence.charAt(length - i - 1);
            switch (c) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    value |= 1L << 4 * i;
                    continue block18;
                }
                case '2': {
                    value |= 2L << 4 * i;
                    continue block18;
                }
                case '3': {
                    value |= 3L << 4 * i;
                    continue block18;
                }
                case '4': {
                    value |= 4L << 4 * i;
                    continue block18;
                }
                case '5': {
                    value |= 5L << 4 * i;
                    continue block18;
                }
                case '6': {
                    value |= 6L << 4 * i;
                    continue block18;
                }
                case '7': {
                    value |= 7L << 4 * i;
                    continue block18;
                }
                case '8': {
                    value |= 8L << 4 * i;
                    continue block18;
                }
                case '9': {
                    value |= 9L << 4 * i;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    value |= 10L << 4 * i;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    value |= 11L << 4 * i;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    value |= 12L << 4 * i;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    value |= 13L << 4 * i;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    value |= 14L << 4 * i;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    value |= 15L << 4 * i;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("Illegal non hex char '" + c + "'");
                }
            }
        }
        return value;
    }
}

