/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.util;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BeautifulNbt {
    public static String toBeautifulNbt(@NotNull CompoundTag nbt) {
        StringBuilder builder = new StringBuilder("{");
        boolean comma = false;
        for (Tag tag : ((Map)nbt.getValue()).values()) {
            if (comma) {
                builder.append(", ");
            }
            builder.append(tag.getTagName()).append(": ").append(BeautifulNbt.element(tag instanceof CompoundTag ? tag : tag.getValue()));
            comma = true;
        }
        return builder.append("}").toString();
    }

    private static String element(Object o) {
        if (o instanceof byte[] || o instanceof short[] || o instanceof double[] || o instanceof List) {
            return BeautifulNbt.collection(o);
        }
        if (o instanceof Byte) {
            return String.valueOf(o) + "b";
        }
        if (o instanceof Short) {
            return String.valueOf(o) + "s";
        }
        if (o instanceof Long) {
            return String.valueOf(o) + "l";
        }
        if (o instanceof Float) {
            return String.valueOf(o) + "f";
        }
        if (o instanceof String) {
            return "\"" + String.valueOf(o) + "\"";
        }
        return o instanceof CompoundTag ? BeautifulNbt.toBeautifulNbt((CompoundTag)o) : o.toString();
    }

    private static String collection(Object o) {
        StringBuilder result;
        block9: {
            boolean comma;
            block11: {
                block10: {
                    block8: {
                        result = new StringBuilder("[");
                        comma = false;
                        if (!(o instanceof byte[])) break block8;
                        result.append("B; ");
                        for (byte element : (byte[])o) {
                            if (comma) {
                                result.append(", ");
                            }
                            result.append(BeautifulNbt.element(element));
                            comma = true;
                        }
                        break block9;
                    }
                    if (!(o instanceof short[])) break block10;
                    result.append("S; ");
                    for (short element : (short[])o) {
                        if (comma) {
                            result.append(", ");
                        }
                        result.append(BeautifulNbt.element(element));
                        comma = true;
                    }
                    break block9;
                }
                if (!(o instanceof double[])) break block11;
                result.append("D; ");
                for (double element : (double[])o) {
                    if (comma) {
                        result.append(", ");
                    }
                    result.append(BeautifulNbt.element(element));
                    comma = true;
                }
                break block9;
            }
            if (!(o instanceof List)) break block9;
            for (Tag element : (List)o) {
                if (comma) {
                    result.append(", ");
                }
                result.append(BeautifulNbt.element(element instanceof CompoundTag ? element : element.getValue()));
                comma = true;
            }
        }
        return result.append("]").toString();
    }
}

