/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;

public class WorldFeatureThermalVents
extends WorldFeature {
    private final int minRadius;
    private final int radiusMod;

    public WorldFeatureThermalVents(int minRadius, int radiusMod) {
        this.minRadius = minRadius;
        this.radiusMod = radiusMod;
    }

    public WorldFeatureThermalVents() {
        this.minRadius = 4;
        this.radiusMod = 6;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int radius = this.minRadius + random.nextInt(this.radiusMod);
        TilePos tilePos = new TilePos(x, y, z);
        while (world.isAirBlock(tilePos) && tilePos.y - 1 > 0) {
            tilePos.down();
        }
        TilePos queryPos = new TilePos();
        TilePos blockAbove = new TilePos();
        block1: for (int r = 0; r < 10; ++r) {
            int radModX = random.nextInt(radius) - random.nextInt(radius);
            int radModY = random.nextInt(radius) - random.nextInt(radius);
            int radModZ = random.nextInt(radius) - random.nextInt(radius);
            int height = random.nextInt(5);
            tilePos.add(radModX, radModY, radModZ, queryPos);
            queryPos.add(0, 1, 0, blockAbove);
            boolean canBlockSpawn = world.getBlockType(queryPos).hasTag(BlockTags.NETHER_SURFACE_BLOCK);
            if (!canBlockSpawn) continue;
            for (int i = 1; i < height; ++i) {
                queryPos.add(0, i, 0, blockAbove);
                if (!world.isAirBlock(blockAbove)) continue block1;
                world.setBlockTypeNotify(blockAbove, Blocks.THERMAL_VENT);
            }
        }
        return true;
    }
}

