/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.client.render.texturepack.Manifest;
import net.minecraft.client.render.texturepack.TexturePack;
import org.slf4j.Logger;

public class TexturePackDefault
extends TexturePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TextureBuffered texturePackThumbnailTexture = null;
    private BufferedImage texturePackThumbnail;

    public TexturePackDefault() {
        this.fileName = "Default";
        this.manifest = new Manifest(null, TexturePackDefault.class.getResourceAsStream("/manifest.json"));
        try {
            this.texturePackThumbnail = ImageIO.read(TexturePackDefault.class.getResource("/pack.png"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read thumbnail for '{}'!", (Object)this.packId, (Object)e);
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            this.texturePackThumbnailTexture.delete();
            this.texturePackThumbnailTexture = null;
        }
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackThumbnailTexture == null) {
            this.texturePackThumbnailTexture = minecraft.textureManager.loadBufferedTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.textureManager.bindTexture(this.texturePackThumbnailTexture);
        } else {
            minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/unknown_pack.png").bind();
        }
    }

    @Override
    public boolean hasFile(String file) {
        try {
            InputStream stream = TexturePackDefault.class.getResourceAsStream(file);
            if (stream != null) {
                stream.close();
                return true;
            }
            if (((Boolean)GameSettings.ENABLE_HOLIDAY_TEXTURES.value).booleanValue() && Holidays.getCurrentThemedHoliday() != null) {
                assert (Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() != null) : "Current themed holiday must have a theme!";
                String holidayPath = ("/holidays/" + Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() + "/" + file).replace("//", "/");
                InputStream holidayStream = TexturePack.class.getResourceAsStream(holidayPath);
                if (holidayStream != null) {
                    holidayStream.close();
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

