/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.uniform;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.uniform.BufferAdapter;
import net.minecraft.client.render.uniform.UniformBlock;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class UniformBlockManager {
    @NotNull
    public static final Map<String, UniformBlock<?>> nameToBlockMap = new Object2ObjectOpenHashMap();
    @NotNull
    public static final Int2ObjectMap<UniformBlock<?>> indexToBlockMap = new Int2ObjectOpenHashMap();
    @NotNull
    public static final UniformBlock<Matrix4f> BLOCK_MATRICES = UniformBlockManager.register("Matrices", 0, 256, Matrix4f::get);
    @NotNull
    public static final UniformBlock<FogManager.FogState> BLOCK_FOG_STATE = UniformBlockManager.register("FogState", 1, FogManager.FogState.uboSize(), new BufferAdapter<FogManager.FogState>(){

        @Override
        @NotNull
        public ByteBuffer bufferData(FogManager.FogState src, int offset, @NotNull ByteBuffer dest) {
            src.fogColor.get(offset, dest);
            dest.putInt(offset += 16, src.fogMode.ordinal());
            dest.putFloat(offset += 4, src.fogStart);
            dest.putFloat(offset += 4, src.fogEnd);
            dest.putFloat(offset += 4, src.fogDensity);
            offset += 4;
            return dest;
        }
    });
    @NotNull
    public static final UniformBlock<Matrix4f> BLOCK_ENTITY_BONES = UniformBlockManager.register("Bones", 3, 2048, Matrix4f::get);

    public static <T> UniformBlock<T> register(@NotNull String name, int index, int size, @NotNull BufferAdapter<T> adapter) {
        UniformBlock<T> block = new UniformBlock<T>(name, index, size, adapter);
        nameToBlockMap.put(name, block);
        indexToBlockMap.put(index, (UniformBlock<?>)block);
        return block;
    }
}

