/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuFurnace;
import org.jetbrains.annotations.NotNull;

public class ScreenFurnace
extends ScreenContainerAbstract {
    private final TileEntityFurnace furnaceInventory;

    public ScreenFurnace(ContainerInventory inventory, TileEntityFurnace tileEntityFurnace) {
        super(new MenuFurnace(inventory, tileEntityFurnace));
        this.furnaceInventory = tileEntityFurnace;
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        I18n i18n = I18n.getInstance();
        this.drawStringNoShadow(this.fontRenderer, i18n.translateKey("gui.furnace.label.furnace"), 60, 6, 0x404040);
        this.drawStringNoShadow(this.fontRenderer, i18n.translateKey("gui.furnace.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTick) {
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/furnace.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.furnaceInventory.isBurning()) {
            int fireHeight = this.furnaceInventory.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 56, y + 36 + 12 - fireHeight, 176, 12 - fireHeight, 14, fireHeight + 2);
            int arrowWidth = this.furnaceInventory.getCookProgressScaled(24);
            this.drawTexturedModalRect(x + 79, y + 34, 176, 14, arrowWidth + 1, 16);
        }
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        controller.inventoryHandler.handleFurnace(this);
    }
}

