/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicActivator
extends BlockLogicVeryRotatable {
    public static final int MASK_POWERED = 8;

    public BlockLogicActivator(@NotNull Block<?> block) {
        super(block, Materials.NETHERRACK);
        block.withEntity(TileEntityActivator::new);
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            @NotNull TileEntityActivator tileEntityActivator = (TileEntityActivator)Objects.requireNonNull(world.getTileEntity(tilePos));
            player.displayActivatorScreen(tileEntityActivator);
        }
        return true;
    }

    private void useItem(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random random) {
        @NotNull Direction direction = BlockLogicRotatable.getDirectionFromMeta(world.getBlockData(tilePos));
        @NotNull TileEntityActivator activator = (TileEntityActivator)Objects.requireNonNull(world.getTileEntity(tilePos));
        if (!activator.locked(activator.stackSelector)) {
            @Nullable ItemStack itemStack = activator.getNextStack();
            double px = (double)direction.getOffsetX() * 0.6 + 0.5;
            double py = (double)direction.getOffsetY() * 0.6 + 0.5;
            double pz = (double)direction.getOffsetZ() * 0.6 + 0.5;
            if (itemStack == null) {
                @Nullable Block<?> block = world.getBlockType(tilePos.add(direction, new TilePos()));
                if (block != null) {
                    block.onActivatorInteracted(world, tilePos.add(direction, new TilePos()), activator, direction);
                } else {
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, tilePos.x(), tilePos.y(), tilePos.z(), "tile.activator.click", 1.0f, 1.0f);
                }
            } else {
                @NotNull Item item = itemStack.getItem();
                item.onUseByActivator(itemStack, world, activator, random, tilePos, direction, px, py, pz);
                activator.nullDeadItems();
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, tilePos.x(), tilePos.y(), tilePos.z(), "tile.activator.use", 1.0f, 1.0f);
                world.playBlockEvent(tilePos, 2000, direction.getId());
            }
        } else {
            activator.shiftSelector();
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        boolean isPowered;
        int meta = world.getBlockData(tilePos);
        boolean hasSignal = this.getNeighborSignal(world, tilePos, BlockLogicRotatable.getDirectionFromMeta(meta));
        boolean bl = isPowered = (meta & 8) != 0;
        if (hasSignal && !isPowered) {
            world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
            world.setBlockDataNotify(tilePos, meta | 8);
        } else if (!hasSignal && isPowered) {
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF7);
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.useItem(world, tilePos, rand);
    }

    private boolean getNeighborSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction) {
        TilePos queryPos = new TilePos();
        if (direction != Direction.DOWN && world.hasSignal(tilePos.add(Direction.DOWN, queryPos), Side.BOTTOM)) {
            return true;
        }
        if (direction != Direction.UP && world.hasSignal(tilePos.add(Direction.UP, queryPos), Side.TOP)) {
            return true;
        }
        if (direction != Direction.NORTH && world.hasSignal(tilePos.add(Direction.NORTH, queryPos), Side.NORTH)) {
            return true;
        }
        if (direction != Direction.SOUTH && world.hasSignal(tilePos.add(Direction.SOUTH, queryPos), Side.SOUTH)) {
            return true;
        }
        if (direction != Direction.EAST && world.hasSignal(tilePos.add(Direction.EAST, queryPos), Side.EAST)) {
            return true;
        }
        if (direction != Direction.WEST && world.hasSignal(tilePos.add(Direction.WEST, queryPos), Side.WEST)) {
            return true;
        }
        return world.hasSignal(tilePos, Side.BOTTOM);
    }
}

