/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class BlockLogicRubyglassGrowth
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;

    public BlockLogicRubyglassGrowth(Block<?> block) {
        super(block, Materials.PLANT);
        block.setTicking(true);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull TilePos temp = new TilePos();
        if (side == Side.NORTH && world.isBlockNormalCube(tilePos.south(temp)) || side == Side.SOUTH && world.isBlockNormalCube(tilePos.north(temp)) || side == Side.EAST && world.isBlockNormalCube(tilePos.west(temp)) || side == Side.WEST && world.isBlockNormalCube(tilePos.east(temp)) || side == Side.BOTTOM && world.isBlockNormalCube(tilePos.up(temp)) || side == Side.TOP && world.isBlockNormalCube(tilePos.down(temp))) {
            world.setBlockDataNotify(tilePos, BlockLogicRotatable.setDirection(0, side.getDirection()));
        } else {
            world.setBlockDataNotify(tilePos, BlockLogicRotatable.setDirection(0, this.getOrientation(world, tilePos)));
        }
    }

    private Direction getOrientation(World world, TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        if (world.isBlockNormalCube(tilePos.west(temp))) {
            return Side.EAST.getDirection();
        }
        if (world.isBlockNormalCube(tilePos.east(temp))) {
            return Side.WEST.getDirection();
        }
        if (world.isBlockNormalCube(tilePos.south(temp))) {
            return Side.NORTH.getDirection();
        }
        if (world.isBlockNormalCube(tilePos.north(temp))) {
            return Side.SOUTH.getDirection();
        }
        if (world.isBlockNormalCube(tilePos.down(temp))) {
            return Side.TOP.getDirection();
        }
        if (world.isBlockNormalCube(tilePos.up(temp))) {
            return Side.BOTTOM.getDirection();
        }
        return Side.TOP.getDirection();
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        boolean invalid;
        int meta = world.getBlockData(tilePos);
        Direction dir = BlockLogicRubyglassGrowth.metaToDirection(meta);
        @NotNull TilePos temp = new TilePos();
        switch (dir) {
            case EAST: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.west(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.east(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.north(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NORTH: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.south(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case DOWN: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.up(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case UP: {
                boolean bl;
                if (!world.isBlockNormalCube(tilePos.down(temp))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = invalid = false;
            }
        }
        if (invalid) {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @Nullable
    public AABBd getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    public boolean mayPlaceOnBlockAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return world.isBlockNormalCube(tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        if (this.mayPlaceOnBlockAt(world, tilePos.south(temp))) {
            return true;
        }
        if (this.mayPlaceOnBlockAt(world, tilePos.north(temp))) {
            return true;
        }
        if (this.mayPlaceOnBlockAt(world, tilePos.west(temp))) {
            return true;
        }
        if (this.mayPlaceOnBlockAt(world, tilePos.east(temp))) {
            return true;
        }
        if (this.mayPlaceOnBlockAt(world, tilePos.up(temp))) {
            return true;
        }
        return this.mayPlaceOnBlockAt(world, tilePos.down(temp));
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        return world.isBlockNormalCube(tilePos.south(temp)) || world.isBlockNormalCube(tilePos.north(temp)) || world.isBlockNormalCube(tilePos.west(temp)) || world.isBlockNormalCube(tilePos.east(temp)) || world.isBlockNormalCube(tilePos.up(temp)) || world.isBlockNormalCube(tilePos.down(temp));
    }

    public static void setDefaultDirection(World world, TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        if (world.isClientSide) {
            return;
        }
        Direction direction = Direction.UP;
        if (world.isBlockNormalCube(tilePos.north(temp))) {
            direction = Direction.SOUTH;
        } else if (world.isBlockNormalCube(tilePos.south(temp))) {
            direction = Direction.NORTH;
        } else if (world.isBlockNormalCube(tilePos.west(temp))) {
            direction = Direction.EAST;
        } else if (world.isBlockNormalCube(tilePos.east(temp))) {
            direction = Direction.WEST;
        } else if (world.isBlockNormalCube(tilePos.up(temp))) {
            direction = Direction.DOWN;
        }
        world.setBlockDataNotify(tilePos, direction.getId());
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.RUBYGLASS_CRYSTAL_CRACKED)};
    }

    public static Direction metaToDirection(int meta) {
        return Direction.getDirectionById(meta & 7);
    }
}

