/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import java.util.Arrays;
import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Constant2D
implements Noise2D {
    @NotNull
    private final Vector2dc range;
    protected final double value;

    public Constant2D(double value) {
        this.value = value;
        this.range = new Vector2d(value);
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return this.range;
    }

    @Override
    public double getValue(double x, double z) {
        return this.value;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        Arrays.fill(out, this.value);
        return out;
    }
}

