/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.datagen;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryDyeing;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryUndyeing;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.datagen.recipeBuilders.RecipeBuilder;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderShaped;

class WorkbenchGenerator {
    WorkbenchGenerator() {
    }

    public static void generate() {
        WorkbenchGenerator.generatePickaxes();
        WorkbenchGenerator.generateAxes();
        WorkbenchGenerator.generateShovels();
        WorkbenchGenerator.generateHoes();
        WorkbenchGenerator.generateSwords();
        WorkbenchGenerator.generateMiscTools();
        WorkbenchGenerator.generateHelmets();
        WorkbenchGenerator.generateChestPlates();
        WorkbenchGenerator.generateLeggings();
        WorkbenchGenerator.generateBoots();
        WorkbenchGenerator.generateBlockCompression();
        WorkbenchGenerator.generateBlockDecompression();
        WorkbenchGenerator.generateBricks();
        WorkbenchGenerator.generateSlabs();
        WorkbenchGenerator.generateStairs();
        WorkbenchGenerator.generateDoors();
        WorkbenchGenerator.generateSigns();
        WorkbenchGenerator.generateTrapDoors();
        WorkbenchGenerator.generateFences();
        WorkbenchGenerator.generateFenceGates();
        WorkbenchGenerator.generateChests();
        WorkbenchGenerator.generatePolishedStones();
        WorkbenchGenerator.generateLogToPlanks();
        WorkbenchGenerator.generateDyes();
        WorkbenchGenerator.generateInformationals();
        WorkbenchGenerator.generateRedstoneComponents();
        WorkbenchGenerator.generateFoods();
        WorkbenchGenerator.generateScrapRecipes();
        WorkbenchGenerator.generateRepairableRecipes();
        WorkbenchGenerator.generateToolRecipes();
        WorkbenchGenerator.generateUndyeingRecipes();
        WorkbenchGenerator.generateDyeingRecipes();
        WorkbenchGenerator.generateStatueRecipes();
        RecipeBuilder.Shaped("minecraft").setShape("CCW", "PPP").addInput('C', Items.CLOTH).addInput('W', "minecraft:wools").addInput('P', "minecraft:planks").create("bed", Items.BED.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "X X").addInput('#', Items.CLOTH).addInput('X', "minecraft:planks").create("seat", Items.SEAT.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "X X", "XXX").addInput('#', Items.LEATHER).addInput('X', Items.WHEAT).create("basket", Items.BASKET.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("#", "#", "#").addInput('#', Items.PAPER).create("book_vertical", Items.BOOK.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###").addInput('#', Items.PAPER).create("book_horizontal", Items.BOOK.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "XXX", "###").addInput('#', "minecraft:planks").addInput('X', Items.BOOK).create("bookshelf", new ItemStack(Blocks.BOOKSHELF_PLANKS_OAK, 4));
        RecipeBuilder.Shaped("minecraft").setShape("X X", "X#X").addInput('X', Items.INGOT_IRON).addInput('#', Blocks.COBBLE_NETHERRACK).create("brazier", Blocks.BRAZIER_INACTIVE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "#X#", "###").addInput('#', Items.INGOT_IRON).addInput('X', Items.NETHERCOAL).create("blast_furnace", Blocks.FURNACE_BLAST_IDLE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "# #", "###").addInput('#', "minecraft:cobblestones").create("furnace", Blocks.FURNACE_STONE_IDLE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "#B#", "#R#").addInput('#', "minecraft:cobblestones").addInput('B', Items.TOOL_BOW).addInput('R', Items.DUST_REDSTONE).create("dispenser", Blocks.DISPENSER_COBBLE_STONE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("#S#", "#N#", "#R#").addInput('#', Blocks.COBBLE_NETHERRACK).addInput('S', Blocks.SOULSAND).addInput('N', Items.RUBYGLASS_CRYSTAL_PURE).addInput('R', Items.DUST_REDSTONE).create("activator", Blocks.ACTIVATOR_COBBLE_NETHERRACK.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "#D#", "###").addInput('#', "minecraft:planks").addInput('D', Items.DIAMOND).create("jukebox", Blocks.JUKEBOX.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "XXX", "XXX").addInput('X', Items.STRING).create("cobweb", Blocks.COBWEB.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("X", "X").addInput('X', "minecraft:planks").create("stick", new ItemStack(Items.STICK, 4));
        RecipeBuilder.Shaped("minecraft").setShape("###").addInput('#', Items.SUGARCANE).create("paper", new ItemStack(Items.PAPER, 6));
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "XWX", "XXX").addInput('X', Items.STICK).addInput('W', "minecraft:wools").create("painting", new ItemStack(Items.PAINTING, 1, Items.PAINTING.getMaxDamage()));
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X", "XXX").addInput('X', Items.INGOT_IRON).create("mesh", new ItemStack(Blocks.MESH, 8));
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X", "XXX").addInput('X', Items.INGOT_GOLD).create("mesh_gold", new ItemStack(Blocks.MESH_GOLD, 8));
        RecipeBuilder.Shaped("minecraft").setShape("CCC", "CMC", "LLL").addInput('C', "minecraft:cobblestones").addInput('M', Blocks.MESH).addInput('L', "minecraft:logs").create("trommel", Blocks.TROMMEL_IDLE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("X X", "XXX", "X X").addInput('X', Items.STICK).create("ladder", new ItemStack(Blocks.LADDER_OAK, 2));
        RecipeBuilder.Shaped("minecraft").setShape("# #", " # ").addInput('#', Blocks.GLASS).create("jar", new ItemStack(Items.JAR, 4));
        RecipeBuilder.Shaped("minecraft").setShape("#XX", "#XX", "#  ").addInput('#', Items.STICK).addInput('X', Items.CLOTH).create("flag", Items.FLAG.getDefaultStack());
        RecipeBuilderShaped shape22 = new RecipeBuilderShaped("minecraft").setShape("##", "##");
        shape22.addInput('#', Items.DUST_GLOWSTONE).create("glowstone", Blocks.GLOWSTONE.getDefaultStack());
        shape22.addInput('#', Items.CLAY).create("clay_block", Blocks.BLOCK_CLAY.getDefaultStack());
        shape22.addInput('#', Items.AMMO_SNOWBALL).create("snow_block", Blocks.BLOCK_SNOW.getDefaultStack());
        shape22.addInput('#', Items.STRING).create("string_to_wool", Blocks.WOOL.getDefaultStack());
        shape22.addInput('#', Items.AMMO_PEBBLE).create("pebbles_to_cobblestone", Blocks.COBBLE_STONE.getDefaultStack());
        shape22.addInput('#', Blocks.SAND).create("sandstone", new ItemStack(Blocks.SANDSTONE, 2));
        shape22.addInput('#', "minecraft:planks").create("workbench", Blocks.WORKBENCH.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.AMMO_PEBBLE).addInput('X', Items.COAL).create("pebbles_to_basalt", new ItemStack(Blocks.COBBLE_BASALT, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.AMMO_PEBBLE).addInput('X', Items.QUARTZ).create("pebbles_to_granite", new ItemStack(Blocks.COBBLE_GRANITE, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.AMMO_PEBBLE).addInput('X', Blocks.SAND).create("pebbles_to_limestone", new ItemStack(Blocks.COBBLE_LIMESTONE, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.AMMO_PEBBLE).addInput('X', Blocks.ICE).create("pebbles_to_permafrost", new ItemStack(Blocks.COBBLE_PERMAFROST, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Blocks.PERMAFROST).addInput('X', Blocks.ICE).create("perma_ice", new ItemStack(Blocks.PERMAICE, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.AMMO_PEBBLE).addInput('X', Items.FLINT).create("gravel_from_flint_and_pebbles", Blocks.GRAVEL.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("#", "#").addInput('#', Items.STRING).create("rope", new ItemStack(Items.ROPE, 2));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Blocks.GLASS).addInput('X', Items.INGOT_STEEL_CRUDE).create("steel_glass", new ItemStack(Blocks.GLASS_STEEL, 4));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Blocks.GLASS).addInput('X', Items.OLIVINE).create("tinted_glass", new ItemStack(Blocks.GLASS_TINTED, 4));
        RecipeBuilder.Shaped("minecraft").setShape("#X", "X#").addInput('#', Items.PAPER).addInput('X', "minecraft:planks").create("paper_wall", new ItemStack(Blocks.PAPER_WALL, 4));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('#', Items.STICK).addInput('X', Items.COAL).create("torch_coal", new ItemStack(Blocks.TORCH_COAL, 4));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('#', Items.STICK).addInput('X', Items.COAL, 1).create("torch_charcoal", new ItemStack(Blocks.TORCH_COAL, 4));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('#', Items.STICK).addInput('X', Items.NETHERCOAL).create("torch_nethercoal", new ItemStack(Blocks.TORCH_COAL, 8));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('X', Blocks.PUMPKIN_CARVED_IDLE).addInput('#', Blocks.TORCH_COAL).create("carved_pumpkin_to_jack_o_lantern", Blocks.PUMPKIN_CARVED_ACTIVE.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.SPONGE_DRY).addInput(Items.BUCKET_WATER).create("sponge_to_wet_sponge", Blocks.SPONGE_WET.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.PUMICE_DRY).addInput(Items.BUCKET_LAVA).create("pumice_to_wet_pumice", Blocks.PUMICE_WET.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.PUMPKIN).create("pumpkin_to_pumpkin_seeds", new ItemStack(Items.SEEDS_PUMPKIN, 4));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.SLATE).create("slate_to_slate_layers", new ItemStack(Blocks.LAYER_SLATE, 8));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LEAVES_OAK).create("oak_leaves_to_leaf_pile", new ItemStack(Blocks.LAYER_LEAVES_OAK, 8));
        RecipeBuilder.Shaped("minecraft").setShape("##").addInput('#', Items.AMMO_SNOWBALL).create("snowballs_to_snow_layer", new ItemStack(Blocks.LAYER_SNOW, 2));
        RecipeBuilder.Shaped("minecraft").setShape("X", "Y", "Z").addInput('X', Items.FEATHER_CHICKEN).addInput('Y', Items.INGOT_IRON).addInput('Z', Items.STICK).create("paintbrush", new ItemStack(Items.PAINTBRUSH, 1, Items.PAINTBRUSH.getMaxDamage()));
        RecipeBuilder.Shaped("minecraft").setShape("###").addInput('#', Items.INGOT_STEEL_CRUDE).create("crude_steel_to_steel_ingot", Items.INGOT_STEEL.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.INGOT_STEEL).create("steel_ingot_to_crude_steel", new ItemStack(Items.INGOT_STEEL_CRUDE, 3));
        RecipeBuilder.Shaped("minecraft").setShape("#", "#").addInput('#', Blocks.MARBLE).create("marble_pillar", new ItemStack(Blocks.PILLAR_MARBLE, 2));
        RecipeBuilder.Shapeless("minecraft").addInput(Items.PAPER).addInput(new ItemStack(Items.DYE, 1, DyeColor.BLACK.itemMeta)).addInput(Items.STRING).create("blank_label", Items.LABEL.getDefaultStack());
    }

    private static void generatePickaxes() {
        RecipeBuilderShaped pickaxeTemplate = RecipeBuilder.Shaped("minecraft").setShape("XXX", " # ", " # ").addInput('#', Items.STICK);
        pickaxeTemplate.addInput('X', "minecraft:planks").create("wooden_pickaxe", Items.TOOL_PICKAXE_WOOD.getDefaultStack());
        pickaxeTemplate.addInput('X', "minecraft:cobblestones").create("stone_pickaxe", Items.TOOL_PICKAXE_STONE.getDefaultStack());
        pickaxeTemplate.addInput('X', Items.INGOT_IRON).create("iron_pickaxe", Items.TOOL_PICKAXE_IRON.getDefaultStack());
        pickaxeTemplate.addInput('X', Items.INGOT_GOLD).create("golden_pickaxe", Items.TOOL_PICKAXE_GOLD.getDefaultStack());
        pickaxeTemplate.addInput('X', Items.DIAMOND).create("diamond_pickaxe", Items.TOOL_PICKAXE_DIAMOND.getDefaultStack());
        pickaxeTemplate.addInput('X', Items.INGOT_STEEL).create("steel_pickaxe", Items.TOOL_PICKAXE_STEEL.getDefaultStack());
    }

    private static void generateAxes() {
        RecipeBuilderShaped axeTemplate = RecipeBuilder.Shaped("minecraft").setShape("XX", "X#", " #").addInput('#', Items.STICK);
        axeTemplate.addInput('X', "minecraft:planks").create("wooden_axe", Items.TOOL_AXE_WOOD.getDefaultStack());
        axeTemplate.addInput('X', "minecraft:cobblestones").create("stone_axe", Items.TOOL_AXE_STONE.getDefaultStack());
        axeTemplate.addInput('X', Items.INGOT_IRON).create("iron_axe", Items.TOOL_AXE_IRON.getDefaultStack());
        axeTemplate.addInput('X', Items.INGOT_GOLD).create("golden_axe", Items.TOOL_AXE_GOLD.getDefaultStack());
        axeTemplate.addInput('X', Items.DIAMOND).create("diamond_axe", Items.TOOL_AXE_DIAMOND.getDefaultStack());
        axeTemplate.addInput('X', Items.INGOT_STEEL).create("steel_axe", Items.TOOL_AXE_STEEL.getDefaultStack());
    }

    private static void generateShovels() {
        RecipeBuilderShaped shovelTemplate = RecipeBuilder.Shaped("minecraft").setShape("X", "#", "#").addInput('#', Items.STICK);
        shovelTemplate.addInput('X', "minecraft:planks").create("wooden_shovel", Items.TOOL_SHOVEL_WOOD.getDefaultStack());
        shovelTemplate.addInput('X', "minecraft:cobblestones").create("stone_shovel", Items.TOOL_SHOVEL_STONE.getDefaultStack());
        shovelTemplate.addInput('X', Items.INGOT_IRON).create("iron_shovel", Items.TOOL_SHOVEL_IRON.getDefaultStack());
        shovelTemplate.addInput('X', Items.INGOT_GOLD).create("golden_shovel", Items.TOOL_SHOVEL_GOLD.getDefaultStack());
        shovelTemplate.addInput('X', Items.DIAMOND).create("diamond_shovel", Items.TOOL_SHOVEL_DIAMOND.getDefaultStack());
        shovelTemplate.addInput('X', Items.INGOT_STEEL).create("steel_shovel", Items.TOOL_SHOVEL_STEEL.getDefaultStack());
    }

    private static void generateHoes() {
        RecipeBuilderShaped hoeTemplate = RecipeBuilder.Shaped("minecraft").setShape("XX", " #", " #").addInput('#', Items.STICK);
        hoeTemplate.addInput('X', "minecraft:planks").create("wooden_hoe", Items.TOOL_HOE_WOOD.getDefaultStack());
        hoeTemplate.addInput('X', "minecraft:cobblestones").create("stone_hoe", Items.TOOL_HOE_STONE.getDefaultStack());
        hoeTemplate.addInput('X', Items.INGOT_IRON).create("iron_hoe", Items.TOOL_HOE_IRON.getDefaultStack());
        hoeTemplate.addInput('X', Items.INGOT_GOLD).create("golden_hoe", Items.TOOL_HOE_GOLD.getDefaultStack());
        hoeTemplate.addInput('X', Items.DIAMOND).create("diamond_hoe", Items.TOOL_HOE_DIAMOND.getDefaultStack());
        hoeTemplate.addInput('X', Items.INGOT_STEEL).create("steel_hoe", Items.TOOL_HOE_STEEL.getDefaultStack());
    }

    private static void generateSwords() {
        RecipeBuilderShaped sword = RecipeBuilder.Shaped("minecraft").setShape("X", "X", "#").addInput('#', Items.STICK);
        sword.addInput('X', "minecraft:planks").create("wooden_sword", Items.TOOL_SWORD_WOOD.getDefaultStack());
        sword.addInput('X', "minecraft:cobblestones").create("stone_sword", Items.TOOL_SWORD_STONE.getDefaultStack());
        sword.addInput('X', Items.INGOT_IRON).create("iron_sword", Items.TOOL_SWORD_IRON.getDefaultStack());
        sword.addInput('X', Items.INGOT_GOLD).create("golden_sword", Items.TOOL_SWORD_GOLD.getDefaultStack());
        sword.addInput('X', Items.DIAMOND).create("diamond_sword", Items.TOOL_SWORD_DIAMOND.getDefaultStack());
        sword.addInput('X', Items.INGOT_STEEL).create("steel_sword", Items.TOOL_SWORD_STEEL.getDefaultStack());
    }

    private static void generateMiscTools() {
        RecipeBuilderShaped shears = RecipeBuilder.Shaped("minecraft").setShape(" X", "X ");
        shears.addInput('X', Items.INGOT_IRON).create("shears", Items.TOOL_SHEARS.getDefaultStack());
        shears.addInput('X', Items.INGOT_STEEL).create("steel_shears", Items.TOOL_SHEARS_STEEL.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.INGOT_IRON).addInput(Items.FLINT).create("fire_striker", Items.TOOL_FIRESTRIKER_IRON.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.INGOT_STEEL).addInput(Items.FLINT).create("steel_fire_striker", Items.TOOL_FIRESTRIKER_STEEL.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("# #", " # ").addInput('#', Items.INGOT_IRON).create("bucket", Items.BUCKET.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("# #", "###").addInput('#', "minecraft:planks").create("boat", Items.BOAT.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("# #", "###").addInput('#', Items.INGOT_IRON).create("minecart", Items.MINECART.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("A", "B").addInput('A', "minecraft:chests").addInput('B', Items.MINECART).create("minecart_with_chest", Items.MINECART_CHEST.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("A", "B").addInput('A', Blocks.FURNACE_STONE_IDLE).addInput('B', Items.MINECART).create("minecart_with_furnace", Items.MINECART_FURNACE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape(" #X", "# X", " #X").addInput('#', Items.STICK).addInput('X', Items.STRING).create("bow", Items.TOOL_BOW.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("#OO", "#XX", " XX").addInput('#', Items.STRING).addInput('X', Items.LEATHER).addInput('O', Items.CLOTH).create("quiver", new ItemStack(Items.ARMOR_QUIVER, 1, Items.ARMOR_QUIVER.getMaxDamage()));
        RecipeBuilder.Shaped("minecraft").setShape("T", "I", "V").addInput('T', Items.FLINT).addInput('I', Items.STICK).addInput('V', Items.FEATHER_CHICKEN).create("arrow", new ItemStack(Items.AMMO_ARROW, 4));
        RecipeBuilder.Shaped("minecraft").setShape(" X ", "X#X", " X ").addInput('X', Items.AMMO_ARROW).addInput('#', Items.INGOT_GOLD).create("golden_arrow", new ItemStack(Items.AMMO_ARROW_GOLD, 4));
        RecipeBuilder.Shaped("minecraft").setShape("  #", " #S", "# S").addInput('#', Items.STICK).addInput('S', Items.STRING).create("fishing_rod", Items.TOOL_FISHINGROD.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("X  ", "#X ", " #O").addInput('X', "minecraft:logs").addInput('#', Items.INGOT_STEEL).addInput('O', Items.TOOL_BOW).create("hand_cannon", Items.HANDCANNON_UNLOADED.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape(" S ", "#X#", " # ").addInput('S', Items.STRING).addInput('#', Items.INGOT_IRON).addInput('X', Items.GUNPOWDER).create("explosive_charge", new ItemStack(Items.AMMO_CHARGE_EXPLOSIVE, 4));
    }

    private static void generateHelmets() {
        RecipeBuilderShaped helmet = RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X");
        helmet.addInput('X', Items.LEATHER).create("leather_helmet", Items.ARMOR_HELMET_LEATHER.getDefaultStack());
        helmet.addInput('X', Items.INGOT_IRON).create("iron_helmet", Items.ARMOR_HELMET_IRON.getDefaultStack());
        helmet.addInput('X', Items.INGOT_GOLD).create("golden_helmet", Items.ARMOR_HELMET_GOLD.getDefaultStack());
        helmet.addInput('X', Items.DIAMOND).create("diamond_helmet", Items.ARMOR_HELMET_DIAMOND.getDefaultStack());
        helmet.addInput('X', Items.INGOT_STEEL).create("steel_helmet", Items.ARMOR_HELMET_STEEL.getDefaultStack());
    }

    private static void generateChestPlates() {
        RecipeBuilderShaped chestplate = RecipeBuilder.Shaped("minecraft").setShape("X X", "XXX", "XXX");
        chestplate.addInput('X', Items.LEATHER).create("leather_chestplate", Items.ARMOR_CHESTPLATE_LEATHER.getDefaultStack());
        chestplate.addInput('X', Items.INGOT_IRON).create("iron_chestplate", Items.ARMOR_CHESTPLATE_IRON.getDefaultStack());
        chestplate.addInput('X', Items.INGOT_GOLD).create("golden_chestplate", Items.ARMOR_CHESTPLATE_GOLD.getDefaultStack());
        chestplate.addInput('X', Items.DIAMOND).create("diamond_chestplate", Items.ARMOR_CHESTPLATE_DIAMOND.getDefaultStack());
        chestplate.addInput('X', Items.INGOT_STEEL).create("steel_chestplate", Items.ARMOR_CHESTPLATE_STEEL.getDefaultStack());
    }

    private static void generateLeggings() {
        RecipeBuilderShaped leggings = RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X", "X X");
        leggings.addInput('X', Items.LEATHER).create("leather_leggings", Items.ARMOR_LEGGINGS_LEATHER.getDefaultStack());
        leggings.addInput('X', Items.INGOT_IRON).create("iron_leggings", Items.ARMOR_LEGGINGS_IRON.getDefaultStack());
        leggings.addInput('X', Items.INGOT_GOLD).create("golden_leggings", Items.ARMOR_LEGGINGS_GOLD.getDefaultStack());
        leggings.addInput('X', Items.DIAMOND).create("diamond_leggings", Items.ARMOR_LEGGINGS_DIAMOND.getDefaultStack());
        leggings.addInput('X', Items.INGOT_STEEL).create("steel_leggings", Items.ARMOR_LEGGINGS_STEEL.getDefaultStack());
    }

    private static void generateBoots() {
        RecipeBuilderShaped boots = RecipeBuilder.Shaped("minecraft").setShape("X X", "X X");
        boots.addInput('X', Items.LEATHER).create("leather_boots", Items.ARMOR_BOOTS_LEATHER.getDefaultStack());
        boots.addInput('X', Items.INGOT_IRON).create("iron_boots", Items.ARMOR_BOOTS_IRON.getDefaultStack());
        boots.addInput('X', Items.INGOT_GOLD).create("golden_boots", Items.ARMOR_BOOTS_GOLD.getDefaultStack());
        boots.addInput('X', Items.DIAMOND).create("diamond_boots", Items.ARMOR_BOOTS_DIAMOND.getDefaultStack());
        boots.addInput('X', Items.INGOT_STEEL).create("steel_boots", Items.ARMOR_BOOTS_STEEL.getDefaultStack());
    }

    private static void generateBlockCompression() {
        RecipeBuilderShaped block = RecipeBuilder.Shaped("minecraft").setShape("XXX", "XXX", "XXX");
        RecipeBuilderShaped blockFuel = RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X", "XXX");
        block.addInput('X', Items.INGOT_GOLD).create("block_of_gold", Blocks.BLOCK_GOLD.getDefaultStack());
        block.addInput('X', Items.INGOT_IRON).create("block_of_iron", Blocks.BLOCK_IRON.getDefaultStack());
        block.addInput('X', Items.INGOT_STEEL).create("block_of_steel", Blocks.BLOCK_STEEL.getDefaultStack());
        block.addInput('X', Items.DYE, DyeColor.BLUE.itemMeta).create("block_of_lapis_lazuli", Blocks.BLOCK_LAPIS.getDefaultStack());
        block.addInput('X', Items.DUST_REDSTONE).create("block_of_redstone", Blocks.BLOCK_REDSTONE.getDefaultStack());
        block.addInput('X', Items.DIAMOND).create("block_of_diamond", Blocks.BLOCK_DIAMOND.getDefaultStack());
        block.addInput('X', Items.QUARTZ).create("block_of_quartz", Blocks.BLOCK_QUARTZ.getDefaultStack());
        block.addInput('X', Items.SUGARCANE).create("block_of_sugarcane", Blocks.BLOCK_SUGARCANE.getDefaultStack());
        blockFuel.addInput('X', Items.COAL, 0).create("block_of_coal", Blocks.BLOCK_COAL.getDefaultStack());
        blockFuel.addInput('X', Items.COAL, 1).create("block_of_charcoal", Blocks.BLOCK_CHARCOAL.getDefaultStack());
        blockFuel.addInput('X', Items.NETHERCOAL).create("block_of_nethercoal", Blocks.BLOCK_NETHER_COAL.getDefaultStack());
        blockFuel.addInput('X', Items.OLIVINE).create("block_of_olivine", Blocks.BLOCK_OLIVINE.getDefaultStack());
    }

    private static void generateBlockDecompression() {
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_GOLD).create("block_of_gold_to_gold_ingot", new ItemStack(Items.INGOT_GOLD, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_IRON).create("block_of_iron_to_iron_ingot", new ItemStack(Items.INGOT_IRON, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_STEEL).create("block_of_steel_to_steel_ingot", new ItemStack(Items.INGOT_STEEL, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_LAPIS).create("block_of_lapis_lazuli_to_lapis_lazuli", new ItemStack(Items.DYE, 9, DyeColor.BLUE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_REDSTONE).create("block_of_redstone_to_redstone", new ItemStack(Items.DUST_REDSTONE, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_DIAMOND).create("block_of_diamond_to_diamond", new ItemStack(Items.DIAMOND, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_QUARTZ).create("block_of_quartz_to_quartz", new ItemStack(Items.QUARTZ, 9));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_COAL).create("block_of_coal_to_coal", new ItemStack(Items.COAL, 8, 0));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_CHARCOAL).create("block_of_charcoal_to_charcoal", new ItemStack(Items.COAL, 8, 1));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_NETHER_COAL).create("block_of_nethercoal_to_nethercoal", new ItemStack(Items.NETHERCOAL, 8));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.BLOCK_OLIVINE).create("block_of_olivine_to_olivine", new ItemStack(Items.OLIVINE, 8));
    }

    private static void generateBricks() {
        RecipeBuilderShaped bricks = RecipeBuilder.Shaped("minecraft").setShape("XX", "XX");
        int stackSize = 4;
        bricks.addInput('X', Items.BRICK_CLAY).create("clay_bricks", new ItemStack(Blocks.BRICK_CLAY, 4));
        bricks.addInput('X', Items.INGOT_GOLD).create("golden_bricks", new ItemStack(Blocks.BRICK_GOLD, 4));
        bricks.addInput('X', Items.INGOT_IRON).create("iron_bricks", new ItemStack(Blocks.BRICK_IRON, 4));
        bricks.addInput('X', Items.INGOT_STEEL_CRUDE).create("steel_bricks", new ItemStack(Blocks.BRICK_STEEL, 4));
        bricks.addInput('X', Items.DYE, DyeColor.BLUE.itemMeta).create("lapis_lazuli_bricks", new ItemStack(Blocks.BRICK_LAPIS, 4));
        bricks.addInput('X', Blocks.SANDSTONE).create("sandstone_bricks", new ItemStack(Blocks.BRICK_SANDSTONE, 4));
        bricks.addInput('X', Blocks.STONE).create("stone_bricks", new ItemStack(Blocks.BRICK_STONE, 4));
        bricks.addInput('X', Blocks.BASALT).create("basalt_bricks", new ItemStack(Blocks.BRICK_BASALT, 4));
        bricks.addInput('X', Blocks.GRANITE).create("granite_bricks", new ItemStack(Blocks.BRICK_GRANITE, 4));
        bricks.addInput('X', Blocks.LIMESTONE).create("limestone_bricks", new ItemStack(Blocks.BRICK_LIMESTONE, 4));
        bricks.addInput('X', Blocks.MARBLE).create("marble_bricks", new ItemStack(Blocks.BRICK_MARBLE, 4));
        bricks.addInput('X', Blocks.SLATE).create("slate_bricks", new ItemStack(Blocks.BRICK_SLATE, 4));
        bricks.addInput('X', Blocks.PERMAFROST).create("permafrost_bricks", new ItemStack(Blocks.BRICK_PERMAFROST, 4));
        bricks.addInput('X', Blocks.NETHERRACK).create("netherrack_bricks", new ItemStack(Blocks.BRICK_NETHERRACK, 4));
        bricks.addInput('X', Blocks.STONE_POLISHED).create("polished_stone_bricks", new ItemStack(Blocks.BRICK_STONE_POLISHED, 4));
    }

    private static void generateSlabs() {
        RecipeBuilderShaped slabs = RecipeBuilder.Shaped("minecraft").setShape("XXX");
        int stackSize = 6;
        for (DyeColor color : DyeColor.values()) {
            slabs.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_slab", new ItemStack(Blocks.SLAB_PLANKS_PAINTED, 6, color.blockMeta << 4));
        }
        slabs.addInput('X', Blocks.PLANKS_OAK).create("wooden_slab", new ItemStack(Blocks.SLAB_PLANKS_OAK, 6));
        slabs.addInput('X', Blocks.SANDSTONE).create("sandstone_slab", new ItemStack(Blocks.SLAB_SANDSTONE, 6));
        slabs.addInput('X', Blocks.COBBLE_STONE).create("cobbled_stone_slab", new ItemStack(Blocks.SLAB_COBBLE_STONE, 6));
        slabs.addInput('X', Blocks.COBBLE_BASALT).create("cobbled_basalt_slab", new ItemStack(Blocks.SLAB_COBBLE_BASALT, 6));
        slabs.addInput('X', Blocks.COBBLE_GRANITE).create("cobbled_granite_slab", new ItemStack(Blocks.SLAB_COBBLE_GRANITE, 6));
        slabs.addInput('X', Blocks.COBBLE_LIMESTONE).create("cobbled_limestone_slab", new ItemStack(Blocks.SLAB_COBBLE_LIMESTONE, 6));
        slabs.addInput('X', Blocks.COBBLE_PERMAFROST).create("cobbled_permafrost_slab", new ItemStack(Blocks.SLAB_COBBLE_PERMAFROST, 6));
        slabs.addInput('X', Blocks.COBBLE_NETHERRACK).create("cobbled_netherrack_slab", new ItemStack(Blocks.SLAB_COBBLE_NETHERRACK, 6));
        slabs.addInput('X', Blocks.MARBLE).create("marble_slab", new ItemStack(Blocks.SLAB_CAPSTONE_MARBLE, 6));
        slabs.addInput('X', Blocks.STONE_POLISHED).create("polished_stone_slab", new ItemStack(Blocks.SLAB_STONE_POLISHED, 6));
        slabs.addInput('X', Blocks.BRICK_STONE_POLISHED).create("polished_stone_brick_slab", new ItemStack(Blocks.SLAB_BRICK_STONE_POLISHED, 6));
        slabs.addInput('X', Blocks.BASALT_POLISHED).create("polished_basalt_slab", new ItemStack(Blocks.SLAB_BASALT_POLISHED, 6));
        slabs.addInput('X', Blocks.GRANITE_POLISHED).create("polished_granite_slab", new ItemStack(Blocks.SLAB_GRANITE_POLISHED, 6));
        slabs.addInput('X', Blocks.LIMESTONE_POLISHED).create("polished_limestone_slab", new ItemStack(Blocks.SLAB_LIMESTONE_POLISHED, 6));
        slabs.addInput('X', Blocks.PERMAFROST_POLISHED).create("polished_permafrost_slab", new ItemStack(Blocks.SLAB_PERMAFROST_POLISHED, 6));
        slabs.addInput('X', Blocks.NETHERRACK_POLISHED).create("polished_netherrack_slab", new ItemStack(Blocks.SLAB_NETHERRACK_POLISHED, 6));
        slabs.addInput('X', Blocks.BRICK_MARBLE).create("marble_brick_slab", new ItemStack(Blocks.SLAB_BRICK_MARBLE, 6));
        slabs.addInput('X', Blocks.BRICK_STONE).create("stone_brick_slab", new ItemStack(Blocks.SLAB_BRICK_STONE, 6));
        slabs.addInput('X', Blocks.BRICK_BASALT).create("basalt_brick_slab", new ItemStack(Blocks.SLAB_BRICK_BASALT, 6));
        slabs.addInput('X', Blocks.BRICK_GRANITE).create("granite_brick_slab", new ItemStack(Blocks.SLAB_BRICK_GRANITE, 6));
        slabs.addInput('X', Blocks.BRICK_LIMESTONE).create("limestone_brick_slab", new ItemStack(Blocks.SLAB_BRICK_LIMESTONE, 6));
        slabs.addInput('X', Blocks.BRICK_SLATE).create("slate_brick_slab", new ItemStack(Blocks.SLAB_BRICK_SLATE, 6));
        slabs.addInput('X', Blocks.BRICK_CLAY).create("clay_brick_slab", new ItemStack(Blocks.SLAB_BRICK_CLAY, 6));
        slabs.addInput('X', Blocks.BRICK_SANDSTONE).create("brick_sandstone_slab", new ItemStack(Blocks.SLAB_BRICK_SANDSTONE, 6));
        slabs.addInput('X', Blocks.BRICK_PERMAFROST).create("brick_permafrost_slab", new ItemStack(Blocks.SLAB_BRICK_PERMAFROST, 6));
        slabs.addInput('X', Blocks.BRICK_NETHERRACK).create("netherrack_brick_slab", new ItemStack(Blocks.SLAB_BRICK_NETHERRACK, 6));
        slabs.addInput('X', Blocks.BRICK_IRON).create("iron_brick_slab", new ItemStack(Blocks.SLAB_BRICK_IRON, 6));
        slabs.addInput('X', Blocks.BRICK_GOLD).create("gold_brick_slab", new ItemStack(Blocks.SLAB_BRICK_GOLD, 6));
        slabs.addInput('X', Blocks.BRICK_STEEL).create("steel_brick_slab", new ItemStack(Blocks.SLAB_BRICK_STEEL, 6));
        slabs.addInput('X', Blocks.BRICK_LAPIS).create("lapis_brick_slab", new ItemStack(Blocks.SLAB_BRICK_LAPIS, 6));
    }

    private static void generateStairs() {
        RecipeBuilderShaped stairs = RecipeBuilder.Shaped("minecraft").setShape("X  ", "XX ", "XXX");
        int stackSize = 6;
        for (DyeColor color : DyeColor.values()) {
            stairs.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_stairs", new ItemStack(Blocks.STAIRS_PLANKS_PAINTED, 6, color.blockMeta << 4));
        }
        stairs.addInput('X', Blocks.PLANKS_OAK).create("wooden_stairs", new ItemStack(Blocks.STAIRS_PLANKS_OAK, 6));
        stairs.addInput('X', Blocks.SANDSTONE).create("sandstone_stairs", new ItemStack(Blocks.STAIRS_SANDSTONE, 6));
        stairs.addInput('X', Blocks.COBBLE_STONE).create("cobblestone_stairs", new ItemStack(Blocks.STAIRS_COBBLE_STONE, 6));
        stairs.addInput('X', Blocks.COBBLE_BASALT).create("cobbled_basalt_stairs", new ItemStack(Blocks.STAIRS_COBBLE_BASALT, 6));
        stairs.addInput('X', Blocks.COBBLE_GRANITE).create("cobbled_granite_stairs", new ItemStack(Blocks.STAIRS_COBBLE_GRANITE, 6));
        stairs.addInput('X', Blocks.COBBLE_LIMESTONE).create("cobbled_limestone_stairs", new ItemStack(Blocks.STAIRS_COBBLE_LIMESTONE, 6));
        stairs.addInput('X', Blocks.COBBLE_PERMAFROST).create("cobbled_permafrost_stairs", new ItemStack(Blocks.STAIRS_COBBLE_PERMAFROST, 6));
        stairs.addInput('X', Blocks.COBBLE_NETHERRACK).create("cobbled_netherrack_stairs", new ItemStack(Blocks.STAIRS_COBBLE_NETHERRACK, 6));
        stairs.addInput('X', Blocks.BRICK_STONE_POLISHED).create("polished_stone_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_STONE_POLISHED, 6));
        stairs.addInput('X', Blocks.BRICK_MARBLE).create("marble_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_MARBLE, 6));
        stairs.addInput('X', Blocks.BRICK_STONE).create("stone_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_STONE, 6));
        stairs.addInput('X', Blocks.BRICK_BASALT).create("basalt_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_BASALT, 6));
        stairs.addInput('X', Blocks.BRICK_GRANITE).create("granite_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_GRANITE, 6));
        stairs.addInput('X', Blocks.BRICK_LIMESTONE).create("limestone_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_LIMESTONE, 6));
        stairs.addInput('X', Blocks.BRICK_SLATE).create("slate_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_SLATE, 6));
        stairs.addInput('X', Blocks.BRICK_CLAY).create("clay_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_CLAY, 6));
        stairs.addInput('X', Blocks.BRICK_SANDSTONE).create("brick_sandstone_stairs", new ItemStack(Blocks.STAIRS_BRICK_SANDSTONE, 6));
        stairs.addInput('X', Blocks.BRICK_PERMAFROST).create("brick_permafrost_stairs", new ItemStack(Blocks.STAIRS_BRICK_PERMAFROST, 6));
        stairs.addInput('X', Blocks.BRICK_NETHERRACK).create("netherrack_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_NETHERRACK, 6));
        stairs.addInput('X', Blocks.BRICK_IRON).create("iron_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_IRON, 6));
        stairs.addInput('X', Blocks.BRICK_GOLD).create("gold_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_GOLD, 6));
        stairs.addInput('X', Blocks.BRICK_STEEL).create("steel_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_STEEL, 6));
        stairs.addInput('X', Blocks.BRICK_LAPIS).create("lapis_brick_stairs", new ItemStack(Blocks.STAIRS_BRICK_LAPIS, 6));
    }

    private static void generateDoors() {
        RecipeBuilderShaped door = RecipeBuilder.Shaped("minecraft").setShape("XX", "XX", "XX");
        int stackSize = 2;
        for (DyeColor color : DyeColor.values()) {
            door.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_door", new ItemStack(Items.DOOR_OAK_PAINTED, 2, color.itemMeta));
        }
        door.addInput('X', Blocks.PLANKS_OAK).create("wooden_door", new ItemStack(Items.DOOR_OAK, 2));
        door.addInput('X', Blocks.GLASS).create("glass_door", new ItemStack(Items.DOOR_GLASS, 2));
        door.addInput('X', Items.INGOT_IRON).create("iron_door", new ItemStack(Items.DOOR_IRON, 2));
        door.addInput('X', Items.INGOT_STEEL_CRUDE).create("steel_door", new ItemStack(Items.DOOR_STEEL, 2));
    }

    private static void generateSigns() {
        RecipeBuilderShaped sign = RecipeBuilder.Shaped("minecraft").setShape("XXX", "XXX", " # ").addInput('#', Items.STICK);
        int stackSize = 4;
        sign.addInput('X', Blocks.PLANKS_OAK).create("sign", new ItemStack(Items.SIGN, 4));
        for (DyeColor color : DyeColor.values()) {
            sign.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_sign", new ItemStack(Items.SIGN_PAINTED, 4, color.itemMeta));
        }
    }

    private static void generateTrapDoors() {
        RecipeBuilderShaped door = RecipeBuilder.Shaped("minecraft").setShape("XXX", "XXX");
        int stackSize = 6;
        for (DyeColor color : DyeColor.values()) {
            door.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_trapdoor", new ItemStack(Blocks.TRAPDOOR_PLANKS_PAINTED, 6, color.blockMeta << 4));
        }
        door.addInput('X', Blocks.PLANKS_OAK).create("wooden_trapdoor", new ItemStack(Blocks.TRAPDOOR_PLANKS_OAK, 6));
        door.addInput('X', Blocks.GLASS).create("glass_trapdoor", new ItemStack(Blocks.TRAPDOOR_GLASS, 6));
        door.addInput('X', Items.INGOT_IRON).create("iron_trapdoor", new ItemStack(Blocks.TRAPDOOR_IRON, 6));
        door.addInput('X', Items.INGOT_STEEL_CRUDE).create("steel_trapdoor", new ItemStack(Blocks.TRAPDOOR_STEEL, 6));
    }

    private static void generateFences() {
        RecipeBuilderShaped fence = RecipeBuilder.Shaped("minecraft").setShape("X#X", "X#X");
        RecipeBuilderShaped woodenFence = fence.addInput('#', Items.STICK);
        int stackSize = 6;
        for (DyeColor color : DyeColor.values()) {
            woodenFence.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_fence", new ItemStack(Blocks.FENCE_PLANKS_OAK_PAINTED, 6, color.blockMeta));
        }
        woodenFence.addInput('X', Blocks.PLANKS_OAK).create("wooden_fence", new ItemStack(Blocks.FENCE_PLANKS_OAK, 6));
        fence.addInput('X', Items.STICK).addInput('#', Blocks.PAPER_WALL).create("paper_wall_fence", new ItemStack(Blocks.FENCE_PAPER_WALL, 4));
        fence.addInput('X', Items.INGOT_IRON).addInput('#', Items.CHAINLINK).create("chainlink_fence", new ItemStack(Blocks.FENCE_CHAINLINK, 8));
        fence.addInput('X', Items.INGOT_STEEL).addInput('#', Items.INGOT_STEEL_CRUDE).create("steel_fence", new ItemStack(Blocks.FENCE_STEEL, 16));
    }

    private static void generateFenceGates() {
        RecipeBuilderShaped woodenFenceGate = RecipeBuilder.Shaped("minecraft").setShape("#X#", "#X#").addInput('#', Items.STICK);
        int stackSize = 3;
        for (DyeColor color : DyeColor.values()) {
            woodenFenceGate.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_fence_gate", new ItemStack(Blocks.FENCE_GATE_PLANKS_OAK_PAINTED, 3, color.blockMeta << 4));
        }
        woodenFenceGate.addInput('X', Blocks.PLANKS_OAK).create("wooden_fence_gate", new ItemStack(Blocks.FENCE_GATE_PLANKS_OAK, 3));
    }

    private static void generateChests() {
        RecipeBuilderShaped chest = RecipeBuilder.Shaped("minecraft").setShape("XXX", "X X", "XXX");
        for (DyeColor color : DyeColor.values()) {
            chest.addInput('X', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_chest_from_planks", new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED, 1, color.blockMeta << 4));
        }
        chest.addInput('X', Blocks.PLANKS_OAK).create("wooden_chest", Blocks.CHEST_PLANKS_OAK.getDefaultStack());
    }

    private static void generateLogToPlanks() {
        int stackSize = 4;
        String format = "%s_log_to_%s_wooden_planks";
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_OAK).create("oak_log_to_wooden_planks", new ItemStack(Blocks.PLANKS_OAK, 4));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_BIRCH).create(String.format("%s_log_to_%s_wooden_planks", "birch", "white"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.WHITE.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_CHERRY).create(String.format("%s_log_to_%s_wooden_planks", "cherry", "pink"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.PINK.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_EUCALYPTUS).create(String.format("%s_log_to_%s_wooden_planks", "eucalyptus", "orange"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.ORANGE.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_OAK_MOSSY).create(String.format("%s_log_to_%s_wooden_planks", "mossy_oak", "green"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.GREEN.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_PALM).create(String.format("%s_log_to_%s_wooden_planks", "palm", "yellow"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.YELLOW.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_THORN).create(String.format("%s_log_to_%s_wooden_planks", "thorn", "red"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.RED.blockMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.LOG_PINE).create(String.format("%s_log_to_%s_wooden_planks", "pine", "brown"), new ItemStack(Blocks.PLANKS_OAK_PAINTED, 4, DyeColor.BROWN.blockMeta));
    }

    private static void generatePolishedStones() {
        RecipeBuilderShaped shape = RecipeBuilder.Shaped("minecraft").setShape("#", "#");
        String format = "%1$s_to_polished_%1$s";
        int stackSize = 2;
        shape.addInput('#', Blocks.STONE).create(String.format("%1$s_to_polished_%1$s", "stone"), new ItemStack(Blocks.STONE_POLISHED, 2));
        shape.addInput('#', Blocks.BASALT).create(String.format("%1$s_to_polished_%1$s", "basalt"), new ItemStack(Blocks.BASALT_POLISHED, 2));
        shape.addInput('#', Blocks.LIMESTONE).create(String.format("%1$s_to_polished_%1$s", "limestone"), new ItemStack(Blocks.LIMESTONE_POLISHED, 2));
        shape.addInput('#', Blocks.GRANITE).create(String.format("%1$s_to_polished_%1$s", "granite"), new ItemStack(Blocks.GRANITE_POLISHED, 2));
        shape.addInput('#', Blocks.SLATE).create(String.format("%1$s_to_polished_%1$s", "slate"), new ItemStack(Blocks.SLATE_POLISHED, 2));
        shape.addInput('#', Blocks.PERMAFROST).create(String.format("%1$s_to_polished_%1$s", "permafrost"), new ItemStack(Blocks.PERMAFROST_POLISHED, 2));
        shape.addInput('#', Blocks.NETHERRACK).create(String.format("%1$s_to_polished_%1$s", "netherrack"), new ItemStack(Blocks.NETHERRACK_POLISHED, 2));
    }

    private static void generateInformationals() {
        RecipeBuilderShaped info = RecipeBuilder.Shaped("minecraft").setShape(" X ", "X#X", " X ").addInput('#', Items.DUST_REDSTONE);
        info.addInput('X', "minecraft:planks").create("rotary_calendar", Items.TOOL_CALENDAR.getDefaultStack());
        info.addInput('X', Items.INGOT_IRON).create("compass", Items.TOOL_COMPASS.getDefaultStack());
        info.addInput('X', Items.INGOT_GOLD).create("clock", Items.TOOL_CLOCK.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("###", "###", "###").addInput('#', Items.PAPER).create("map", Items.MAP.getDefaultStack());
    }

    private static void generateFoods() {
        RecipeBuilder.Shaped("minecraft").setShape("# #", " # ").addInput('#', "minecraft:planks").create("bowl", Items.BOWL.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.BOWL).addInput(Blocks.MUSHROOM_BROWN).addInput(Blocks.MUSHROOM_RED).create("mushroom_stew", Items.FOOD_STEW_MUSHROOM.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("XXX").addInput('X', Items.WHEAT).create("dough", Items.DOUGH.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.DOUGH).addInput(Items.DUST_SUGAR).addInput(new ItemStack(Items.DYE, 1, DyeColor.BROWN.itemMeta)).create("cookie", new ItemStack(Items.FOOD_COOKIE, 16));
        RecipeBuilderShaped cake = RecipeBuilder.Shaped("minecraft").setShape("AAA", "BEB", "CCC").setConsumeContainer(false);
        cake.addInput('A', Items.BUCKET_MILK).addInput('B', Items.DUST_SUGAR).addInput('E', Items.EGG_CHICKEN).addInput('C', Items.DOUGH).create("cake", Items.FOOD_CAKE.getDefaultStack());
        cake.addInput('A', Items.BUCKET_MILK).addInput('B', Items.DUST_SUGAR).addInput('E', Blocks.PUMPKIN).addInput('C', Items.DOUGH).create("pumpkin_pie", Items.FOOD_PUMPKIN_PIE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "X#X", "XXX").addInput('X', Blocks.BLOCK_GOLD).addInput('#', Items.FOOD_APPLE).create("golden_apple", Items.FOOD_APPLE_GOLD.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape(" Y ", "#O#", " X ").addInput('Y', Items.FOOD_CHERRY).addInput('O', new ItemStack(Items.DYE, 1, DyeColor.BROWN.itemMeta)).addInput('#', Items.AMMO_SNOWBALL).addInput('X', Items.BUCKET_MILK).setConsumeContainer(true).create("ice_cream_bucket", Items.BUCKET_ICECREAM.getDefaultStack());
        RecipeBuilder.Shapeless("minecraft").addInput(Items.SUGARCANE).create("sugar_cane_to_sugar", new ItemStack(Items.DUST_SUGAR, 3));
    }

    private static void generateDyes() {
        RecipeBuilder.Shapeless("minecraft").addInput(Items.BONE).create("bone_to_dye", new ItemStack(Items.DYE, 3, DyeColor.WHITE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("red_dye_white_dye_to_pink_dye", new ItemStack(Items.DYE, 2, DyeColor.PINK.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.YELLOW.itemMeta)).create("red_dye_yellow_dye_to_orange_dye", new ItemStack(Items.DYE, 2, DyeColor.ORANGE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.GREEN.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("green_dye_white_dye_to_lime_dye", new ItemStack(Items.DYE, 2, DyeColor.LIME.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLACK.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("black_dye_white_dye_to_gray_dye", new ItemStack(Items.DYE, 2, DyeColor.GRAY.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.GRAY.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("gray_dye_white_dye_to_light_gray_dye", new ItemStack(Items.DYE, 2, DyeColor.SILVER.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.GRAY.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.GRAY.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("white_dye_gray_dye_gray_dye_to_light_gray_dye", new ItemStack(Items.DYE, 3, DyeColor.SILVER.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLUE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("blue_dye_white_dye_to_light_blue_dye", new ItemStack(Items.DYE, 2, DyeColor.LIGHT_BLUE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLUE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.GREEN.itemMeta)).create("blue_dye_green_dye_to_cyan_dye", new ItemStack(Items.DYE, 2, DyeColor.CYAN.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLUE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).create("blue_dye_red_dye_to_purple_dye", new ItemStack(Items.DYE, 2, DyeColor.PURPLE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.PURPLE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.PINK.itemMeta)).create("purple_dye_pink_dye_to_magenta_dye", new ItemStack(Items.DYE, 2, DyeColor.MAGENTA.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLUE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.PINK.itemMeta)).create("blue_dye_red_dye_pink_dye_to_magenta_dye", new ItemStack(Items.DYE, 3, DyeColor.MAGENTA.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(new ItemStack(Items.DYE, 1, DyeColor.BLUE.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.RED.itemMeta)).addInput(new ItemStack(Items.DYE, 1, DyeColor.WHITE.itemMeta)).create("blue_dye_red_dye_red_dye_white_dye_to_magenta_dye", new ItemStack(Items.DYE, 4, DyeColor.MAGENTA.itemMeta));
        int stackSize = 2;
        String formatFlower = "flower_%s_to_dye";
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_RED).create(String.format("flower_%s_to_dye", "red"), new ItemStack(Items.DYE, 2, DyeColor.RED.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_YELLOW).create(String.format("flower_%s_to_dye", "yellow"), new ItemStack(Items.DYE, 2, DyeColor.YELLOW.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_ORANGE).create(String.format("flower_%s_to_dye", "orange"), new ItemStack(Items.DYE, 2, DyeColor.ORANGE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_PINK).create(String.format("flower_%s_to_dye", "pink"), new ItemStack(Items.DYE, 2, DyeColor.PINK.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_PURPLE).create(String.format("flower_%s_to_dye", "purple"), new ItemStack(Items.DYE, 2, DyeColor.PURPLE.itemMeta));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.FLOWER_LIGHT_BLUE).create(String.format("flower_%s_to_dye", "lightblue"), new ItemStack(Items.DYE, 2, DyeColor.LIGHT_BLUE.itemMeta));
    }

    private static void generateRedstoneComponents() {
        RecipeBuilderShaped plate = RecipeBuilder.Shaped("minecraft").setShape("##");
        plate.addInput('#', Blocks.STONE).create("stone_pressure_plate", Blocks.PRESSURE_PLATE_STONE.getDefaultStack());
        plate.addInput('#', Blocks.PLANKS_OAK).create("wooden_pressure_plate", Blocks.PRESSURE_PLATE_PLANKS_OAK.getDefaultStack());
        plate.addInput('#', "minecraft:cobblestones").create("cobblestone_pressure_plate", Blocks.PRESSURE_PLATE_COBBLE_STONE.getDefaultStack());
        for (DyeColor color : DyeColor.values()) {
            plate.addInput('#', Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_pressure_plate", new ItemStack(Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED, 1, color.blockMeta << 4));
        }
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "XRX", "XXX").addInput('X', "minecraft:planks").addInput('R', Items.DUST_REDSTONE).create("note_block", Blocks.NOTEBLOCK.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "#I#", "#R#").addInput('X', "minecraft:planks").addInput('#', "minecraft:cobblestones").addInput('I', Items.INGOT_IRON).addInput('R', Items.DUST_REDSTONE).create("piston", new ItemStack(Blocks.PISTON_BASE));
        RecipeBuilder.Shaped("minecraft").setShape("S", "P").addInput('S', Items.SLIMEBALL).addInput('P', Blocks.PISTON_BASE).create("sticky_piston", Blocks.PISTON_BASE_STICKY.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("XXX", "#I#", "#R#").addInput('X', Items.INGOT_STEEL_CRUDE).addInput('#', "minecraft:stones").addInput('I', Items.INGOT_STEEL).addInput('R', Items.DUST_REDSTONE).create("steel_piston", Blocks.PISTON_BASE_STEEL.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("X#X", "#X#", "X#X").addInput('X', Items.GUNPOWDER).addInput('#', Blocks.SAND).create("tnt", new ItemStack(Blocks.TNT));
        RecipeBuilder.Shapeless("minecraft").addInput("minecraft:stones").create("stone_button", new ItemStack(Blocks.BUTTON_STONE, 4));
        RecipeBuilder.Shapeless("minecraft").addInput(Blocks.PLANKS_OAK).create("wooden_button", new ItemStack(Blocks.BUTTON_PLANKS, 4));
        for (DyeColor color : DyeColor.values()) {
            RecipeBuilder.Shapeless("minecraft").addInput(Blocks.PLANKS_OAK_PAINTED, color.blockMeta).create(color.colorID + "_wooden_button", new ItemStack(Blocks.BUTTON_PLANKS_PAINTED, 4, color.blockMeta << 4));
        }
        RecipeBuilder.Shaped("minecraft").setShape("S", "C").addInput('S', Items.STICK).addInput('C', "minecraft:cobblestones").create("cobblestone_lever", new ItemStack(Blocks.LEVER_COBBLE_STONE, 2));
        RecipeBuilder.Shaped("minecraft").setShape("###", "#O#", "#X#").addInput('#', Blocks.GLASS).addInput('O', Items.QUARTZ).addInput('X', Items.DUST_REDSTONE).create("lamp", new ItemStack(Blocks.LAMP_IDLE, 4));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('X', Items.DUST_REDSTONE).addInput('#', Items.STICK).create("redstone_torch", new ItemStack(Blocks.TORCH_REDSTONE_ACTIVE, 1));
        RecipeBuilder.Shaped("minecraft").setShape("#X#", "III").addInput('#', Blocks.TORCH_REDSTONE_ACTIVE).addInput('X', Items.DUST_REDSTONE).addInput('I', "minecraft:stones").create("redstone_repeater", new ItemStack(Items.REPEATER, 1));
        RecipeBuilder.Shaped("minecraft").setShape("X", "#").addInput('X', Blocks.PUMPKIN_CARVED_IDLE).addInput('#', Blocks.TORCH_REDSTONE_ACTIVE).create("carved_pumpkin_to_redstone_jack_o_lantern", Blocks.PUMPKIN_REDSTONE.getDefaultStack());
        RecipeBuilder.Shaped("minecraft").setShape("X X", "X#X", "X X").addInput('#', Items.STICK).addInput('X', Items.INGOT_IRON).create("rail", new ItemStack(Blocks.RAIL, 16));
        RecipeBuilder.Shaped("minecraft").setShape("X X", "X#X", "XRX").addInput('#', Items.STICK).addInput('X', Items.INGOT_GOLD).addInput('R', Items.DUST_REDSTONE).create("powered_rail", new ItemStack(Blocks.RAIL_POWERED, 8));
        RecipeBuilder.Shaped("minecraft").setShape("X X", "X#X", "XRX").addInput('#', "minecraft:pressureplates").addInput('X', Items.INGOT_IRON).addInput('R', Items.DUST_REDSTONE).create("detector_rail", new ItemStack(Blocks.RAIL_DETECTOR, 8));
        RecipeBuilder.Shaped("minecraft").setShape(" # ", "#X#", "YYY").addInput('#', Items.INGOT_IRON).addInput('X', Items.DUST_REDSTONE).addInput('Y', "minecraft:cobblestones").create("spikes", new ItemStack(Blocks.SPIKES, 4));
        RecipeBuilder.Shaped("minecraft").setShape("#Q#", "#S#", "#R#").addInput('#', Blocks.COBBLE_NETHERRACK).addInput('Q', Items.QUARTZ).addInput('R', Items.RUBYGLASS_CRYSTAL_PURE).addInput('S', Blocks.SOULSAND).create("matcher", new ItemStack(Blocks.MATCHER, 1));
        RecipeBuilder.Shaped("minecraft").setShape("XX", "XX").addInput('X', Items.RUBYGLASS_CRYSTAL_CRACKED).create("rubyglass", new ItemStack(Blocks.RUBYGLASS, 1));
        RecipeBuilder.Shaped("minecraft").setShape("XX", "XX").addInput('X', Items.RUBYGLASS_CRYSTAL_PURE).create("rubyglass_pure", new ItemStack(Blocks.RUBYGLASS_PURE, 1));
        RecipeBuilder.Shaped("minecraft").setShape("XOX", "OOO", "XOX").addInput('O', Items.RUBYGLASS_CRYSTAL_PURE).addInput('X', Blocks.COBBLE_NETHERRACK).create("rubyglass_circuit", new ItemStack(Blocks.RUBYGLASS_CIRCUIT, 1));
        RecipeBuilder.Shaped("minecraft").setShape("###", "#RB", "###").addInput('#', Blocks.COBBLE_NETHERRACK).addInput('R', Items.RUBYGLASS_CRYSTAL_PURE).addInput('B', Items.BONE).create("motion_sensor", Blocks.MOTION_SENSOR_IDLE.getDefaultStack());
    }

    private static void generateScrapRecipes() {
        Registries.RECIPES.WORKBENCH.register("scrap_chainmail_boots", new RecipeEntryScrap(Items.ARMOR_BOOTS_CHAINMAIL, Items.CHAINLINK, 4));
        Registries.RECIPES.WORKBENCH.register("scrap_chainmail_leggings", new RecipeEntryScrap(Items.ARMOR_LEGGINGS_CHAINMAIL, Items.CHAINLINK, 4));
        Registries.RECIPES.WORKBENCH.register("scrap_chainmail_chestplate", new RecipeEntryScrap(Items.ARMOR_CHESTPLATE_CHAINMAIL, Items.CHAINLINK, 4));
        Registries.RECIPES.WORKBENCH.register("scrap_chainmail_helmet", new RecipeEntryScrap(Items.ARMOR_HELMET_CHAINMAIL, Items.CHAINLINK, 4));
    }

    private static void generateRepairableRecipes() {
        Registries.RECIPES.WORKBENCH.register("repair_chainmail_boots", new RecipeEntryRepairable(Items.ARMOR_BOOTS_CHAINMAIL.getDefaultStack(), new RecipeSymbol(Items.CHAINLINK.getDefaultStack())));
        Registries.RECIPES.WORKBENCH.register("repair_chainmail_leggings", new RecipeEntryRepairable(Items.ARMOR_LEGGINGS_CHAINMAIL.getDefaultStack(), new RecipeSymbol(Items.CHAINLINK.getDefaultStack())));
        Registries.RECIPES.WORKBENCH.register("repair_chainmail_chestplate", new RecipeEntryRepairable(Items.ARMOR_CHESTPLATE_CHAINMAIL.getDefaultStack(), new RecipeSymbol(Items.CHAINLINK.getDefaultStack())));
        Registries.RECIPES.WORKBENCH.register("repair_chainmail_helmet", new RecipeEntryRepairable(Items.ARMOR_HELMET_CHAINMAIL.getDefaultStack(), new RecipeSymbol(Items.CHAINLINK.getDefaultStack())));
    }

    private static void generateToolRecipes() {
        Registries.RECIPES.WORKBENCH.register("carve_pumpkin_sword", new RecipeEntryCraftingWithTool(new RecipeSymbol(Blocks.PUMPKIN.getDefaultStack()), new RecipeSymbol("minecraft:tool_swords"), new ItemStack(Blocks.PUMPKIN_CARVED_IDLE)));
    }

    private static void generateStatueRecipes() {
        String[] statueNames = new String[]{"stone", "basalt", "limestone", "granite", "marble"};
        Item[] statueItems = new Item[]{Items.STATUE_STONE, Items.STATUE_BASALT, Items.STATUE_LIMESTONE, Items.STATUE_GRANITE, Items.STATUE_MARBLE};
        Block[] statueBodyBlocks = new Block[]{Blocks.STONE, Blocks.BASALT, Blocks.LIMESTONE, Blocks.GRANITE, Blocks.MARBLE};
        Block[] statueBaseBlocks = new Block[]{Blocks.SLAB_STONE_POLISHED, Blocks.SLAB_BASALT_POLISHED, Blocks.SLAB_LIMESTONE_POLISHED, Blocks.SLAB_GRANITE_POLISHED, Blocks.SLAB_CAPSTONE_MARBLE};
        for (int i = 0; i < statueItems.length; ++i) {
            RecipeBuilder.Shaped("minecraft").setShape("#", "#", "_").addInput('#', statueBodyBlocks[i]).addInput('_', statueBaseBlocks[i]).create("statue_" + statueNames[i], new ItemStack(statueItems[i], 1));
        }
    }

    private static void generateUndyeingRecipes() {
        String format = "%s_undyeing";
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:planks"), new ItemStack(Blocks.PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "signs"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:signs"), new ItemStack(Items.SIGN)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "doors"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:doors"), new ItemStack(Items.DOOR_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "stairs_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:stairs_planks"), new ItemStack(Blocks.STAIRS_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "slabs_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:slabs_planks"), new ItemStack(Blocks.SLAB_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "fences_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:fences_planks"), new ItemStack(Blocks.FENCE_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "fence_gates_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:fence_gates_planks"), new ItemStack(Blocks.FENCE_GATE_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "trapdoor_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:trapdoor_planks"), new ItemStack(Blocks.TRAPDOOR_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "lamps"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:lamps"), new ItemStack(Blocks.LAMP_IDLE)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "wools"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:wools"), new ItemStack(Blocks.WOOL)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "chests"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:chests"), new ItemStack(Blocks.CHEST_PLANKS_OAK)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "buttons_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:button_planks"), new ItemStack(Blocks.BUTTON_PLANKS)));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_undyeing", "pressureplates_planks"), new RecipeEntryUndyeing(new RecipeSymbol("minecraft:pressureplates_planks"), new ItemStack(Blocks.PRESSURE_PLATE_PLANKS_OAK)));
    }

    private static void generateDyeingRecipes() {
        String format = "%s_dyeing";
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:planks"), new ItemStack(Blocks.PLANKS_OAK_PAINTED), false, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "signs"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:signs"), new ItemStack(Items.SIGN_PAINTED), false, true));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "doors"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:doors"), new ItemStack(Items.DOOR_OAK_PAINTED), false, true));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "stairs_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:stairs_planks"), new ItemStack(Blocks.STAIRS_PLANKS_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "slabs_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:slabs_planks"), new ItemStack(Blocks.SLAB_PLANKS_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "fences_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:fences_planks"), new ItemStack(Blocks.FENCE_PLANKS_OAK_PAINTED), false, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "fence_gates_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:fence_gates_planks"), new ItemStack(Blocks.FENCE_GATE_PLANKS_OAK_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "trapdoor_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:trapdoor_planks"), new ItemStack(Blocks.TRAPDOOR_PLANKS_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "lamps"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:lamps"), new ItemStack(Blocks.LAMP_IDLE), false, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "wools"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:wools"), new ItemStack(Blocks.WOOL), false, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "chests"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:chests"), new ItemStack(Blocks.CHEST_PLANKS_OAK_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "buttons_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:button_planks"), new ItemStack(Blocks.BUTTON_PLANKS_PAINTED), true, false));
        Registries.RECIPES.WORKBENCH.register(String.format("%s_dyeing", "pressureplates_planks"), new RecipeEntryDyeing(new RecipeSymbol("minecraft:pressureplates_planks"), new ItemStack(Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED), true, false));
    }
}

