/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.syntax;

import com.codewaves.codehighlight.core.StyleRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class HighlightedRenderer
implements StyleRenderer<String> {
    private static final Map<String, TextFormatting> CLASS_NAME_TO_FORMATTING = new HashMap<String, TextFormatting>();
    private static final List<String> KEYWORDS = new ArrayList<String>();
    @NotNull
    private final StringBuilder sb = new StringBuilder();

    @Override
    public void onStart() {
        this.sb.setLength(0);
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onPushStyle(String style) {
        this.sb.append(CLASS_NAME_TO_FORMATTING.getOrDefault(style, TextFormatting.WHITE));
    }

    @Override
    public void onPopStyle() {
        this.sb.append(TextFormatting.WHITE);
    }

    @Override
    public void onPushCodeBlock(CharSequence codeLexeme) {
        if (KEYWORDS.contains(codeLexeme.toString())) {
            this.sb.append(TextFormatting.ORANGE);
        }
        this.sb.append(codeLexeme);
    }

    @Override
    public void onPushSubLanguage(String name, String code) {
        this.sb.append(code);
    }

    @Override
    public void onPushOriginalSubLanguage(String name, CharSequence code) {
        this.sb.append(code);
    }

    @Override
    public void onAbort(CharSequence code, Exception e) {
        this.sb.append(code);
    }

    @Override
    public String getResult() {
        return this.sb.toString();
    }

    static {
        CLASS_NAME_TO_FORMATTING.put("comment", TextFormatting.LIGHT_GRAY);
        CLASS_NAME_TO_FORMATTING.put("string", TextFormatting.GREEN);
        CLASS_NAME_TO_FORMATTING.put("number", TextFormatting.LIGHT_BLUE);
        CLASS_NAME_TO_FORMATTING.put("title", TextFormatting.LIGHT_BLUE);
        CLASS_NAME_TO_FORMATTING.put("regexp", TextFormatting.RED);
        CLASS_NAME_TO_FORMATTING.put("doctag", TextFormatting.GREEN);
        CLASS_NAME_TO_FORMATTING.put("class", TextFormatting.WHITE);
        CLASS_NAME_TO_FORMATTING.put("function", TextFormatting.LIGHT_BLUE);
        CLASS_NAME_TO_FORMATTING.put("params", TextFormatting.WHITE);
        CLASS_NAME_TO_FORMATTING.put("meta", TextFormatting.YELLOW);
        KEYWORDS.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "const", "default", "do", "double", "else", "enum", "exports", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "module", "native", "new", "package", "private", "protected", "public", "requires", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "var", "void", "volatile", "while", "null"));
    }
}

