/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class ScreenMobPicker
extends Screen {
    @NotNull
    private final TilePos tilePos;
    private String mobId;
    private boolean shouldClose = false;

    public ScreenMobPicker(String mobId, @NotNull TilePosc tilePos) {
        this.mobId = mobId;
        this.tilePos = new TilePos(tilePos);
    }

    @Override
    public void init() {
        ArrayList<NamespaceID> monsters = new ArrayList<NamespaceID>();
        for (EntityDispatcher.EntityDispatcherEntry<?> entityDispatcherEntry : EntityDispatcher.getInstance().entries) {
            if (entityDispatcherEntry.entityClass == MobFireflyCluster.class || !Mob.class.isAssignableFrom(entityDispatcherEntry.entityClass) || Modifier.isAbstract(entityDispatcherEntry.entityClass.getModifiers())) continue;
            monsters.add(entityDispatcherEntry.namespaceID);
        }
        Collections.sort(monsters);
        ArrayList<String> prettyMonsters = new ArrayList<String>();
        for (NamespaceID monster : monsters) {
            StringBuilder sb = new StringBuilder();
            for (char c : monster.value().toCharArray()) {
                if (Character.isUpperCase(c)) {
                    sb.append(' ');
                }
                sb.append(c);
            }
            prettyMonsters.add(sb.toString());
        }
        PopupScreen popupScreen = new PopupBuilder(this, 150).withLabel("gui.pick_monster.label.title").withList("list", 140, prettyMonsters.toArray(new String[0]), null, -1, true).closeOnEsc(0).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                this.mobId = ((NamespaceID)monsters.get((Integer)results.get("list"))).toString();
                if (!this.mc.currentWorld.isClientSide) {
                    TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.mc.currentWorld.getTileEntity(this.tilePos);
                    if (spawner == null) {
                        return;
                    }
                    spawner.setMobId(this.mobId);
                } else {
                    this.mc.getSendQueue().addToSendQueue(new PacketSetMobSpawner(this.tilePos, EntityDispatcher.getInstance().entryForId(this.mobId)));
                }
            }
            this.shouldClose = true;
        }).build();
        this.mc.displayScreen(popupScreen);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldClose) {
            this.mc.displayScreen(null);
        }
    }

    public String getMobId() {
        return this.mobId;
    }
}

