/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.ChunkRendererMultiDraw;
import net.minecraft.client.render.terrain.RegionBuffer;
import net.minecraft.client.render.terrain.RenderList;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.tessellator.TessellatorTerrainImpl;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class TerrainRendererMultiDraw
extends TerrainRenderer {
    public static final int VERTEX_BUFFER_INITIAL_CAPACITY = 0x4000000;
    public static final int RENDER_LIST_INITIAL_CAPACITY = 4096;
    public static final int REGION_SIZE = 9;
    public static final int MAX_RENDER_PASSES = 2;
    @NotNull
    public final VertexBuffer vertexBuffer;
    @NotNull
    public final RegionBuffer<TessellatorTerrainImpl.TerrainVertexConfig> regionBuffer;
    @NotNull
    private final TessellatorTerrainImpl.TerrainVertexConfig vertexConfig;
    private final int @NotNull [] drawCalls = new int[2];
    @NotNull
    private final Vector3d renderPos = new Vector3d();
    @NotNull
    private final Vector3d prevSort = new Vector3d();
    @NotNull
    private final Vector3d d = new Vector3d();

    public TerrainRendererMultiDraw(@NotNull Minecraft minecraft) {
        super(minecraft);
        this.vertexConfig = new TessellatorTerrainImpl.TerrainVertexConfig();
        this.vertexBuffer = new VertexBuffer(0x4000000L);
        this.regionBuffer = new RegionBuffer(9);
    }

    @Override
    public void renderSolidTerrain(float partialTicks) {
        Arrays.fill(this.drawCalls, 0);
        @NotNull ICamera camera = Objects.requireNonNull(this.mc.activeCamera);
        camera.getPosition(partialTicks, this.renderPos);
        this.d.set(this.renderPos).sub(this.prevSort);
        if (this.d.dot(this.d) > 64.0) {
            this.prevSort.set(this.renderPos);
            this.mc.renderGlobal.resortChunks(MathHelper.floor(this.renderPos.x), MathHelper.floor(this.renderPos.y), MathHelper.floor(this.renderPos.z));
        }
        this.vertexConfig.enable(this.vertexBuffer.getVao(), this.vertexBuffer.getVbo());
        @NotNull List<@NotNull RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig>> regions = this.regionBuffer.getAllRegions();
        for (RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region : regions) {
            RenderList renderList = region.renderLists[0];
            if (renderList == null || renderList.size() <= 0) continue;
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)((double)(region.posX << 9) - this.renderPos.x), (float)(-this.renderPos.y), (float)((double)(region.posZ << 9) - this.renderPos.z));
            GLRenderer.globalSetUniforms(Shaders.TERRAIN);
            renderList.draw();
            this.drawCalls[0] = this.drawCalls[0] + 1;
            GLRenderer.popFrame();
        }
        this.vertexConfig.disable();
    }

    public void renderAllLists(int renderPass) {
        @NotNull List<@NotNull RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig>> regions = this.regionBuffer.getAllRegions();
        for (RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region : regions) {
            RenderList renderList = region.renderLists[renderPass];
            if (renderList == null || renderList.size() <= 0) continue;
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate((float)((double)(region.posX << 9) - this.renderPos.x), (float)(-this.renderPos.y), (float)((double)(region.posZ << 9) - this.renderPos.z));
            GLRenderer.globalSetUniforms(Shaders.TERRAIN);
            renderList.draw();
            int n = renderPass;
            this.drawCalls[n] = this.drawCalls[n] + 1;
            GLRenderer.popFrame();
        }
    }

    @Override
    public void renderTranslucentTerrain(float partialTicks) {
        this.vertexConfig.enable(this.vertexBuffer.getVao(), this.vertexBuffer.getVbo());
        if (((Boolean)GameSettings.TRANSPARENCY_DEPTH_CHECK.value).booleanValue()) {
            GLRenderer.setColorMask(false, false, false, false);
        }
        this.renderAllLists(1);
        if (((Boolean)GameSettings.TRANSPARENCY_DEPTH_CHECK.value).booleanValue()) {
            GLRenderer.setColorMask(true, true, true, true);
            if (this.drawCalls[1] > 0) {
                this.renderAllLists(1);
            }
        }
        this.vertexConfig.disable();
    }

    public void chunkRendered(@NotNull ChunkRendererMultiDraw chunkRenderer, @NotNull TessellatorTerrainImpl tessellator, int renderPass) {
        tessellator.drawing = false;
        @NotNull RenderList<TessellatorTerrainImpl.TerrainVertexConfig> renderList = this.getOrCreateRenderList(chunkRenderer, renderPass);
        @Nullable VertexBuffer.Entry<TessellatorTerrainImpl.TerrainVertexConfig> entry = renderList.add(tessellator.data, chunkRenderer.visible);
        chunkRenderer.renderListEntries[renderPass] = entry;
    }

    public void chunkVisibilityChanged(@NotNull ChunkRendererMultiDraw chunkRenderer) {
        @NotNull RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region = this.getRenderRegionAtBlockPos(chunkRenderer.pos.x, chunkRenderer.pos.z);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            VertexBuffer.Entry<TessellatorTerrainImpl.TerrainVertexConfig> entry = chunkRenderer.renderListEntries[renderPass];
            if (entry == null) continue;
            RenderList<TessellatorTerrainImpl.TerrainVertexConfig> renderList = region.renderLists[renderPass];
            if (renderList == null) {
                throw new IllegalStateException("Region " + String.valueOf(region) + " does not have a render list for render pass " + renderPass + "!");
            }
            renderList.setVisible(entry, chunkRenderer.visible);
        }
    }

    public void chunkDeleted(@NotNull ChunkRendererMultiDraw chunkRenderer) {
        @NotNull RenderRegion<@NotNull TessellatorTerrainImpl.TerrainVertexConfig> region = this.getRenderRegionAtBlockPos(chunkRenderer.pos.x, chunkRenderer.pos.z);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            VertexBuffer.Entry<TessellatorTerrainImpl.TerrainVertexConfig> entry = chunkRenderer.renderListEntries[renderPass];
            if (entry == null) continue;
            RenderList<TessellatorTerrainImpl.TerrainVertexConfig> renderList = region.renderLists[renderPass];
            if (renderList == null) {
                throw new IllegalStateException("Region " + String.valueOf(region) + " does not have a render list for render pass " + renderPass + "!");
            }
            renderList.remove(entry);
            chunkRenderer.renderListEntries[renderPass] = null;
        }
    }

    @NotNull
    public @NotNull RenderList<@NotNull TessellatorTerrainImpl.TerrainVertexConfig> getOrCreateRenderList(@NotNull ChunkRendererMultiDraw chunkRenderer, int renderPass) {
        return this.getOrCreateRenderList(chunkRenderer.pos.x, chunkRenderer.pos.z, renderPass);
    }

    @NotNull
    public @NotNull RenderList<@NotNull TessellatorTerrainImpl.TerrainVertexConfig> getOrCreateRenderList(int posX, int posZ, int renderPass) {
        @NotNull RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region = this.regionBuffer.getRegionAtBlockPos(posX, posZ);
        RenderList<TessellatorTerrainImpl.TerrainVertexConfig> renderList = region.renderLists[renderPass];
        if (renderList == null) {
            renderList = new RenderList<TessellatorTerrainImpl.TerrainVertexConfig>(this.vertexBuffer, this.vertexConfig, 4096);
            region.renderLists[renderPass] = renderList;
        }
        return renderList;
    }

    @Override
    @NotNull
    public ChunkRenderer createChunkRenderer(@NotNull World world, @NotNull @NotNull List<@NotNull TileEntity> globalRenderableTileEntities, int x, int y, int z, int size) {
        return new ChunkRendererMultiDraw(this, world, globalRenderableTileEntities, x, y, z, size);
    }

    @NotNull
    public RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> getRenderRegionAtBlockPos(int blockX, int blockZ) {
        return this.regionBuffer.getRegionAtBlockPos(blockX, blockZ);
    }

    public int getTotalDrawCalls() {
        int totalDrawCalls = 0;
        for (int drawCall : this.drawCalls) {
            totalDrawCalls += drawCall;
        }
        return totalDrawCalls;
    }
}

