/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard.keys;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.keyboard.keys.Key;
import net.minecraft.client.input.InputType;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class CharKey
extends Key {
    private static final int EXTRAS_HOLD_LENGTH = 300;
    protected boolean renderChar = true;
    protected int lastRadial = 0;
    protected final CharGroup @NotNull [] groups;

    protected CharKey(int x, int y, int width, int height, boolean renderChar, CharGroup @NotNull [] groups2) {
        super(x, y, width, height);
        this.renderChar = renderChar;
        this.groups = groups2;
    }

    @Override
    public void render(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        super.render(mc, keyboard, originX, originY, mouseX, mouseY);
        if (!this.renderChar) {
            return;
        }
        boolean hovered = this.isHovered(originX, originY, mouseX, mouseY);
        int texColor = hovered ? 0xFFFFA0 : 0xE0E0E0;
        CharGroup currentGroup = this.getGroup(keyboard.getGroup());
        CharGroup nextGroup = this.getGroup(keyboard.getShiftedGroup(1));
        CharGroup lastGroup = this.getGroup(keyboard.getShiftedGroup(-1));
        if (lastGroup != currentGroup && lastGroup != nextGroup) {
            GLRenderer.pushFrame();
            GLRenderer.setColor4f(0.75f, 0.75f, 0.75f, 1.0f);
            GLRenderer.modelM4f().translate(this.x + originX + 4, this.y + originY + 2, 0.0f);
            GLRenderer.modelM4f().scale(0.75f, 0.75f, 1.0f);
            this.drawStringCenteredShadow(mc.font, String.valueOf(keyboard.isModifierActive("mod_shift") ? lastGroup.collections[0].upper : lastGroup.collections[0].lower), 0, 0, 0xE0E0E0);
            GLRenderer.popFrame();
        }
        if (nextGroup != currentGroup) {
            GLRenderer.pushFrame();
            GLRenderer.setColor4f(0.75f, 0.75f, 0.75f, 1.0f);
            GLRenderer.modelM4f().translate(this.x + this.width + originX - 4, this.y + originY + 2, 0.0f);
            GLRenderer.modelM4f().scale(0.75f, 0.75f, 1.0f);
            this.drawStringCenteredShadow(mc.font, String.valueOf(keyboard.isModifierActive("mod_shift") ? nextGroup.collections[0].upper : nextGroup.collections[0].lower), 0, 0, 0xE0E0E0);
            GLRenderer.popFrame();
        }
        if (this.getHoldTime() > 300L) {
            double dy;
            double dx;
            double animProgress = MathHelper.clamp((double)(this.getHoldTime() - 300L) / 100.0, 0.0, 1.0);
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.enableState(State.DEPTH_TEST);
            GLRenderer.modelM4f().translate(0.0f, 0.0f, 10.0f);
            int size = (int)(64.0 * animProgress);
            this.drawTexturedIcon(this.x + (this.width - size) / 2 + originX, this.y + (this.height - size) / 2 + originY + 2, size, size, TextureRegistry.getTexture("minecraft:gui/screen/keyboard/radial_background"));
            this.drawStringCenteredShadow(mc.font, String.valueOf(this.getActiveChar(mc, keyboard, originX, originY, mouseX, mouseY)), this.x + this.width / 2 + originX, this.y + mc.font.getFont().fontHeight() / 2 + 4 + originY, texColor);
            if (mc.inputType == InputType.CONTROLLER && mc.controllerInput != null) {
                dx = mc.controllerInput.joyLeft.getX() * 20.0f;
                dy = mc.controllerInput.joyLeft.getY() * 20.0f;
            } else {
                dx = (double)mouseX - ((double)this.x + (double)this.width / 2.0 + (double)originX);
                dy = (double)mouseY - ((double)this.y + (double)this.height / 2.0 + (double)originY);
            }
            int rIndex = this.getRadialIndex(mc, keyboard, dx, dy);
            double r = Math.PI * 2 / (double)currentGroup.collections.length;
            for (int i = 0; i < currentGroup.collections.length; ++i) {
                CharCollection collection = currentGroup.collections[i];
                int charX = MathHelper.floor((double)(this.x + originX) + (double)this.width / 2.0 + Math.cos(r * (double)i - 1.5707963267948966) * 20.0 * animProgress);
                int charY = MathHelper.floor((double)(this.y + originY) + (double)this.height / 2.0 + Math.sin(r * (double)i - 1.5707963267948966) * 20.0 * animProgress) - 3;
                this.drawStringCenteredShadow(mc.font, String.valueOf(keyboard.isModifierActive("mod_shift") ? collection.upper : collection.lower), charX, charY, i == rIndex ? 0xFFFFA0 : 0xE0E0E0);
            }
            GLRenderer.disableState(State.BLEND);
            GLRenderer.popFrame();
        } else {
            this.drawStringCenteredShadow(mc.font, String.valueOf(this.getActiveChar(mc, keyboard, originX, originY, mouseX, mouseY)), this.x + this.width / 2 + originX, this.y + mc.font.getFont().fontHeight() / 2 + 4 + originY, texColor);
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected int getRadialIndex(Minecraft mc, ScreenKeyboard keyboard, double dx, double dy) {
        int radial;
        if (this.getHoldTime() < 300L) {
            this.lastRadial = 0;
            return 0;
        }
        int deadzone = 7;
        if (Math.hypot(dx, dy) < 7.0) {
            return this.lastRadial;
        }
        CharGroup currentGroup = this.getGroup(keyboard.getGroup());
        double r = Math.PI * 2 / (double)currentGroup.collections.length;
        double mouseR = Math.atan2(dy, dx) + 1.5707963267948966 + r / 2.0;
        if (mouseR < 0.0) {
            mouseR += Math.PI * 2;
        }
        this.lastRadial = radial = MathHelper.floor(mouseR / r) % currentGroup.collections.length;
        return radial;
    }

    @Override
    public void pressAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        super.pressAction(mc, keyboard, originX, originY, mouseX, mouseY);
    }

    @Override
    public void releaseAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        super.releaseAction(mc, keyboard, originX, originY, mouseX, mouseY);
        keyboard.typeChar(Keyboard.KEY_NONE, this.getActiveChar(mc, keyboard, originX, originY, mouseX, mouseY));
    }

    protected char getActiveChar(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        double dy;
        double dx;
        CharGroup group = this.getGroup(keyboard.getGroup());
        if (mc.inputType == InputType.CONTROLLER && mc.controllerInput != null) {
            dx = mc.controllerInput.joyLeft.getX() * 20.0f;
            dy = mc.controllerInput.joyLeft.getY() * 20.0f;
        } else {
            dx = (double)mouseX - ((double)this.x + (double)this.width / 2.0 + (double)originX);
            dy = (double)mouseY - ((double)this.y + (double)this.height / 2.0 + (double)originY);
        }
        int rI = this.getRadialIndex(mc, keyboard, dx, dy);
        return keyboard.isModifierActive("mod_shift") ? group.collections[rI].upper : group.collections[rI].lower;
    }

    protected CharGroup getGroup(int group) {
        return group < this.groups.length ? this.groups[group] : this.groups[0];
    }

    @Override
    public boolean isDown(Minecraft mc, ScreenKeyboard keyboard) {
        return super.isDown(mc, keyboard);
    }

    @Override
    public int highestGroup() {
        return this.groups.length - 1;
    }

    protected static class CharGroup {
        protected final CharCollection @NotNull [] collections;

        public CharGroup(CharCollection @NotNull [] collections) {
            this.collections = collections;
        }
    }

    protected static class CharCollection {
        public char lower;
        public char upper;

        public CharCollection(char lower, char upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    public static class CharKeyBuilder {
        private final int x;
        private final int y;
        private int width = 18;
        private int height = 18;
        private Key.ButtonEnum controllerButton = null;
        private boolean renderChar = true;
        private String texUp = "minecraft:gui/widgets/keyboard/key/up";
        private String texDown = "minecraft:gui/widgets/keyboard/key/down";
        private String texUpHovered = "minecraft:gui/widgets/keyboard/key/up_hovered";
        private String texDownHovered = "minecraft:gui/widgets/keyboard/key/down_hovered";
        private final List<CharGroup> groups = new ArrayList<CharGroup>();

        public CharKeyBuilder(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public CharKeyBuilder setWidth(int width) {
            this.width = width;
            return this;
        }

        public CharKeyBuilder setHeight(int height) {
            this.height = height;
            return this;
        }

        public CharKeyBuilder setButton(@Nullable Key.ButtonEnum button) {
            this.controllerButton = button;
            return this;
        }

        public CharKeyBuilder setRenderChar(boolean renderChar) {
            this.renderChar = renderChar;
            return this;
        }

        public CharKeyBuilder setTextures(String keyUp, String keyDown, String keyUpHovered, String keyDownHovered) {
            this.texUp = keyUp;
            this.texDown = keyDown;
            this.texUpHovered = keyUpHovered;
            this.texDownHovered = keyDownHovered;
            return this;
        }

        public CharKeyBuilder addGroup(char c) {
            CharCollection collection = new CharCollection(c, Character.toUpperCase(c));
            this.groups.add(new CharGroup(new CharCollection[]{collection}));
            return this;
        }

        public CharKeyBuilder addGroup(char lower, char upper) {
            CharCollection collection = new CharCollection(lower, upper);
            this.groups.add(new CharGroup(new CharCollection[]{collection}));
            return this;
        }

        public CharKeyBuilder addGroup(char[] ... group) {
            CharCollection[] collections = new CharCollection[group.length];
            for (int i = 0; i < group.length; ++i) {
                char[] arr = group[i];
                collections[i] = arr.length > 1 ? new CharCollection(arr[0], arr[1]) : new CharCollection(arr[0], Character.toUpperCase(arr[0]));
            }
            this.groups.add(new CharGroup(collections));
            return this;
        }

        protected CharKeyBuilder addGroup(CharGroup group) {
            this.groups.add(group);
            return this;
        }

        public CharKey build() {
            CharGroup[] compiledGroups = this.groups.toArray(new CharGroup[0]);
            CharKey key = new CharKey(this.x, this.y, this.width, this.height, this.renderChar, compiledGroups);
            key.setControllerButton(this.controllerButton).setTextures(this.texUp, this.texDown, this.texUpHovered, this.texDownHovered);
            return key;
        }
    }

    public static class Serializer
    implements JsonSerializer<CharKey>,
    JsonDeserializer<CharKey> {
        public static final int DEFAULT_WIDTH = 18;
        public static final int DEFAULT_HEIGHT = 18;
        public static final boolean DEFAULT_RENDER_CHAR = true;
        public static final String DEFAULT_TEXTURE_UP = "minecraft:gui/widgets/keyboard/key/up";
        public static final String DEFAULT_TEXTURE_DOWN = "minecraft:gui/widgets/keyboard/key/down";
        public static final String DEFAULT_TEXTURE_UP_HOVERED = "minecraft:gui/widgets/keyboard/key/up_hovered";
        public static final String DEFAULT_TEXTURE_DOWN_HOVERED = "minecraft:gui/widgets/keyboard/key/down_hovered";

        @Override
        public CharKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            CharKeyBuilder charKeyBuilder = new CharKeyBuilder(obj.get("x").getAsInt(), obj.get("y").getAsInt());
            charKeyBuilder.setWidth(obj.has("width") ? obj.get("width").getAsInt() : 18);
            charKeyBuilder.setHeight(obj.has("height") ? obj.get("height").getAsInt() : 18);
            charKeyBuilder.setButton(obj.has("button") ? Key.ButtonEnum.valueOf(obj.get("button").getAsString().toUpperCase(Locale.ROOT)) : null);
            charKeyBuilder.setRenderChar(obj.has("renderChar") ? obj.get("renderChar").getAsBoolean() : true);
            String texUp = DEFAULT_TEXTURE_UP;
            String texDown = DEFAULT_TEXTURE_DOWN;
            String texUpHovered = DEFAULT_TEXTURE_UP_HOVERED;
            String texDownHovered = DEFAULT_TEXTURE_DOWN_HOVERED;
            if (obj.has("textures")) {
                JsonObject textures = obj.getAsJsonObject("textures");
                if (textures.has("up")) {
                    texUp = textures.get("up").getAsString();
                }
                if (textures.has("down")) {
                    texDown = textures.get("down").getAsString();
                }
                if (textures.has("up_hovered")) {
                    texUpHovered = textures.get("up_hovered").getAsString();
                }
                if (textures.has("down_hovered")) {
                    texDownHovered = textures.get("down_hovered").getAsString();
                }
            }
            charKeyBuilder.setTextures(texUp, texDown, texUpHovered, texDownHovered);
            JsonArray groups2 = obj.getAsJsonArray("groups");
            for (JsonElement e : groups2) {
                JsonArray collections = e.getAsJsonArray();
                CharCollection[] charCollections = new CharCollection[collections.size()];
                int i = 0;
                for (JsonElement r : collections) {
                    JsonObject collection = r.getAsJsonObject();
                    char lower = (char)collection.get("lower").getAsInt();
                    char upper = collection.has("upper") ? (char)collection.get("upper").getAsInt() : Character.toUpperCase(lower);
                    charCollections[i++] = new CharCollection(lower, upper);
                }
                charKeyBuilder.addGroup(new CharGroup(charCollections));
            }
            return charKeyBuilder.build();
        }

        @Override
        public JsonElement serialize(CharKey src, Type typeOfSrc, JsonSerializationContext context) {
            boolean kdh;
            JsonObject object = new JsonObject();
            object.addProperty("type", Key.Serializer.KEY_CLASS_TO_ID.get(src.getClass()));
            object.addProperty("x", src.x);
            object.addProperty("y", src.y);
            if (src.width != 18) {
                object.addProperty("width", src.width);
            }
            if (src.height != 18) {
                object.addProperty("height", src.height);
            }
            if (src.controllerButton != null) {
                object.addProperty("button", src.controllerButton.name().toLowerCase(Locale.ROOT));
            }
            if (!src.renderChar) {
                object.addProperty("renderChar", src.renderChar);
            }
            boolean ku = !src.keyUp.namespaceId.toString().equals(DEFAULT_TEXTURE_UP);
            boolean kd = !src.keyDown.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN);
            boolean kuh = !src.keyUpHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_UP_HOVERED);
            boolean bl = kdh = !src.keyDownHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN_HOVERED);
            if (ku || kd || kuh || kdh) {
                JsonObject textureObject = new JsonObject();
                if (ku) {
                    textureObject.addProperty("up", src.keyUp.namespaceId.toString());
                }
                if (kd) {
                    textureObject.addProperty("down", src.keyDown.namespaceId.toString());
                }
                if (kuh) {
                    textureObject.addProperty("up_hovered", src.keyUpHovered.namespaceId.toString());
                }
                if (kdh) {
                    textureObject.addProperty("down_hovered", src.keyDownHovered.namespaceId.toString());
                }
                object.add("textures", textureObject);
            }
            JsonArray groups2 = new JsonArray(src.groups.length);
            for (CharGroup group : src.groups) {
                JsonArray collections = new JsonArray(group.collections.length);
                for (CharCollection collection : group.collections) {
                    JsonObject o = new JsonObject();
                    o.addProperty("lower", (int)collection.lower);
                    o.addProperty("upper", (int)collection.upper);
                    collections.add(o);
                }
                groups2.add(collections);
            }
            object.add("groups", groups2);
            return object;
        }
    }
}

