/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSlab;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelSlab<T extends BlockLogicSlab>
extends BlockModelStandard<T> {
    protected BlockModel<?> parentModel;

    public BlockModelSlab(Block<T> block) {
        super(block);
        this.parentModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(((BlockLogicSlab)this.block.getLogic()).modelBlock);
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        return this.parentModel.getParticleTexture(side, ((BlockLogicSlab)this.block.getLogic()).modelBlockMetadata);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.parentModel.getParticleTexture(side, ((BlockLogicSlab)this.block.getLogic()).modelBlockMetadata);
    }

    @Override
    public int renderLayer() {
        return this.parentModel.renderLayer();
    }
}

