/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericLeaves;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLeavesCherryFlowering;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLeavesCherryFlowering<T extends BlockLogic>
extends BlockModelGenericLeaves<T> {
    @NotNull
    public StaticBlockModel overlay = BlockModelDispatcher.loadDataModel("minecraft:block/leaves/cherry_overlay").asModel();
    @NotNull
    public StaticBlockModel overlayFlowering = BlockModelDispatcher.loadDataModel("minecraft:block/leaves/cherry_overlay_flowering").asModel();

    public BlockModelGenericLeavesCherryFlowering(@NotNull Block<T> block) {
        super(block, "minecraft:block/leaves/cherry");
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, byte lightIndex) {
        super.renderStandalone(tessellator, metadata, lightIndex);
        this.overlay.renderStandalone(this, tessellator, 0.0, 0.0, 0.0, metadata, lightIndex, (BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block));
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean didRender = super.renderAttached(tessellator, worldSource, tilePos, cullFaces, overrideTexture);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(worldSource.getBlockData(tilePos));
        didRender = growthRate > 0 ? (didRender |= this.overlay.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture)) : (didRender |= this.overlayFlowering.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture));
        return didRender;
    }
}

