/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.worldloader;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoaderLegacy;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.ChunkProvider;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.chunk.reader.ChunkReaderLegacy;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion1;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion2;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion3;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.save.mcregion.RegionFileCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.useless.seedviewer.bta.DummyWorld;

public class ChunkLoader
implements ChunkProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final World dummyWorld;
    @NotNull
    private final Chunk empty;
    private final File dimensionDir;

    public ChunkLoader(File worldFolder, Dimension dimension) {
        this.dimensionDir = new File(worldFolder, "dimensions/" + dimension.id);
        DummyWorld.CHUNK_LOADER = this;
        this.dummyWorld = new DummyWorld(dimension);
        this.empty = new EmptyChunk(this.dummyWorld, 0, 0);
    }

    public boolean chunkExists(ChunkPos location) {
        CompoundTag tag;
        DataInputStream regionStream = RegionFileCache.getChunkInputStream(this.dimensionDir, location.x, location.z);
        if (regionStream != null) {
            try {
                tag = NbtIo.read(regionStream);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read tag for location {}, {}", location.x, location.z, e);
                return false;
            }
        } else {
            return false;
        }
        return tag.containsKey("Level");
    }

    @Nullable
    public Chunk loadChunk(ChunkPosc location) throws IOException {
        DataInputStream regionStream = RegionFileCache.getChunkInputStream(this.dimensionDir, location.x(), location.z());
        if (regionStream == null) {
            return null;
        }
        CompoundTag tag = NbtIo.read(regionStream);
        if (!tag.containsKey("Level")) {
            LOGGER.error("Chunk file at {},{} is missing level data, skipping", (Object)location.x(), (Object)location.z());
            return null;
        }
        return this.loadChunkFromCompound(tag.getCompound("Level"));
    }

    @NotNull
    public Chunk loadChunkFromCompound(@NotNull CompoundTag tag) {
        int version = tag.getIntegerOrDefault("Version", -1);
        ChunkReader reader = ChunkLoader.getChunkReaderByVersion(tag, version);
        int x = reader.getX();
        int z = reader.getZ();
        Chunk chunk = new Chunk(this.dummyWorld, x, z);
        chunk.heightMap = reader.getHeightMap();
        chunk.averageBlockHeight = reader.getAverageBlockHeight();
        chunk.isTerrainPopulated = reader.getIsTerrainPopulated();
        chunk.temperature = reader.getTemperatureMap();
        chunk.humidity = reader.getHumidityMap();
        chunk.tickList = reader.getTickList();
        Int2ObjectMap<String> biomeRegistry = reader.getBiomeRegistry();
        for (int i = 0; i < 16; ++i) {
            ChunkLoaderLegacy.loadChunkSectionFromCompound(chunk.getSection(i), reader, biomeRegistry);
        }
        if (chunk.heightMap == null) {
            chunk.heightMap = new short[256];
            chunk.recalcHeightmapAndLightmap();
        }
        if (chunk.temperature == null || chunk.temperature.length == 0) {
            chunk.temperature = new double[256];
            Arrays.fill(chunk.temperature, Double.NEGATIVE_INFINITY);
        }
        if (chunk.humidity == null || chunk.humidity.length == 0) {
            chunk.humidity = new double[256];
            Arrays.fill(chunk.humidity, Double.NEGATIVE_INFINITY);
        }
        if (chunk.tickList == null) {
            chunk.tickList = new Int2ObjectArrayMap<NextTickListEntry>();
        }
        return chunk;
    }

    @NotNull
    private static ChunkReader getChunkReaderByVersion(@NotNull CompoundTag tag, int version) {
        return switch (version) {
            case 1 -> new ChunkReaderVersion1(tag);
            case 2 -> new ChunkReaderVersion2(tag);
            case 3 -> new ChunkReaderVersion3(tag);
            default -> new ChunkReaderLegacy(tag);
        };
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPosc chunkPos) {
        return false;
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        try {
            return this.loadChunk(chunkPos);
        }
        catch (IOException e) {
            return this.empty;
        }
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPosc chunkPos, boolean priority) {
        return this.provideChunk(chunkPos, true);
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPosc chunkPos) {
    }

    @Override
    public void populate(@NotNull ChunkPosc chunkPos) {
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "";
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPosc chunkPos) {
    }
}

