/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class TessellatorShader
extends TessellatorBase
implements TessellatorGeneral {
    private static final int MASK_ENABLE_COLOR = 1;
    private static final int MASK_ENABLE_TEXTURE = 2;
    private static final int MASK_ENABLE_LIGHTMAP = 4;
    private static final int MASK_ENABLE_NORMAL = 8;
    private boolean lockColor = false;
    private boolean quadEmulation = false;
    public byte config = 0;
    private int color;
    private byte lightIndex;
    private byte shade;
    private float texU;
    private float texV;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    public final int[] vaos = new int[16];
    public final int[] vbos = new int[16];
    private int quadVertCount = 0;

    public TessellatorShader(@NotNull String name, int initialCapacity) {
        super(name, initialCapacity);
        GL41.glGenVertexArrays(this.vaos);
        GL41.glGenBuffers(this.vbos);
        for (int i = 0; i < 16; ++i) {
            this.enableVertexAttribs(this.vaos[i], this.vbos[i], (i & 1) != 0, (i & 2) != 0, (i & 4) != 0, (i & 8) != 0);
            GL41.glBindVertexArray(0);
        }
    }

    @Override
    public void startDrawing(@NotNull DrawMode drawMode) {
        super.startDrawing(drawMode);
        this.lockColor = false;
        this.shade = (byte)-1;
        this.config = 0;
        boolean bl = this.quadEmulation = drawMode == DrawMode.QUADS;
        if (this.quadEmulation) {
            this.drawMode = DrawMode.TRIANGLES;
        }
        this.quadVertCount = 0;
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        this.checkCanFit(64);
        this.data.putFloat((float)(this.offsetX + x));
        this.data.putFloat((float)(this.offsetY + y));
        this.data.putFloat((float)(this.offsetZ + z));
        if ((this.config & 1) != 0) {
            byte a = (byte)((this.color & 0xFF000000) >> 24);
            byte b = (byte)((this.color & 0xFF0000) >> 16);
            byte g = (byte)((this.color & 0xFF00) >> 8);
            byte r = (byte)(this.color & 0xFF);
            this.data.put((byte)(r * Byte.toUnsignedInt(this.shade) >> 8)).put((byte)(g * Byte.toUnsignedInt(this.shade) >> 8)).put((byte)(b * Byte.toUnsignedInt(this.shade) >> 8)).put(a);
        }
        if ((this.config & 2) != 0) {
            this.data.putFloat(this.texU);
            this.data.putFloat(this.texV);
        }
        if ((this.config & 4) != 0) {
            this.data.put(this.lightIndex);
        }
        if ((this.config & 8) != 0) {
            this.data.put(this.normalX);
            this.data.put(this.normalY);
            this.data.put(this.normalZ);
        }
        ++this.vertexCount;
        if (this.quadEmulation && this.quadVertCount % 4 == 2) {
            int vertSize = this.getVertexSize((this.config & 1) != 0, (this.config & 2) != 0, (this.config & 4) != 0, (this.config & 8) != 0);
            this.checkCanFit(128);
            this.data.put(this.data.position(), this.data, this.data.position() - vertSize * 3, vertSize);
            this.data.put(this.data.position() + vertSize, this.data, this.data.position() - vertSize, vertSize);
            this.data.position(this.data.position() + vertSize * 2);
            this.vertexCount += 2;
        }
        ++this.quadVertCount;
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockColor = true;
    }

    @Override
    public void setColor1i(int argb) {
        this.checkIsDrawing();
        if (this.lockColor) {
            return;
        }
        if ((this.config & 1) == 0) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " color is disabled!");
            }
            this.config = (byte)(this.config | 1);
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        if ((this.config & 2) == 0) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " texture is disabled!");
            }
            this.config = (byte)(this.config | 2);
        }
        this.texU = (float)u;
        this.texV = (float)v;
    }

    @Override
    public void setLightmapCoord1i(int lightIndex) {
        this.checkIsDrawing();
        if ((this.config & 4) == 0) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " lightmap is disabled!");
            }
            this.config = (byte)(this.config | 4);
        }
        this.lightIndex = (byte)lightIndex;
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        if ((this.config & 8) == 0) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " normal is disabled!");
            }
            this.config = (byte)(this.config | 8);
        }
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.vertexCount == 0) {
            return;
        }
        this.enableBufferedConfig(this.vaos[this.config], this.vbos[this.config], (this.config & 1) != 0, (this.config & 2) != 0, (this.config & 4) != 0, (this.config & 8) != 0);
        GL41.glBufferData(34962, this.data.flip(), 35040);
        GLRenderer.getShader().bind();
        GLRenderer.globalSetUniforms(GLRenderer.getShader());
        GL41.glDrawArrays(this.drawMode.cap, 0, this.vertexCount);
        GL41.glUseProgram(0);
        GL41.glBindVertexArray(0);
    }

    @Override
    @NotNull
    public RenderBuffer record(int vao, int vbo) {
        this.checkIsDrawing();
        this.drawing = false;
        this.enableVertexAttribs(vao, vbo);
        GL41.glBufferData(34962, this.data.flip(), 35044);
        GL41.glBindVertexArray(0);
        return new RenderBuffer(vao, vbo, 0, this.vertexCount, this.drawMode);
    }

    protected int getVertexSize(boolean color, boolean texture, boolean lightmap, boolean normal) {
        int size = 12;
        if (color) {
            size += 4;
        }
        if (texture) {
            size += 8;
        }
        if (normal) {
            size += 3;
        }
        if (lightmap) {
            ++size;
        }
        return size;
    }

    protected void enableVertexAttribs(int vao, int vbo) {
        this.enableVertexAttribs(vao, vbo, (this.config & 1) != 0, (this.config & 2) != 0, (this.config & 4) != 0, (this.config & 8) != 0);
    }

    protected void enableVertexAttribs(int vao, int vbo, boolean color, boolean texture, boolean lightIndex, boolean normal) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        int vertexSize = this.getVertexSize(color, texture, lightIndex, normal);
        int offset = 0;
        GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
        offset += 12;
        GL41.glEnableVertexAttribArray(0);
        if (color) {
            GL41.glVertexAttribPointer(1, 4, 5121, true, vertexSize, offset);
            offset += 4;
            GL41.glEnableVertexAttribArray(1);
        } else {
            GL41.glDisableVertexAttribArray(1);
        }
        if (texture) {
            GL41.glVertexAttribPointer(2, 2, 5126, false, vertexSize, offset);
            offset += 8;
            GL41.glEnableVertexAttribArray(2);
        } else {
            GL41.glDisableVertexAttribArray(2);
        }
        if (lightIndex) {
            GL41.glVertexAttribPointer(3, 1, 5121, false, vertexSize, offset);
            ++offset;
            GL41.glEnableVertexAttribArray(3);
        } else {
            GL41.glDisableVertexAttribArray(3);
        }
        if (normal) {
            GL41.glVertexAttribPointer(4, 3, 5120, true, vertexSize, offset);
            offset += 3;
            GL41.glEnableVertexAttribArray(4);
        } else {
            GL41.glDisableVertexAttribArray(4);
        }
    }

    protected void enableBufferedConfig(int vao, int vbo, boolean color, boolean texture, boolean lightIndex, boolean normal) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        if (!color) {
            GL41.glVertexAttrib4f(1, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!lightIndex) {
            GL41.glVertexAttrib1f(3, GLRenderer.getLightIndex());
        }
        if (!normal) {
            GL41.glVertexAttrib3f(4, 0.0f, -1.0f, 0.0f);
        }
    }

    @Override
    public void setShade1i(int shade) {
        this.checkIsDrawing();
        this.shade = (byte)shade;
    }
}

