/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicRepeater
extends BlockLogic
implements ISupportable {
    public static final double[] torchPosOffset = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] tickDelayMap = new int[]{1, 2, 3, 4};
    public static final int MASK_DIRECTION = 3;
    public static final int MASK_TICK_DELAY = 12;
    public static final int DIRECTION_SOUTH = 0;
    public static final int DIRECTION_WEST = 1;
    public static final int DIRECTION_NORTH = 2;
    public static final int DIRECTION_EAST = 3;
    public final boolean isRepeaterPowered;

    public BlockLogicRepeater(@NotNull Block<?> block, boolean isPowered) {
        super(block, Materials.DECORATION);
        this.isRepeaterPowered = isPowered;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.REPEATER)};
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return world.canPlaceOnSurfaceOfBlock(tilePos.down(new TilePos())) && super.canStay(world, tilePos);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        int meta = world.getBlockData(tilePos);
        boolean powered = this.isGettingPower(world, tilePos, meta);
        if (this.isRepeaterPowered && !powered) {
            world.setBlockTypeDataNotify(tilePos, Blocks.REPEATER_IDLE, meta);
        } else if (!this.isRepeaterPowered) {
            world.setBlockTypeDataNotify(tilePos, Blocks.REPEATER_ACTIVE, meta);
            if (!powered) {
                int tickDelay = (meta & 0xC) >> 2;
                world.scheduleBlockUpdate(tilePos, Blocks.REPEATER_ACTIVE, tickDelayMap[tickDelay] * 2);
            }
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        Side back = BlockLogicRepeater.getSideFromMeta(data);
        Side front = back.getOpposite();
        world.notifyBlocksOfNeighborChange(tilePos.add(front.getDirection(), new TilePos()), this.block);
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        return side == BlockLogicRepeater.getSideFromMeta(source.getBlockData(tilePos));
    }

    public static Side getSideFromMeta(int meta) {
        return switch (meta & 3) {
            case 0 -> Side.SOUTH;
            case 1 -> Side.WEST;
            case 2 -> Side.NORTH;
            case 3 -> Side.EAST;
            default -> throw new RuntimeException("No side for direction " + (meta & 3) + "!");
        };
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
            return;
        }
        int meta = world.getBlockData(tilePos);
        boolean powered = this.isGettingPower(world, tilePos, meta);
        int tickDelay = (meta & 0xC) >> 2;
        if (this.isRepeaterPowered && !powered) {
            world.scheduleBlockUpdate(tilePos, this.block, tickDelayMap[tickDelay] * 2);
        } else if (!this.isRepeaterPowered && powered) {
            world.scheduleBlockUpdate(tilePos, this.block, tickDelayMap[tickDelay] * 2);
        }
    }

    private boolean isGettingPower(@NotNull World world, @NotNull TilePosc tilePos, int meta) {
        Side direction = BlockLogicRepeater.getSideFromMeta(meta);
        if (direction.isVertical()) {
            return false;
        }
        TilePos p = tilePos.add(direction.getDirection(), new TilePos());
        return world.hasSignal(p, direction) || world.getBlockType(p) == Blocks.WIRE_REDSTONE && (world.getBlockData(p) & 0xF) != 0;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        int metadata = world.getBlockData(tilePos);
        int tickDelay = (metadata & 0xC) >> 2;
        tickDelay = tickDelay + 1 << 2 & 0xC;
        world.setBlockDataNotify(tilePos, tickDelay | metadata & 3);
        return true;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        int metadata = world.getBlockData(tilePos);
        int tickDelay = (metadata & 0xC) >> 2;
        tickDelay = tickDelay + 1 << 2 & 0xC;
        world.setBlockDataNotify(tilePos, tickDelay | metadata & 3);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        int l = mob.getHorizontalPlacementDirection((Side)side).index;
        world.setBlockDataNotify(tilePos, l);
        if (this.isGettingPower(world, tilePos, l)) {
            world.scheduleBlockUpdate(tilePos, this.block, 1L);
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!side.isHorizontal()) {
            side = Side.NORTH;
        }
        int l = side.getDirection().index;
        world.setBlockDataNotify(tilePos, l);
        if (this.isGettingPower(world, tilePos, l)) {
            world.scheduleBlockUpdate(tilePos, this.block, 1L);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        double px = (double)tilePos.x() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)tilePos.y() + 0.4 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double pz = (double)tilePos.z() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double xOffset = 0.0;
        double zOffset = 0.0;
        int redstoneBrightness = 15;
        if (rand.nextInt(2) == 0) {
            switch (BlockLogicRepeater.getSideFromMeta(meta)) {
                case SOUTH: {
                    zOffset = -0.3125;
                    break;
                }
                case NORTH: {
                    zOffset = 0.3125;
                    break;
                }
                case EAST: {
                    xOffset = -0.3125;
                    break;
                }
                case WEST: {
                    xOffset = 0.3125;
                }
            }
        } else {
            int tickDelay = (meta & 0xC) >> 2;
            switch (BlockLogicRepeater.getSideFromMeta(meta)) {
                case SOUTH: {
                    zOffset = torchPosOffset[tickDelay];
                    break;
                }
                case NORTH: {
                    zOffset = -torchPosOffset[tickDelay];
                    break;
                }
                case EAST: {
                    xOffset = torchPosOffset[tickDelay];
                    break;
                }
                case WEST: {
                    xOffset = -torchPosOffset[tickDelay];
                }
            }
        }
        world.spawnParticle("reddust", px + xOffset, py, pz + zOffset, 0.0, 0.0, 0.0, 15);
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return FullSupport.INSTANCE;
    }
}

