/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;

public class BlockLogicThermalVent
extends BlockLogic {
    public static final int META_MASK = 7;
    public static int DORMANT_STATE = 0;
    public static int VENTING_STATE = 4;

    public BlockLogicThermalVent(@NotNull Block<?> block) {
        super(block, Materials.STONE);
        block.setTicking(true);
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        int state = BlockLogicThermalVent.getVentState(world.getBlockData(tilePos));
        double xPos = (double)tilePos.x() + 0.5;
        double yPos = (double)tilePos.y() + 1.125;
        double zPos = (double)tilePos.z() + 0.5;
        if (world.getBlockType(tilePos.up(new TilePos())).solid()) {
            return;
        }
        world.spawnParticle("ventsmoke", xPos, yPos, zPos, 0.0, 0.005, 0.0, 1, 32.0);
        if (state >= VENTING_STATE - 1) {
            for (int i = 0; i < 4; ++i) {
                world.spawnParticle("ventsmoke", xPos, yPos, zPos, 0.0, 0.005, 0.0, 0, 32.0);
                world.spawnParticle("smoke", xPos + (double)rand.nextFloat() - 0.5, yPos, zPos + (double)rand.nextFloat() - 0.5, 0.0, 0.005, 0.0, 1, 32.0);
            }
        }
    }

    private static int getBuildupRate(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (world.getBlockType(tilePos.down(new TilePos())) == Blocks.MAGMA) {
            return 2;
        }
        return 1;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.getBlockType(tilePos.up(new TilePos())).solid()) {
            return;
        }
        int state = BlockLogicThermalVent.getVentState(world.getBlockData(tilePos));
        if (state < VENTING_STATE) {
            int buildUpRate = BlockLogicThermalVent.getBuildupRate(world, tilePos, rand);
            world.setBlockDataNotify(tilePos, state += buildUpRate);
        } else {
            BlockLogicThermalVent.vent(world, tilePos, rand);
        }
    }

    private static int getVentState(int data) {
        return 7 & data;
    }

    private static void vent(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        for (int i = 0; i < 40; ++i) {
            double xPos = (double)tilePos.x() + 0.5;
            double yPos = (double)tilePos.y() + 1.125;
            double zPos = (double)tilePos.z() + 0.5;
            double xd = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zd = ((double)rand.nextFloat() - 0.5) * 0.5;
            world.spawnParticle("ventsmoke", xPos, yPos, zPos, 0.0, 0.25 + (double)rand.nextFloat(), 0.0, 1, 32.0);
            world.spawnParticle("flame", xPos, yPos, zPos, xd, 0.25 + (double)rand.nextFloat(), zd, 0, 32.0);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, tilePos.x(), tilePos.y(), tilePos.z(), "random.explode", 2.0f, 0.5f + rand.nextFloat() * 0.2f);
        List<Entity> entities = world.getEntitiesWithinAABB(Entity.class, new AABBd(tilePos.x() - 1, tilePos.y(), tilePos.z() - 1, tilePos.x() + 1, tilePos.y() + 6, tilePos.z() + 1));
        for (Entity entity : entities) {
            entity.fling(0.0, 2.0, 0.0, 1.0f);
        }
        world.setBlockDataNotify(tilePos, DORMANT_STATE);
    }
}

