/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.nether;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderNether;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.nether.ChunkGeneratorNether;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;

public class WorldTypeNether
extends WorldType {
    public WorldTypeNether(WorldType.Properties properties) {
        super(properties);
    }

    public static WorldType.Properties defaultProperties(String translationKey) {
        return WorldType.Properties.of(translationKey).brightnessRamp(WorldTypeNether.getLightRamp()).oceanBlock(Blocks.FLUID_LAVA_STILL).fillerBlock(Blocks.COBBLE_NETHERRACK).withCeiling().bounds(0, 255, 96);
    }

    private static float[] getLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.35f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(72000L);
    }

    @Override
    @NotNull
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderNether(world);
    }

    @Override
    @NotNull
    public @NotNull Biome @NotNull [] allBiomes() {
        return BiomeProviderNether.allBiomes();
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorNether(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.5f;
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        return 0;
    }
}

