/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class WorldFeatureFloorVent
implements WorldFeatureInterface {
    private final int minRadius;
    private final int radiusMod;

    public WorldFeatureFloorVent(int minRadius, int radiusMod) {
        this.minRadius = minRadius;
        this.radiusMod = radiusMod;
    }

    public WorldFeatureFloorVent() {
        this.minRadius = 1;
        this.radiusMod = 2;
    }

    private boolean isAirOrLiquid(World world, TilePos tilePos) {
        return world.isAirBlock(tilePos) || world.getBlockType(tilePos).hasTag(BlockTags.IS_LAVA) || world.getBlockType(tilePos).hasTag(BlockTags.IS_WATER);
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, @NotNull TilePosc tilePos) {
        TilePos pos = (TilePos)tilePos;
        while (this.isAirOrLiquid(world, pos) && pos.y - 1 > 0) {
            pos.down();
        }
        int radius = this.minRadius + random.nextInt(this.radiusMod);
        TilePos centerPos = new TilePos(pos.x() + random.nextInt(8), pos.y(), pos.z() + random.nextInt(8));
        TilePos cursor = new TilePos();
        if (!this.canPlace(centerPos, world) && !this.isAirOrLiquid(world, centerPos.up(new TilePos()))) {
            return false;
        }
        cursor.x = centerPos.x() - radius;
        while (cursor.x <= centerPos.x() + radius) {
            cursor.z = centerPos.z() - radius;
            while (cursor.z <= centerPos.z() + radius) {
                int xd = cursor.x() - centerPos.x();
                int zd = cursor.z() - centerPos.z();
                float dist = xd * xd + zd * zd;
                cursor.y = centerPos.y();
                while (cursor.y > pos.y - 4) {
                    if (cursor.y > 0 && dist <= (float)(radius * radius) && this.canPlace(cursor, world)) {
                        if (cursor.equals(centerPos)) {
                            world.setBlockTypeNotify(cursor, Blocks.THERMAL_VENT);
                        } else if (random.nextInt(4) != 0) {
                            world.setBlockTypeNotify(cursor, Blocks.BASALT);
                        } else if (random.nextInt(20) == 0) {
                            world.setBlockTypeNotify(cursor, Blocks.THERMAL_VENT);
                        }
                    }
                    --cursor.y;
                }
                ++cursor.z;
            }
            ++cursor.x;
        }
        return true;
    }

    private boolean canPlace(TilePos cursor, World world) {
        if (this.isAirOrLiquid(world, cursor)) {
            return false;
        }
        return world.getBlockType(cursor).hasTag(BlockTags.NETHER_SURFACE_BLOCK);
    }
}

