/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard.keys;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.keyboard.keys.Key;
import net.minecraft.core.sound.SoundCategory;

public class BackspaceKey
extends Key {
    public BackspaceKey(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setTextures("minecraft:gui/widgets/keyboard/key_backspace/up", "minecraft:gui/widgets/keyboard/key_backspace/down", "minecraft:gui/widgets/keyboard/key_backspace/up_hovered", "minecraft:gui/widgets/keyboard/key_backspace/down_hovered");
    }

    @Override
    public void pressAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        keyboard.backspace();
        mc.sndManager.playSound("ui.ui_back", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
    }

    public static class Serializer
    implements JsonSerializer<BackspaceKey>,
    JsonDeserializer<BackspaceKey> {
        public static final int DEFAULT_WIDTH = 25;
        public static final int DEFAULT_HEIGHT = 18;
        public static final String DEFAULT_TEXTURE_UP = "minecraft:gui/widgets/keyboard/key_backspace/up";
        public static final String DEFAULT_TEXTURE_DOWN = "minecraft:gui/widgets/keyboard/key_backspace/down";
        public static final String DEFAULT_TEXTURE_UP_HOVERED = "minecraft:gui/widgets/keyboard/key_backspace/up_hovered";
        public static final String DEFAULT_TEXTURE_DOWN_HOVERED = "minecraft:gui/widgets/keyboard/key_backspace/down_hovered";

        @Override
        public BackspaceKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int width = obj.has("width") ? obj.get("width").getAsInt() : 25;
            int height = obj.has("height") ? obj.get("height").getAsInt() : 18;
            Key.ButtonEnum button = obj.has("button") ? Key.ButtonEnum.valueOf(obj.get("button").getAsString().toUpperCase(Locale.ROOT)) : null;
            String texUp = DEFAULT_TEXTURE_UP;
            String texDown = DEFAULT_TEXTURE_DOWN;
            String texUpHovered = DEFAULT_TEXTURE_UP_HOVERED;
            String texDownHovered = DEFAULT_TEXTURE_DOWN_HOVERED;
            if (obj.has("textures")) {
                JsonObject textures = obj.getAsJsonObject("textures");
                if (textures.has("up")) {
                    texUp = textures.get("up").getAsString();
                }
                if (textures.has("down")) {
                    texDown = textures.get("down").getAsString();
                }
                if (textures.has("up_hovered")) {
                    texUpHovered = textures.get("up_hovered").getAsString();
                }
                if (textures.has("down_hovered")) {
                    texDownHovered = textures.get("down_hovered").getAsString();
                }
            }
            BackspaceKey key = new BackspaceKey(x, y, width, height);
            key.setTextures(texUp, texDown, texUpHovered, texDownHovered);
            key.setControllerButton(button);
            return key;
        }

        @Override
        public JsonElement serialize(BackspaceKey src, Type typeOfSrc, JsonSerializationContext context) {
            boolean kdh;
            JsonObject object = new JsonObject();
            object.addProperty("type", Key.Serializer.KEY_CLASS_TO_ID.get(src.getClass()));
            object.addProperty("x", src.x);
            object.addProperty("y", src.y);
            if (src.width != 25) {
                object.addProperty("width", src.width);
            }
            if (src.height != 18) {
                object.addProperty("height", src.height);
            }
            if (src.controllerButton != null) {
                object.addProperty("button", src.controllerButton.name().toLowerCase(Locale.ROOT));
            }
            boolean ku = !src.keyUp.namespaceId.toString().equals(DEFAULT_TEXTURE_UP);
            boolean kd = !src.keyDown.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN);
            boolean kuh = !src.keyUpHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_UP_HOVERED);
            boolean bl = kdh = !src.keyDownHovered.namespaceId.toString().equals(DEFAULT_TEXTURE_DOWN_HOVERED);
            if (ku || kd || kuh || kdh) {
                JsonObject textureObject = new JsonObject();
                if (ku) {
                    textureObject.addProperty("up", src.keyUp.namespaceId.toString());
                }
                if (kd) {
                    textureObject.addProperty("down", src.keyDown.namespaceId.toString());
                }
                if (kuh) {
                    textureObject.addProperty("up_hovered", src.keyUpHovered.namespaceId.toString());
                }
                if (kdh) {
                    textureObject.addProperty("down_hovered", src.keyDownHovered.namespaceId.toString());
                }
                object.add("textures", textureObject);
            }
            return object;
        }
    }
}

