/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorCustom;
import net.minecraft.client.render.block.color.BlockColorDefault;
import net.minecraft.client.render.block.color.BlockColorRubyglass;
import net.minecraft.client.render.block.color.BlockColorWater;
import net.minecraft.client.render.block.color.BlockColorWireRedstone;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public final class BlockColorDispatcher
extends Dispatcher<Block<?>, BlockColor> {
    private static final BlockColorDispatcher instance = new BlockColorDispatcher();
    private static final BlockColor defaultColor = new BlockColorDefault();

    public static BlockColorDispatcher getInstance() {
        return instance;
    }

    private BlockColorDispatcher() {
        this.reload();
    }

    public void onWorldChanged(@NotNull World world) {
        this.reload();
    }

    public void reload() {
        this.dispatches.clear();
        this.addDispatch(Blocks.ALGAE, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.FLUID_WATER_STILL, new BlockColorWater(Colorizers.water));
        this.addDispatch(Blocks.FLUID_WATER_FLOWING, new BlockColorWater(Colorizers.water));
        this.addDispatch(Blocks.GRASS, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.LAYER_LEAVES_OAK, new BlockColorCustom(Colorizers.oak));
        this.addDispatch(Blocks.LEAVES_BIRCH, new BlockColorCustom(Colorizers.birch));
        this.addDispatch(Blocks.LEAVES_CHERRY, new BlockColorCustom(Colorizers.cherry));
        this.addDispatch(Blocks.LEAVES_CHERRY_FLOWERING, new BlockColorCustom(Colorizers.cherry));
        this.addDispatch(Blocks.LEAVES_EUCALYPTUS, new BlockColorCustom(Colorizers.eucalyptus));
        this.addDispatch(Blocks.LEAVES_CACAO, new BlockColorCustom(Colorizers.cacao));
        this.addDispatch(Blocks.LEAVES_OAK, new BlockColorCustom(Colorizers.oak));
        this.addDispatch(Blocks.LEAVES_PINE, new BlockColorCustom(Colorizers.pine));
        this.addDispatch(Blocks.LEAVES_SHRUB, new BlockColorCustom(Colorizers.shrub));
        this.addDispatch(Blocks.LEAVES_THORN, new BlockColorCustom(Colorizers.thorn));
        this.addDispatch(Blocks.LEAVES_PALM, new BlockColorCustom(Colorizers.palm));
        this.addDispatch(Blocks.MOSS_STONE, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.MOSS_BASALT, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.MOSS_LIMESTONE, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.MOSS_GRANITE, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.WIRE_REDSTONE, new BlockColorWireRedstone());
        this.addDispatch(Blocks.TALLGRASS, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.TALLGRASS_FERN, new BlockColorCustom(Colorizers.grass));
        this.addDispatch(Blocks.RUBYGLASS, new BlockColorRubyglass(Colorizers.crystal));
        this.addDispatch(Blocks.RUBYGLASS_PURE, new BlockColorRubyglass(Colorizers.crystal));
        this.addDispatch(Blocks.RUBYGLASS_SPROUT, new BlockColorRubyglass(Colorizers.crystal));
    }

    @Override
    protected BlockColor getDefault() {
        return defaultColor;
    }
}

