/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.renderer;

import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public enum State {
    BLEND(3042),
    DEPTH_TEST(2929),
    CULL_FACE(2884),
    SCISSOR_TEST(3089),
    POLYGON_OFFSET_FILL(32823),
    POLYGON_OFFSET_LINE(10754),
    POLYGON_OFFSET_POINT(10753),
    POLYGON_SMOOTH(2881),
    STENCIL_TEST(2960),
    CLIP_DISTANCE0(12288),
    CLIP_DISTANCE1(12289),
    CLIP_DISTANCE2(12290),
    CLIP_DISTANCE3(12291),
    CLIP_DISTANCE4(12292),
    CLIP_DISTANCE5(12293),
    CLIP_DISTANCE6(12294),
    CLIP_DISTANCE7(12295),
    COLOR_LOGIC_OP(3058),
    DEPTH_CLAMP(34383),
    DITHER(3024),
    FRAMEBUFFER_SRGB(36281),
    LINE_SMOOTH(2848),
    MULTISAMPLE(32925),
    PRIMITIVE_RESTART(36765),
    RASTERIZER_DISCARD(35977),
    SAMPLE_ALPHA_TO_COVERAGE(32926),
    SAMPLE_ALPHA_TO_ONE(32927),
    SAMPLE_COVERAGE(32928),
    SAMPLE_SHADING(35894),
    SAMPLE_MASK(36433),
    TEXTURE_CUBE_MAP_SEAMLESS(34895),
    PROGRAM_POINT_SIZE(34370);

    private static final int COUNT;
    @NotNull
    private static final @NotNull State @NotNull [] TOGGLES;
    public final int cap;
    public final long bitMask;

    private State(int cap) {
        this.cap = cap;
        this.bitMask = 1L << this.ordinal();
    }

    long enable(long config) {
        return config | this.bitMask;
    }

    long disable(long config) {
        return config & (this.bitMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    boolean isEnabled(long config) {
        return (config & this.bitMask) != 0L;
    }

    boolean isSystemEnabled() {
        return GL41.glIsEnabled(this.cap);
    }

    private static long getSystemStateConfig() {
        long currentConfig = 0L;
        for (int i = 0; i < COUNT; ++i) {
            State t = TOGGLES[i];
            if (!t.isSystemEnabled()) continue;
            currentConfig |= t.bitMask;
        }
        return currentConfig;
    }

    static void setStateConfig(long currentConfig, long newConfig) {
        if (currentConfig == newConfig) {
            return;
        }
        long difConfig = currentConfig ^ newConfig;
        int max = 64 - Long.numberOfLeadingZeros(difConfig);
        for (int i = 0; i < max; ++i) {
            if ((difConfig >> i & 1L) == 0L) continue;
            State t = TOGGLES[i];
            if (t.isEnabled(newConfig)) {
                GL41.glEnable(t.cap);
                continue;
            }
            GL41.glDisable(t.cap);
        }
    }

    static {
        COUNT = State.values().length;
        TOGGLES = State.values();
    }
}

