/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL41;

public abstract class Scissor {
    private static Minecraft mc = Minecraft.getMinecraft();

    public static void enable(int x, int y, int xSize, int ySize) {
        int xScale = MathHelper.floor((double)Scissor.mc.gameWindow.getWidthPixels() / Scissor.mc.resolution.getExactScaledWidthScreenCoords());
        int yScale = MathHelper.floor((double)Scissor.mc.gameWindow.getHeightPixels() / Scissor.mc.resolution.getExactScaledHeightScreenCoords());
        int xPixels = x * xScale;
        int yPixels = Scissor.mc.gameWindow.getHeightPixels() - (y + ySize) * yScale;
        int xSizePixels = xSize * xScale;
        int ySizePixels = ySize * yScale;
        GL41.glScissor(xPixels, yPixels, Math.max(xSizePixels, 0), Math.max(ySizePixels, 0));
        GLRenderer.enableState(State.SCISSOR_TEST);
    }

    public static void disable() {
        GLRenderer.disableState(State.SCISSOR_TEST);
    }

    public static void scissor(int x, int y, int xSize, int ySize, Runnable method) {
        Scissor.enable(x, y, xSize, ySize);
        method.run();
        Scissor.disable();
    }
}

