/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.VertexConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class RegionBuffer<V extends VertexConfig<V>> {
    @NotNull
    private final @NotNull Int2ObjectMap<@NotNull RenderRegion<V>> regionMap = new Int2ObjectOpenHashMap<RenderRegion<V>>();
    @NotNull
    private final @NotNull List<@NotNull RenderRegion<V>> regionList = new ArrayList<RenderRegion<V>>();
    @NotNull
    private final @NotNull @UnmodifiableView List<@NotNull RenderRegion<V>> immutableRegionList = Collections.unmodifiableList(this.regionList);
    private final int regionSizeShift;

    public RegionBuffer(int regionSizeShift) {
        this.regionSizeShift = regionSizeShift;
    }

    @NotNull
    public RenderRegion<V> getRegionAtBlockPos(int blockX, int blockZ) {
        int x = blockX >> this.regionSizeShift;
        int z = blockZ >> this.regionSizeShift;
        return this.getRegion(x, z);
    }

    @NotNull
    public RenderRegion<V> getRegion(int x, int z) {
        int index = this.getIndex(x, z);
        @Nullable RenderRegion<V> region = (RenderRegion)this.regionMap.get(index);
        if (region == null) {
            region = new RenderRegion(x, z);
            this.regionMap.put(index, region);
            this.regionList.add(region);
        } else if (region.posX != x || region.posZ != z) {
            throw new RuntimeException(String.valueOf(region) + " != " + String.valueOf(new RenderRegion(x, z)));
        }
        return region;
    }

    public void remove(@NotNull RenderRegion<V> region) {
        int index = this.getIndex(region.posX, region.posZ);
        @Nullable RenderRegion existingRegion = (RenderRegion)this.regionMap.get(index);
        if (existingRegion != region) {
            throw new RuntimeException(String.valueOf(region) + " != " + String.valueOf(existingRegion));
        }
        this.regionMap.remove(index);
        this.regionList.remove(region);
    }

    public int getIndex(int x, int z) {
        return (x & 0xFFFF) << 16 | z & 0xFFFF;
    }

    @NotNull
    public @NotNull @UnmodifiableView List<@NotNull RenderRegion<V>> getAllRegions() {
        return this.immutableRegionList;
    }

    public int size() {
        return this.regionMap.size();
    }
}

