/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeBlock;
import net.minecraft.core.net.command.arguments.ArgumentTypeDimension;
import net.minecraft.core.net.command.arguments.ArgumentTypeIntegerCoordinates;
import net.minecraft.core.net.command.helpers.BlockInput;
import net.minecraft.core.net.command.helpers.ClonedBlock;
import net.minecraft.core.net.command.helpers.IntegerCoordinate;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;

public class CommandClone
implements CommandManager.CommandRegistry {
    private static final SimpleCommandExceptionType INSIDE_CLONED_AREA = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.clone.exception_inside_cloned_area"));
    private static final SimpleCommandExceptionType DESTINATION_NOT_LOADED = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.clone.exception_destination_not_loaded"));
    private static final SimpleCommandExceptionType SOURCE_NOT_LOADED = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.clone.exception_source_not_loaded"));
    private static final SimpleCommandExceptionType NOWHERE_LOADED = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.clone.exception_nowhere_loaded"));

    @Override
    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("clone").requires(CommandSource::hasAdmin)).then(CommandClone.beginEndDestinationAndModeSuffix(c -> ((CommandSource)c.getSource()).getWorld()))).then(ArgumentBuilderLiteral.literal("from").then(ArgumentBuilderRequired.argument("sourceDimension", ArgumentTypeDimension.dimension()).then(CommandClone.beginEndDestinationAndModeSuffix(c -> ((CommandSource)c.getSource()).getWorld(c.getArgument((String)"sourceDimension", Dimension.class).id))))));
    }

    private static ArgumentBuilder<CommandSource, ?> beginEndDestinationAndModeSuffix(CommandFunction<CommandContext<CommandSource>, World> commandFunction) {
        return ArgumentBuilderRequired.argument("begin", ArgumentTypeIntegerCoordinates.intCoordinates()).then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("end", ArgumentTypeIntegerCoordinates.intCoordinates()).then(CommandClone.destinationAndModeSuffix(commandFunction, c -> ((CommandSource)c.getSource()).getWorld()))).then(ArgumentBuilderLiteral.literal("to").then(ArgumentBuilderRequired.argument("targetDimension", ArgumentTypeDimension.dimension()).then(CommandClone.destinationAndModeSuffix(commandFunction, c -> ((CommandSource)c.getSource()).getWorld(c.getArgument((String)"targetDimension", Dimension.class).id))))));
    }

    private static WorldAndPosition getWorldAndPosition(CommandContext<CommandSource> commandContext, World world, String string) {
        IntegerCoordinates coordinates = commandContext.getArgument(string, IntegerCoordinates.class);
        return new WorldAndPosition(world, coordinates);
    }

    private static ArgumentBuilder<CommandSource, ?> destinationAndModeSuffix(CommandFunction<CommandContext<CommandSource>, World> commandFunction, CommandFunction<CommandContext<CommandSource>, World> commandFunction2) {
        CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction3 = c -> CommandClone.getWorldAndPosition(c, (World)commandFunction.apply((CommandContext<CommandSource>)c), "begin");
        CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction4 = c -> CommandClone.getWorldAndPosition(c, (World)commandFunction.apply((CommandContext<CommandSource>)c), "end");
        CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction5 = c -> CommandClone.getWorldAndPosition(c, (World)commandFunction2.apply((CommandContext<CommandSource>)c), "destination");
        return ((ArgumentBuilderRequired)((ArgumentBuilderRequired)((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("destination", ArgumentTypeIntegerCoordinates.intCoordinates()).executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction3.apply(c), (WorldAndPosition)commandFunction4.apply(c), (WorldAndPosition)commandFunction5.apply(c), null, CloneMode.NORMAL))).then(CommandClone.wrapWithCloneMode(commandFunction3, commandFunction4, commandFunction5, commandContext -> null, ArgumentBuilderLiteral.literal("replace").executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction3.apply(c), (WorldAndPosition)commandFunction4.apply(c), (WorldAndPosition)commandFunction5.apply(c), null, CloneMode.NORMAL))))).then(CommandClone.wrapWithCloneMode(commandFunction3, commandFunction4, commandFunction5, commandContext -> new BlockInput(null, 0, new CompoundTag()), ArgumentBuilderLiteral.literal("masked").executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction3.apply(c), (WorldAndPosition)commandFunction4.apply(c), (WorldAndPosition)commandFunction5.apply(c), new BlockInput(null, 0, new CompoundTag()), CloneMode.NORMAL))))).then(ArgumentBuilderLiteral.literal("filtered").then(CommandClone.wrapWithCloneMode(commandFunction3, commandFunction4, commandFunction5, c -> c.getArgument("filter", BlockInput.class), ArgumentBuilderRequired.argument("filter", ArgumentTypeBlock.block()).executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction3.apply(c), (WorldAndPosition)commandFunction4.apply(c), (WorldAndPosition)commandFunction5.apply(c), c.getArgument("filter", BlockInput.class), CloneMode.NORMAL)))));
    }

    private static ArgumentBuilder<CommandSource, ?> wrapWithCloneMode(CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction, CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction2, CommandFunction<CommandContext<CommandSource>, WorldAndPosition> commandFunction3, CommandFunction<CommandContext<CommandSource>, BlockInput> commandFunction4, ArgumentBuilder<CommandSource, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then((ArgumentBuilder<CommandSource, ?>)ArgumentBuilderLiteral.literal("force").executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction.apply(c), (WorldAndPosition)commandFunction2.apply(c), (WorldAndPosition)commandFunction3.apply(c), (BlockInput)commandFunction4.apply(c), CloneMode.FORCE)))).then(ArgumentBuilderLiteral.literal("move").executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction.apply(c), (WorldAndPosition)commandFunction2.apply(c), (WorldAndPosition)commandFunction3.apply(c), (BlockInput)commandFunction4.apply(c), CloneMode.MOVE)))).then(ArgumentBuilderLiteral.literal("normal").executes(c -> CommandClone.clone((CommandSource)c.getSource(), (WorldAndPosition)commandFunction.apply(c), (WorldAndPosition)commandFunction2.apply(c), (WorldAndPosition)commandFunction3.apply(c), (BlockInput)commandFunction4.apply(c), CloneMode.NORMAL)));
    }

    public static int clone(CommandSource source, WorldAndPosition start, WorldAndPosition end, WorldAndPosition destination, @Nullable BlockInput filter, CloneMode cloneMode) throws CommandSyntaxException {
        int minX = Math.min(start.getPosition().getX(source), end.getPosition().getX(source));
        int minY = Math.min(start.getPosition().getY(source, true), end.getPosition().getY(source, true));
        int minZ = Math.min(start.getPosition().getZ(source), end.getPosition().getZ(source));
        int maxX = Math.max(start.getPosition().getX(source), end.getPosition().getX(source));
        int maxY = Math.max(start.getPosition().getY(source, true), end.getPosition().getY(source, true));
        int maxZ = Math.max(start.getPosition().getZ(source), end.getPosition().getZ(source));
        int destinationX = destination.getPosition().getX(source);
        int destinationY = destination.getPosition().getY(source, true);
        int destinationZ = destination.getPosition().getZ(source);
        if (cloneMode == CloneMode.NORMAL && new AABBd(minX, minY, minZ, maxX, maxY, maxZ).containsPoint(new Vector3d(destinationX, destinationY, destinationZ)) && start.getWorld() == destination.getWorld()) {
            throw INSIDE_CLONED_AREA.create();
        }
        start.getWorld().noNeighborUpdate = true;
        HashMap<IntegerCoordinates, ClonedBlock> map = new HashMap<IntegerCoordinates, ClonedBlock>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!start.getWorld().isBlockLoaded(x, y, z)) {
                        if (!destination.getWorld().isBlockLoaded(destinationX, destinationY, destinationZ)) {
                            throw NOWHERE_LOADED.create();
                        }
                        throw SOURCE_NOT_LOADED.create();
                    }
                    map.put(new IntegerCoordinates(new IntegerCoordinate(false, x - minX), new IntegerCoordinate(false, y - minY), new IntegerCoordinate(false, z - minZ)), new ClonedBlock(start.getWorld().getBlock(x, y, z), start.getWorld().getBlockMetadata(x, y, z), start.getWorld().getTileEntity(x, y, z)));
                    if (cloneMode != CloneMode.MOVE) continue;
                    start.getWorld().setBlockWithNotify(x, y, z, 0);
                }
            }
        }
        if (!destination.getWorld().isBlockLoaded(destinationX, destinationY, destinationZ)) {
            throw DESTINATION_NOT_LOADED.create();
        }
        start.getWorld().noNeighborUpdate = false;
        int clonedBlocks = 0;
        destination.getWorld().noNeighborUpdate = true;
        for (Map.Entry entry : map.entrySet()) {
            int offsetDestinationX = destinationX + ((IntegerCoordinates)entry.getKey()).getX(source);
            int offsetDestinationY = destinationY + ((IntegerCoordinates)entry.getKey()).getY(source, true);
            int offsetDestinationZ = destinationZ + ((IntegerCoordinates)entry.getKey()).getZ(source);
            CompoundTag blockTag = new CompoundTag();
            TileEntity tileEntity = destination.getWorld().getTileEntity(offsetDestinationX, offsetDestinationY, offsetDestinationZ);
            if (tileEntity != null) {
                tileEntity.writeToNBT(blockTag);
            }
            if (filter != null && (destination.getWorld().getBlockId(offsetDestinationX, offsetDestinationY, offsetDestinationZ) != filter.getBlockId() || destination.getWorld().getBlockMetadata(offsetDestinationX, offsetDestinationY, offsetDestinationZ) != filter.getMetadata() || !filter.getTag().getValues().isEmpty() && !CommandHelper.blockEntitiesAreEqual(blockTag, filter.getTag()))) continue;
            if (destination.getWorld().getBlockId(offsetDestinationX, offsetDestinationY, offsetDestinationZ) != ((ClonedBlock)entry.getValue()).getBlockId() || destination.getWorld().getBlockMetadata(offsetDestinationX, offsetDestinationY, offsetDestinationZ) != ((ClonedBlock)entry.getValue()).getMetadata()) {
                ++clonedBlocks;
            }
            destination.getWorld().setBlockWithNotify(offsetDestinationX, offsetDestinationY, offsetDestinationZ, ((ClonedBlock)entry.getValue()).getBlockId());
            destination.getWorld().setBlockMetadataWithNotify(offsetDestinationX, offsetDestinationY, offsetDestinationZ, ((ClonedBlock)entry.getValue()).getMetadata());
            CommandHelper.setTileEntity((WorldSource)destination.getWorld(), offsetDestinationX, offsetDestinationY, offsetDestinationZ, ((ClonedBlock)entry.getValue()).getTileEntity());
        }
        destination.getWorld().noNeighborUpdate = false;
        source.sendTranslatableMessage(clonedBlocks == 1 ? "command.commands.clone.success_single" : "command.commands.clone.success_multiple", clonedBlocks);
        return clonedBlocks;
    }

    @FunctionalInterface
    static interface CommandFunction<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    public static class WorldAndPosition {
        private final World world;
        private final IntegerCoordinates position;

        WorldAndPosition(World world, IntegerCoordinates position) {
            this.world = world;
            this.position = position;
        }

        public World getWorld() {
            return this.world;
        }

        public IntegerCoordinates getPosition() {
            return this.position;
        }
    }

    public static enum CloneMode {
        FORCE,
        MOVE,
        NORMAL;

    }
}

