/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.weather.IPrecipitation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFireCold
extends BlockLogicFire {
    public BlockLogicFireCold(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        boolean infiniBurn;
        TilePos queryPos = new TilePos();
        @Nullable Block<?> blockUnder = world.getBlockType(tilePos.down(queryPos));
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN_COLD);
        if (!this.isValidFireLocation(world, tilePos)) {
            this.setBurnResult(world, tilePos);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather() instanceof IPrecipitation && (world.isBlockBeingRainedOn(tilePos) || world.isBlockBeingRainedOn(tilePos.west(queryPos)) || world.isBlockBeingRainedOn(tilePos.east(queryPos)) || world.isBlockBeingRainedOn(tilePos.north(queryPos)) || world.isBlockBeingRainedOn(tilePos.south(queryPos)))) {
            this.setBurnResult(world, tilePos);
            return;
        }
        int meta = world.getBlockData(tilePos);
        if (meta < 15) {
            world.setBlockData(tilePos, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
        if (!infiniBurn && !this.canNeighborCatchFire(world, tilePos)) {
            if (!world.isBlockNormalCube(tilePos.down(queryPos)) || meta > 3) {
                this.setBurnResult(world, tilePos);
            }
            return;
        }
        if (!infiniBurn && !BlockLogicFireCold.canBurn(world, tilePos.down(queryPos)) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, tilePos);
        }
    }
}

