/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;
import org.joml.Vector3i;

public class WorldFeatureThermalSpire
extends WorldFeature {
    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        TilePos pos = new TilePos(x, y, z);
        while (world.isAirBlock(pos) && pos.y - 1 > 0) {
            pos.down();
        }
        if (this.hasSpace(world, pos.x, pos.y, pos.z)) {
            Vector3i highestOffset = new Vector3i(0, 0, 0);
            TilePos centerPos = new TilePos(pos.x, pos.y, pos.z);
            TilePos queryPos = new TilePos();
            for (int x1 = 0; x1 < 2; ++x1) {
                for (int z1 = 0; z1 < 2; ++z1) {
                    int height = random.nextInt(4) + 2;
                    if (height > highestOffset.y) {
                        highestOffset.set(x1, height, z1);
                    }
                    for (int y1 = 0; y1 < height; ++y1) {
                        centerPos.add(x1, y1, z1, queryPos);
                        world.setBlockType(queryPos, Blocks.BASALT);
                    }
                }
            }
            for (int y1 = 0; y1 < 2; ++y1) {
                centerPos.add(highestOffset.x, highestOffset.y + y1, highestOffset.z, queryPos);
                world.setBlockType(queryPos, Blocks.THERMAL_VENT);
            }
        }
        return true;
    }

    private boolean hasSpace(World world, int xc, int y, int zc) {
        TilePos queryPos = new TilePos();
        queryPos.y = y - 3;
        while (queryPos.y < y + 3) {
            queryPos.x = xc - 3;
            while (queryPos.x < xc + 3) {
                queryPos.z = zc - 3;
                while (queryPos.z < zc + 3) {
                    if (!world.isAirBlock(queryPos) && !world.getBlockType(queryPos).hasTag(BlockTags.NETHER_SURFACE_BLOCK)) {
                        return false;
                    }
                    ++queryPos.z;
                }
                ++queryPos.x;
            }
            ++queryPos.y;
        }
        return true;
    }
}

