/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.client.render.particle.ParticleItemBreaking;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class ParticleEntryItem
extends ParticleEntry {
    protected int itemID;

    @Override
    public String getParticleName(I18n translator) {
        return "item";
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen) {
        final TextCycleElement<Integer> itemIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, 0, 120, 20, Integer.valueOf(this.itemID)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ParticleEntryItem.this.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return ParticleEntryItem.this.itemID;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        itemIdCycle.setOnValueChanged(() -> {
            this.itemID = (Integer)itemIdCycle.getCurrentElement();
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(itemIdCycle);
            }
        };
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.particleEngine.add(new ParticleItemBreaking(world, x, y, z, Item.itemsList[this.itemID]));
    }

    @Override
    public void onOpen() {
        this.itemID = 16384;
    }

    @Override
    public void onClose() {
    }

    private int cycleItemId(int itemId, int offset) {
        int numItems = Item.itemsList.length - Blocks.blocksList.length;
        int _itemId = MathHelper.clamp(itemId - numItems, 0, numItems);
        int id = (_itemId + numItems + offset) % numItems;
        while (Item.itemsList[id + Blocks.blocksList.length] == null) {
            id = (id + (int)Math.signum(offset) + numItems) % numItems;
        }
        return id + Blocks.blocksList.length;
    }
}

