/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.gui.guidebook.search.GuidebookSectionSearch;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.LightIndexHelper;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenGuidebook
extends Screen {
    private static final int TABS_PER_SIDE = 8;
    private static GuidebookPageManager guidebookPageManager = null;
    public static boolean allowArrowKeyNavigation = true;
    private final int xSize = 316;
    private final int ySize = 220;
    private final TooltipElement tooltip = new TooltipElement(Minecraft.getMinecraft());
    private Tab[] tabs = new Tab[16];
    private GuidebookPage lastPage = null;
    private boolean canPlaySound = true;

    public static GuidebookPageManager getPageManager() {
        GuidebookSections.init();
        if (guidebookPageManager == null) {
            guidebookPageManager = new GuidebookPageManager();
        }
        return guidebookPageManager;
    }

    public ScreenGuidebook(Screen parent) {
        super(parent);
        ScreenGuidebook.getPageManager();
    }

    @Override
    public void init() {
        super.init();
        this.mc.thePlayer.triggerAchievement(Achievements.OPEN_GUIDEBOOK);
        this.initTabList();
        Keyboard.enableRepeatEvents(true);
    }

    @Override
    public void removed() {
        super.removed();
        Keyboard.enableRepeatEvents(false);
    }

    private void initTabList() {
        this.tabs = new Tab[16];
        List<GuidebookSection> sections = GuidebookSections.getSectionList();
        int numTabs = sections.size();
        for (int i = 0; i < this.tabs.length && i < numTabs; ++i) {
            this.tabs[i] = new Tab(sections.get(i));
        }
        this.updateTabList();
    }

    private void updateTabList() {
        Object pages;
        List<GuidebookPage> search;
        SearchableGuidebookSection searchableGuidebookSection;
        int i;
        boolean hasLeftPage = guidebookPageManager.getLeftPage() != null;
        boolean hasRightPage = guidebookPageManager.getRightPage() != null;
        int left = this.width / 2 - this.xSize / (hasLeftPage && hasRightPage ? 2 : 4);
        int right = this.width / 2 + this.xSize / (hasLeftPage && hasRightPage ? 2 : 4);
        int top = this.height / 2 - this.ySize / 2;
        List<GuidebookSection> sections = GuidebookSections.getSectionList();
        int numTabs = sections.size();
        for (i = 0; i < 8 && i < numTabs; ++i) {
            this.tabs[i].setX(left - 36);
            this.tabs[i].setY(top + i * 26 + 7);
            this.tabs[i].setFlipped(false);
            GuidebookSection guidebookSection = sections.get(i);
            if (guidebookSection instanceof SearchableGuidebookSection) {
                searchableGuidebookSection = (SearchableGuidebookSection)guidebookSection;
                if (GuidebookPageManager.searchQuery != null) {
                    search = searchableGuidebookSection.searchPages(GuidebookPageManager.searchQuery);
                    if (!search.isEmpty()) {
                        this.tabs[i].setActive(search.get(0) == guidebookPageManager.getLeftPage() || search.get(0) == guidebookPageManager.getRightPage());
                        continue;
                    }
                    this.tabs[i].setActive(false);
                    continue;
                }
            }
            if (!(pages = sections.get(i).getPages()).isEmpty()) {
                this.tabs[i].setActive(pages.get(0) == guidebookPageManager.getLeftPage() || pages.get(0) == guidebookPageManager.getRightPage());
                continue;
            }
            this.tabs[i].setActive(false);
        }
        for (i = 8; i < 16 && i < numTabs; ++i) {
            this.tabs[i].setX(right);
            this.tabs[i].setY(top + (i - 8) * 26 + 7);
            this.tabs[i].setFlipped(true);
            if (sections.get(i).getPages().isEmpty()) continue;
            pages = sections.get(i);
            if (pages instanceof SearchableGuidebookSection) {
                searchableGuidebookSection = (SearchableGuidebookSection)pages;
                if (GuidebookPageManager.searchQuery != null) {
                    search = searchableGuidebookSection.searchPages(GuidebookPageManager.searchQuery);
                    if (!search.isEmpty()) {
                        this.tabs[i].setActive(search.get(0) == guidebookPageManager.getLeftPage() || search.get(0) == guidebookPageManager.getRightPage());
                        continue;
                    }
                    this.tabs[i].setActive(false);
                    continue;
                }
            }
            if (!(pages = sections.get(i).getPages()).isEmpty()) {
                this.tabs[i].setActive(pages.get(0) == guidebookPageManager.getLeftPage() || pages.get(0) == guidebookPageManager.getRightPage());
                continue;
            }
            this.tabs[i].setActive(false);
        }
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void render(int mx, int my, float renderPartialTicks) {
        this.lastPage = guidebookPageManager.getLeftPage();
        this.scroll(Mouse.getDWheel());
        int xOffset = 0;
        if (guidebookPageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (guidebookPageManager.getRightPage() == null) {
            xOffset = 79;
        }
        this.renderBackground();
        this.drawTabs(mx, my);
        this.drawCurrentPages(mx, my, xOffset, renderPartialTicks);
        this.drawHeaders(xOffset);
        this.drawCurrentPageOverlays(mx, my, xOffset, renderPartialTicks);
        this.drawPageTurnIndicator(mx, my, xOffset);
        this.drawTooltip(mx, my);
    }

    private void scroll(int direction) {
        if (direction == 0) {
            return;
        }
        int count = 1;
        if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
            count = 10;
            if (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                count = 100;
            }
        }
        guidebookPageManager.offsetPage(MathHelper.clamp(-direction, -1, 1) * 2 * count);
        this.playPageSound();
        this.updateTabList();
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (buttonNum == 3) {
            guidebookPageManager.goBack();
            this.playPageSound();
            this.updateTabList();
            return;
        }
        if (buttonNum == 4) {
            guidebookPageManager.goForward();
            this.playPageSound();
            this.updateTabList();
            return;
        }
        int xOffset = 0;
        if (guidebookPageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (guidebookPageManager.getRightPage() == null) {
            xOffset = 79;
        }
        int size = 24;
        int top = this.height / 2 - this.ySize / 2;
        int bottom = this.height / 2 + this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        int right = this.width / 2 + this.xSize / 2 + xOffset;
        if (guidebookPageManager.getLeftPage() != null && guidebookPageManager.hasPreviousPage()) {
            if (mx >= left && mx <= left + size && my >= top && my <= top + size) {
                guidebookPageManager.offsetPage(-2);
                this.playPageSound();
                this.updateTabList();
                return;
            }
            if (mx >= left && mx <= left + size && my >= bottom - size && my <= bottom) {
                guidebookPageManager.offsetPage(-2);
                this.playPageSound();
                this.updateTabList();
                return;
            }
        }
        if (guidebookPageManager.getRightPage() != null && guidebookPageManager.hasNextPage()) {
            if (mx >= right - size && mx <= right && my >= top && my <= top + size) {
                guidebookPageManager.offsetPage(2);
                this.playPageSound();
                this.updateTabList();
                return;
            }
            if (mx >= right - size && mx <= right && my >= bottom - size && my <= bottom) {
                guidebookPageManager.offsetPage(2);
                this.playPageSound();
                this.updateTabList();
                return;
            }
        }
        if (guidebookPageManager.getLeftPage() != null && mx > left && mx < left + this.xSize / 2 && my > top && my < bottom) {
            guidebookPageManager.getLeftPage().onMouseDown(left, top, mx, my, buttonNum);
            this.updateTabList();
            return;
        }
        if (guidebookPageManager.getRightPage() != null && mx > left + this.xSize / 2 && mx < right && my > top && my < bottom) {
            guidebookPageManager.getRightPage().onMouseDown(left + this.xSize / 2, top, mx, my, buttonNum);
            this.updateTabList();
            return;
        }
        this.handleTabClicks(mx, my);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.getParentScreen());
            return;
        }
        if (eventKey != Keyboard.KEY_BACK) {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
        int xOffset = 0;
        if (guidebookPageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (guidebookPageManager.getRightPage() == null) {
            xOffset = 79;
        }
        int top = this.height / 2 - this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        if (allowArrowKeyNavigation) {
            if (eventKey == Keyboard.KEY_LEFT) {
                guidebookPageManager.offsetPage(-2);
                this.updateTabList();
            }
            if (eventKey == Keyboard.KEY_RIGHT) {
                guidebookPageManager.offsetPage(2);
                this.updateTabList();
            }
        }
        boolean consumedInput = false;
        if (guidebookPageManager.getLeftPage() != null) {
            consumedInput |= guidebookPageManager.getLeftPage().keyTyped(eventCharacter, eventKey, left, top, mx, my);
            this.updateTabList();
        }
        if (guidebookPageManager.getRightPage() != null) {
            consumedInput |= guidebookPageManager.getRightPage().keyTyped(eventCharacter, eventKey, left + this.xSize / 2, top, mx, my);
            this.updateTabList();
        }
        if (!consumedInput && GameSettings.KEY_GUIDEBOOK.isKeyboardKey(eventKey)) {
            this.mc.displayScreen(this.getParentScreen());
        }
    }

    private void handleTabClicks(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) {
                return;
            }
            if (!tab.mouseOver(mouseX, mouseY)) continue;
            guidebookPageManager.setCurrentPage(guidebookPageManager.getSectionIndex(tab.getSection()), true);
            this.playPageSound();
            this.updateTabList();
            return;
        }
    }

    private void playPageSound() {
        if (!this.canPlaySound || this.lastPage == guidebookPageManager.getLeftPage()) {
            return;
        }
        this.canPlaySound = false;
        Random r = new Random();
        this.mc.sndManager.playSound("random.page", SoundCategory.GUI_SOUNDS, 0.8f, 0.9f + (r.nextFloat() - r.nextFloat()) * 0.1f);
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        int currentPage;
        Tab t;
        super.guiSpecificControllerInput(controller);
        if (controller.digitalPad.left.pressedThisFrame() || controller.digitalPad.left.isPressed() && controller.digitalPad.left.getHoldTime() % 4 == 0) {
            guidebookPageManager.offsetPage(-2);
            this.updateTabList();
        }
        if (controller.digitalPad.right.pressedThisFrame() || controller.digitalPad.right.isPressed() && controller.digitalPad.right.getHoldTime() % 4 == 0) {
            guidebookPageManager.offsetPage(2);
            this.updateTabList();
        }
        if (controller.buttonRightShoulder.pressedThisFrame() && (t = this.getTab(guidebookPageManager.getCurrentSection(), true)) != null) {
            currentPage = guidebookPageManager.getPageIndex(guidebookPageManager.getLeftPage());
            guidebookPageManager.setCurrentPage(guidebookPageManager.getSectionIndex(t.getSection()), true);
            if (currentPage == guidebookPageManager.getPageIndex(guidebookPageManager.getLeftPage())) {
                guidebookPageManager.offsetPage(2);
            }
            this.updateTabList();
        }
        if (controller.buttonLeftShoulder.pressedThisFrame() && (t = this.getTab(guidebookPageManager.getCurrentSection(), false)) != null) {
            currentPage = guidebookPageManager.getPageIndex(guidebookPageManager.getLeftPage());
            guidebookPageManager.setCurrentPage(guidebookPageManager.getSectionIndex(t.getSection()), true);
            if (currentPage == guidebookPageManager.getPageIndex(guidebookPageManager.getLeftPage())) {
                guidebookPageManager.offsetPage(-2);
            }
            this.updateTabList();
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.displayScreen(this.getParentScreen());
        }
    }

    private Tab getTab(GuidebookSection section, boolean searchForward) {
        int i;
        Tab tab = null;
        int index = -1;
        for (i = 0; i < this.tabs.length; ++i) {
            Tab t = this.tabs[i];
            if (t == null || t.getSection() != section) continue;
            if (section instanceof GuidebookSectionSearch) {
                index = i + 1;
                tab = this.tabs[i + 1];
                break;
            }
            index = i;
            tab = t;
            break;
        }
        if (tab == null) {
            return null;
        }
        for (i = 1; i < this.tabs.length; ++i) {
            int searchDex = (this.tabs.length + index + (searchForward ? i : -i)) % this.tabs.length;
            if (this.tabs[searchDex] == null) continue;
            return this.tabs[searchDex];
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        this.canPlaySound = true;
        if (guidebookPageManager.getLeftPage() != null) {
            guidebookPageManager.getLeftPage().onTick();
        }
        if (guidebookPageManager.getRightPage() != null) {
            guidebookPageManager.getRightPage().onTick();
        }
        allowArrowKeyNavigation = !(guidebookPageManager.getLeftPage() instanceof GuidebookPageSearch) && !(guidebookPageManager.getRightPage() instanceof GuidebookPageSearch) || !GuidebookPageSearch.searchField.isFocused || GuidebookPageSearch.searchField.getText().isEmpty();
    }

    private void drawTabs(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) break;
            tab.render(this.mc.textureManager, this.mc.font, mouseX, mouseY);
        }
    }

    private void drawTooltip(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) break;
            if (!tab.mouseOver(mouseX, mouseY)) continue;
            tab.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    private void drawCurrentPages(int mouseX, int mouseY, int xOffset, float partialTicks) {
        int top = this.height / 2 - this.ySize / 2;
        int bottom = this.height / 2 + this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        int right = this.width / 2 + this.xSize / 2 + xOffset;
        GuidebookPage leftPage = guidebookPageManager.getLeftPage();
        GuidebookPage rightPage = guidebookPageManager.getRightPage();
        if (leftPage != null) {
            leftPage.render(this.mc.textureManager, this.mc.font, left, top, mouseX, mouseY, partialTicks);
        }
        if (rightPage != null) {
            rightPage.render(this.mc.textureManager, this.mc.font, right - 158, top, mouseX, mouseY, partialTicks);
        }
    }

    private void drawCurrentPageOverlays(int mouseX, int mouseY, int xOffset, float partialTicks) {
        int top = this.height / 2 - this.ySize / 2;
        int bottom = this.height / 2 + this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        int right = this.width / 2 + this.xSize / 2 + xOffset;
        GuidebookPage leftPage = guidebookPageManager.getLeftPage();
        GuidebookPage rightPage = guidebookPageManager.getRightPage();
        if (leftPage != null) {
            leftPage.renderOverlay(this.mc.textureManager, this.mc.font, left, top, mouseX, mouseY, partialTicks);
        }
        if (rightPage != null) {
            rightPage.renderOverlay(this.mc.textureManager, this.mc.font, right - 158, top, mouseX, mouseY, partialTicks);
        }
    }

    private void drawHeaders(int xOffset) {
        int bottom = this.height / 2 + this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        int right = this.width / 2 + this.xSize / 2 + xOffset;
        GuidebookPage leftPage = guidebookPageManager.getLeftPage();
        GuidebookPage rightPage = guidebookPageManager.getRightPage();
        if (leftPage != null && leftPage.drawHeaders()) {
            this.drawStringNoShadow(this.fontRenderer, String.valueOf(guidebookPageManager.getPageIndex(leftPage)), left + 12, bottom - 20, -16777216);
            this.drawStringCenteredNoShadow(this.fontRenderer, I18n.getInstance().translateKey(guidebookPageManager.getLeftPage().getSection().getTranslationKey()), left + 79, bottom - 20, -8355712);
        }
        if (rightPage != null && rightPage.drawHeaders()) {
            String str = String.valueOf(guidebookPageManager.getPageIndex(rightPage));
            this.drawStringNoShadow(this.fontRenderer, str, right - 12 - MathHelper.ceil(this.fontRenderer.stringWidthDouble(str)), bottom - 20, -16777216);
            this.drawStringCenteredNoShadow(this.fontRenderer, I18n.getInstance().translateKey(guidebookPageManager.getRightPage().getSection().getTranslationKey()), right - 79, bottom - 20, -8355712);
        }
    }

    private void drawPageTurnIndicator(int mouseX, int mouseY, int xOffset) {
        int size = 24;
        int top = this.height / 2 - this.ySize / 2;
        int bottom = this.height / 2 + this.ySize / 2;
        int left = this.width / 2 - this.xSize / 2 + xOffset;
        int right = this.width / 2 + this.xSize / 2 + xOffset;
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (guidebookPageManager.getLeftPage() != null && guidebookPageManager.hasPreviousPage()) {
            if (mouseX >= left && mouseX <= left + size && mouseY >= top && mouseY <= top + size) {
                this.drawTexturedModalRect(left, top, 0, 220, 24, 24);
            }
            if (mouseX >= left && mouseX <= left + size && mouseY >= bottom - size && mouseY <= bottom) {
                this.drawTexturedModalRect(left, bottom - size, 48, 220, 24, 24);
            }
        }
        if (guidebookPageManager.getRightPage() != null && guidebookPageManager.hasNextPage()) {
            if (mouseX >= right - size && mouseX <= right && mouseY >= top && mouseY <= top + size) {
                this.drawTexturedModalRect(right - size, top, 24, 220, 24, 24);
            }
            if (mouseX >= right - size && mouseX <= right && mouseY >= bottom - size && mouseY <= bottom) {
                this.drawTexturedModalRect(right - size, bottom - size, 72, 220, 24, 24);
            }
        }
    }

    private static class Tab
    extends Gui {
        private static final EntityRendererItem itemRenderer = new EntityRendererItem();
        private static final int WIDTH = 36;
        private static final int HEIGHT = 24;
        private final GuidebookSection section;
        private int x = 0;
        private int y = 0;
        private boolean flipped = false;
        private boolean active = false;

        public Tab(GuidebookSection section) {
            this.section = section;
        }

        public GuidebookSection getSection() {
            return this.section;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setFlipped(boolean flipped) {
            this.flipped = flipped;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void render(TextureManager re, FontRenderer sr, int mouseX, int mouseY) {
            boolean mouseOver = this.mouseOver(mouseX, mouseY);
            re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
            int xo = 16;
            if (mouseOver || this.active) {
                xo = 0;
            }
            if (this.flipped) {
                xo = -xo;
            }
            int u = 158;
            int v = 0;
            if (this.flipped) {
                v = 48;
            }
            int bgColor = this.section.getBackgroundColor();
            int fgColor = this.section.getForegroundColor();
            ItemStack icon = this.section.getTabIcon();
            GLRenderer.setColor1i(0xFF000000 | bgColor);
            this.drawTexturedModalRect(this.x + xo, this.y, u, v, 36, 24);
            GLRenderer.setColor1i(0xFF000000 | fgColor);
            this.drawTexturedModalRect(this.x + xo, this.y, u, v + 24, 36, 24);
            if (icon != null) {
                int iconOffset = this.flipped ? 4 : 16;
                GLRenderer.setDepthMask(true);
                Lighting.enableInventoryLight();
                GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GLRenderer.enableState(State.DEPTH_TEST);
                ItemModelDispatcher.getInstance().getDispatch(icon).renderGui(GLRenderer.getTessellator(), null, icon, this.x + iconOffset + xo, this.y + 4, LightIndexHelper.lightIndex2i(15, 15), 1.0f);
                GLRenderer.disableState(State.DEPTH_TEST);
                Lighting.disable();
                GLRenderer.globalSetLightEnabled(false);
                GLRenderer.disableState(State.DEPTH_TEST);
            }
        }

        public void renderTooltip(TooltipElement tooltip, int mouseX, int mouseY) {
            if (this.mouseOver(mouseX, mouseY)) {
                tooltip.render(I18n.getInstance().translateKey(this.section.getTranslationKey()), mouseX, mouseY, 8, -8);
            }
        }

        public boolean mouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + 36 && mouseY >= this.y && mouseY <= this.y + 24;
        }
    }
}

