/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererDeer
extends MobRenderer<MobDeer> {
    private static final float MIN_NECK_ROT_X_SNIFF = 1.0f;
    private static final float MAX_NECK_ROT_X_SNIFF = 1.6f;
    private static final float MIN_HEAD_ROT_X_SNIFF = -0.4f;
    private static final float MAX_HEAD_ROT_X_SNIFF = -0.9f;

    public MobRendererDeer(float shadowSize) {
        super(shadowSize);
    }

    @Override
    protected void preRenderTransform(@NotNull MobDeer entity, double x, double y, double z, float yaw, float partialTick) {
        super.preRenderTransform(entity, x, y, z, yaw, partialTick);
        GLRenderer.modelM4f().scale(1.1f, 1.1f, 1.1f);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobDeer entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        BoneTransform neck = model.getTransform("neck");
        BoneTransform head = model.getTransform("head");
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        float bodyYaw = this.getBodyYaw(entity, partialTick);
        float headYaw = this.getHeadYaw(entity, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(entity, partialTick);
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        MobDeer.BrainState brainState = entity.brainState;
        if (brainState instanceof MobDeer.SniffingBrainState) {
            @NotNull MobDeer.SniffingBrainState brainState2 = (MobDeer.SniffingBrainState)brainState;
            float neckRotX = MathHelper.lerp(1.0f, 1.6f, brainState2.leanPercentage);
            float headRotX = MathHelper.lerp(-0.4f, -0.9f, brainState2.leanPercentage);
            if (brainState2.timer <= brainState2.intoSniffTime) {
                float offsetTimer = (float)brainState2.timer + partialTick;
                float pctg = MathHelper.smootherstep(MathHelper.clamp(offsetTimer / (float)brainState2.intoSniffTime, 0.0f, 1.0f), 0.0f, 1.0f);
                neck.rotX = MathHelper.lerp(headPitch, neckRotX, pctg);
                head.rotX = MathHelper.lerp(0.0f, headRotX, pctg);
                head.rotY = MathHelper.lerp(headYaw, 0.0f, pctg);
            } else if (brainState2.timer <= brainState2.intoSniffTime + brainState2.sniffTime) {
                neck.rotX = neckRotX;
                head.rotX = headRotX;
                head.rotY = 0.0;
            } else {
                float offsetTimer = (float)(brainState2.timer - (brainState2.intoSniffTime + brainState2.sniffTime)) + partialTick;
                float pctg = MathHelper.smootherstep(MathHelper.clamp(offsetTimer / (float)brainState2.outOfSniffTime, 0.0f, 1.0f), 0.0f, 1.0f);
                neck.rotX = MathHelper.lerp(neckRotX, headPitch, pctg);
                head.rotX = MathHelper.lerp(headRotX, 0.0f, pctg);
                head.rotY = MathHelper.lerp(0.0f, headYaw, pctg);
            }
        } else {
            neck.rotX = headPitch;
            head.rotX = 0.0;
            head.rotY = headYaw;
        }
        leg0.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        leg1.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg2.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        leg3.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        return model;
    }
}

