/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRendererBipedArmored;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererZombie
extends MobRendererBipedArmored<MobZombie> {
    public MobRendererZombie(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getActiveModel(@NotNull MobZombie entity) {
        return this.getModel("main");
    }

    @Override
    @Nullable
    protected StaticEntityModel setupAnimations(@NotNull MobZombie entity, @Nullable StaticEntityModel model, float partialTick, int layer) {
        if (model == null) {
            return null;
        }
        StaticEntityModel model1 = super.setupAnimations(entity, model, partialTick, layer);
        BoneTransform rightArm = model.getTransform("rightArm");
        BoneTransform leftArm = model.getTransform("leftArm");
        float limbPitch = this.getLimbPitch(entity, partialTick);
        float swingProgress = entity.getSwingProgress(partialTick);
        float var7 = MathHelper.sin(swingProgress * (float)Math.PI);
        float var8 = MathHelper.sin((1.0f - (1.0f - swingProgress) * (1.0f - swingProgress)) * (float)Math.PI);
        rightArm.rotZ = 0.0;
        leftArm.rotZ = 0.0;
        rightArm.rotY = -(0.1f - var7 * 0.6f);
        leftArm.rotY = 0.1f - var7 * 0.6f;
        rightArm.rotX = -90.0f * MathHelper.DEG_TO_RAD;
        leftArm.rotX = -90.0f * MathHelper.DEG_TO_RAD;
        rightArm.rotX -= (double)(var7 * 1.2f - var8 * 0.4f);
        leftArm.rotX -= (double)(var7 * 1.2f - var8 * 0.4f);
        rightArm.rotZ += (double)(MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f);
        leftArm.rotZ -= (double)(MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f);
        rightArm.rotX += (double)(MathHelper.sin(limbPitch * 0.067f) * 0.05f);
        leftArm.rotX -= (double)(MathHelper.sin(limbPitch * 0.067f) * 0.05f);
        return model1;
    }
}

