/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.particle.ParticleArrowGolden;
import net.minecraft.client.render.particle.ParticleAsh;
import net.minecraft.client.render.particle.ParticleBlockBreaking;
import net.minecraft.client.render.particle.ParticleBubble;
import net.minecraft.client.render.particle.ParticleEntry;
import net.minecraft.client.render.particle.ParticleExplode;
import net.minecraft.client.render.particle.ParticleFirefly;
import net.minecraft.client.render.particle.ParticleFlame;
import net.minecraft.client.render.particle.ParticleFluidDrip;
import net.minecraft.client.render.particle.ParticleFootstep;
import net.minecraft.client.render.particle.ParticleHeart;
import net.minecraft.client.render.particle.ParticleItemBreaking;
import net.minecraft.client.render.particle.ParticleLava;
import net.minecraft.client.render.particle.ParticleLeaf;
import net.minecraft.client.render.particle.ParticleNote;
import net.minecraft.client.render.particle.ParticlePortal;
import net.minecraft.client.render.particle.ParticlePuffRGB;
import net.minecraft.client.render.particle.ParticleRedstoneDust;
import net.minecraft.client.render.particle.ParticleSlimeChunk;
import net.minecraft.client.render.particle.ParticleSmoke;
import net.minecraft.client.render.particle.ParticleSnowShovel;
import net.minecraft.client.render.particle.ParticleSplash;
import net.minecraft.client.render.particle.ParticleVentSmoke;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.BlockParticleHelper;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public final class ParticleDispatcher
extends Dispatcher<String, ParticleEntry> {
    private static ParticleDispatcher INSTANCE = new ParticleDispatcher();
    private static final ParticleEntry BLANK = new ParticleEntry(){

        @Override
        public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
            return null;
        }
    };

    public static ParticleDispatcher getInstance() {
        return INSTANCE;
    }

    public List<String> getParticleIds() {
        return new ArrayList<String>(this.dispatches.keySet());
    }

    @Override
    protected ParticleEntry getDefault() {
        return BLANK;
    }

    private ParticleDispatcher() {
        INSTANCE = this;
        final Minecraft mc = Minecraft.getMinecraft();
        this.addDispatch("bubble", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleBubble(world, x, y, z, motionX, motionY, motionZ, true);
            }
        });
        this.addDispatch("smoke", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleSmoke(world, x, y, z, motionX, motionY, motionZ, 1.0f, data);
            }
        });
        this.addDispatch("note", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleNote(world, x, y, z, motionX, motionY, motionZ, data);
            }
        });
        this.addDispatch("portal", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticlePortal(world, x, y, z, motionX, motionY, motionZ, data);
            }
        });
        this.addDispatch("explode", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleExplode(world, x, y, z, motionX, motionY, motionZ);
            }
        });
        this.addDispatch("flame", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFlame(world, x, y, z, motionX, motionY, motionZ, ParticleFlame.Type.ORANGE);
            }
        });
        this.addDispatch("blueflame", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFlame(world, x, y, z, motionX, motionY, motionZ, ParticleFlame.Type.BLUE);
            }
        });
        this.addDispatch("soulflame", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFlame(world, x, y, z, motionX, motionY, motionZ, ParticleFlame.Type.SOUL);
            }
        });
        this.addDispatch("lava", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleLava(world, x, y, z);
            }
        });
        this.addDispatch("footstep", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFootstep(mc.textureManager, world, x, y, z);
            }
        });
        this.addDispatch("splash", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleSplash(world, x, y, z, motionX, motionY, motionZ);
            }
        });
        this.addDispatch("largesmoke", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleSmoke(world, x, y, z, motionX, motionY, motionZ, 2.5f, data);
            }
        });
        this.addDispatch("puffrgb", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticlePuffRGB(world, x, y, z, (float)motionX, (float)motionY, (float)motionZ, data);
            }
        });
        this.addDispatch("reddust", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleRedstoneDust(world, x, y, z, data);
            }
        });
        this.addDispatch("item", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleItemBreaking(world, x, y, z, Item.itemsList[MathHelper.clamp(data, 0, Item.itemsList.length - 1)]);
            }
        });
        this.addDispatch("block", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleBlockBreaking(world, x, y, z, motionX, motionY, motionZ, Blocks.blocksList[BlockParticleHelper.decodeBlockID(data)], BlockParticleHelper.decodeBlockSide(data), BlockParticleHelper.decodeBlockMeta(data)).init(new TilePos(x, y, z));
            }
        });
        this.addDispatch("snowshovel", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleSnowShovel(world, x, y, z, motionX, motionY, motionZ);
            }
        });
        this.addDispatch("heart", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleHeart(world, x, y, z, motionX, motionY, motionZ);
            }

            @Override
            public boolean enabled() {
                return GameSettings.PARTICLES_QUALITY.value != ParticlesQuality.NONE;
            }
        });
        this.addDispatch("slimechunk", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleSlimeChunk(world, x, y, z, Items.SLIMEBALL);
            }

            @Override
            public boolean enabled() {
                return (Boolean)GameSettings.SLIME_PARTICLES.value;
            }
        });
        this.addDispatch("fireflyGreen", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFirefly(world, x, y, z, motionX, motionY, motionZ, MobFireflyCluster.FireflyColor.GREEN.getId());
            }
        });
        this.addDispatch("fireflyBlue", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFirefly(world, x, y, z, motionX, motionY, motionZ, MobFireflyCluster.FireflyColor.BLUE.getId());
            }
        });
        this.addDispatch("fireflyOrange", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFirefly(world, x, y, z, motionX, motionY, motionZ, MobFireflyCluster.FireflyColor.ORANGE.getId());
            }
        });
        this.addDispatch("fireflyRed", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFirefly(world, x, y, z, motionX, motionY, motionZ, MobFireflyCluster.FireflyColor.RED.getId());
            }
        });
        this.addDispatch("arrowtrail", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleArrowGolden(world, x, y, z, motionX, motionY, motionZ);
            }

            @Override
            public boolean enabled() {
                return GameSettings.PARTICLES_QUALITY.value != ParticlesQuality.NONE;
            }
        });
        this.addDispatch("fallingleaf", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                TilePos tilePos = new TilePos(x, y, z);
                if (!world.isAirBlock(tilePos)) {
                    return new ParticleLeaf(world, x, y, z, motionX, motionY, motionZ).init(tilePos);
                }
                return null;
            }
        });
        this.addDispatch("dripWater", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(Blocks.FLUID_WATER_STILL)).getWorldColor(world, new TilePos(x, y, z), 0);
                return new ParticleFluidDrip(world, x, y, z, color, TextureRegistry.getTexture("minecraft:block/water_flowing"));
            }
        });
        this.addDispatch("dripLava", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleFluidDrip(world, x, y, z, 0xFFFFFF, TextureRegistry.getTexture("minecraft:block/lava_flowing")).setFullBright();
            }
        });
        this.addDispatch("ashmote", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleAsh(world, x, y, z, 0.0, 0.0, 0.0);
            }
        });
        this.addDispatch("ventsmoke", new ParticleEntry(){

            @Override
            public Particle newParticle(@NotNull World world, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
                return new ParticleVentSmoke(world, x, y, z, motionX, motionY, motionX, 2.5f, data);
            }
        });
    }
}

