/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticlePortal
extends Particle {
    private final float oSize;
    private final double xStart;
    private final double yStart;
    private final double zStart;

    public ParticlePortal(World world, double x, double y, double z, double xd, double yd, double zd, int data) {
        super(world, x, y, z, xd, yd, zd);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.xStart = this.x = x;
        this.yStart = this.y = y;
        this.zStart = this.z = z;
        float br = random.nextFloat() * 0.6f + 0.4f;
        this.oSize = this.size = random.nextFloat() * 0.2f + 0.5f;
        Color color = Colors.allPortalColors[data];
        this.gCol = this.bCol = br;
        this.rCol = this.bCol;
        this.rCol *= (float)color.getRed() / 255.0f;
        this.gCol *= (float)color.getGreen() / 255.0f;
        this.bCol *= (float)color.getBlue() / 255.0f;
        this.lifetime = (int)(Math.random() * 10.0) + 40;
        this.noPhysics = true;
        this.tex = TextureRegistry.getTexture("minecraft:particle/puff_" + (int)(Math.random() * 8.0));
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        float s = ((float)this.age + partialTick) / (float)this.lifetime;
        s = 1.0f - s;
        s *= s;
        s = 1.0f - s;
        this.size = this.oSize * s;
        super.render(t, partialTick);
    }

    @Override
    public float calcBrightness(float partialTick) {
        float br = super.calcBrightness(partialTick);
        float pos = (float)this.age / (float)this.lifetime;
        pos *= pos;
        pos *= pos;
        return br * (1.0f - pos) + pos;
    }

    @Override
    public void tick() {
        float pos;
        this.cachedLightmapCoord = this.calcLightIndex(1.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float a = pos = (float)this.age / (float)this.lifetime;
        pos = -pos + pos * pos * 2.0f;
        pos = 1.0f - pos;
        this.x = this.xStart + this.xd * (double)pos;
        this.y = this.yStart + this.yd * (double)pos + (double)(1.0f - a);
        this.z = this.zStart + this.zd * (double)pos;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }
}

