/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.core.lang.Language;
import net.minecraft.core.lang.LanguageSeeker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class I18n {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static I18n INSTANCE = null;
    @Nullable
    private Language currentLanguage = null;

    public static void initialize(@NotNull String languageCode) {
        INSTANCE = new I18n(languageCode);
    }

    @NotNull
    public static I18n getInstance() {
        assert (INSTANCE != null) : "I18n must be initialized before an instance is valid!";
        return INSTANCE;
    }

    private I18n(@NotNull String languageCode) {
        if (!LanguageSeeker.LANGUAGE_DIR.exists()) {
            LanguageSeeker.LANGUAGE_DIR.mkdirs();
        }
        this.reload(languageCode);
    }

    public final void reload(@NotNull String languageCode) {
        if (this.currentLanguage != null) {
            this.currentLanguage.onReload();
        }
        try {
            this.currentLanguage = LanguageSeeker.seek(languageCode);
            if (this.currentLanguage == null) {
                this.currentLanguage = Language.Default.INSTANCE;
            }
        }
        catch (IOException e) {
            this.currentLanguage = Language.Default.INSTANCE;
        }
        LOGGER.info("{} translation keys in {}", (Object)this.currentLanguage.keySize(), (Object)this.currentLanguage.getName());
    }

    @NotNull
    public String translateKey(@NotNull String key) {
        if (this.currentLanguage == null) {
            return key;
        }
        return this.currentLanguage.translateKey(key);
    }

    @NotNull
    public String translateKeyAndFormat(@NotNull String key, Object ... args2) {
        if (this.currentLanguage == null) {
            return key;
        }
        return this.currentLanguage.translateKeyAndFormat(key, args2);
    }

    @Nullable
    public Language getCurrentLanguage() {
        return this.currentLanguage;
    }

    @Nullable
    public static InputStream getResourceAsStream(@NotNull String path) {
        return I18n.class.getResourceAsStream(path);
    }

    @NotNull
    public static @NotNull String @NotNull [] getFilesInDirectory(@NotNull String directory) {
        ArrayList paths;
        block19: {
            paths = new ArrayList();
            if (!((String)directory).endsWith("/")) {
                directory = (String)directory + "/";
            }
            try {
                @Nullable URL url = I18n.class.getResource((String)directory);
                if (url == null) {
                    return new String[0];
                }
                @NotNull URI uri = url.toURI();
                if (uri.getScheme().equals("jar")) {
                    try (@NotNull FileSystem files = FileSystems.getFileSystem(uri);){
                        I18n.walkFiles((String)directory, files.getPath((String)directory, new String[0]), paths);
                        break block19;
                    }
                    catch (Exception e) {
                        try (@NotNull FileSystem files2 = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                            I18n.walkFiles((String)directory, files2.getPath((String)directory, new String[0]), paths);
                            break block19;
                        }
                    }
                }
                I18n.walkFiles((String)directory, Paths.get(uri), paths);
            }
            catch (Exception e) {
                LOGGER.error("Exception while loading all files in directory '{}' in translator!", directory, (Object)e);
            }
        }
        return paths.toArray(new String[0]);
    }

    private static void walkFiles(@NotNull String directory, @NotNull Path path, @NotNull @NotNull Collection<? super @NotNull String> paths) throws IOException {
        try (Stream<Path> walk = Files.walk(path, 1, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            it.next();
            while (it.hasNext()) {
                paths.add(directory + ((Path)it.next()).getFileName().toString());
            }
        }
    }
}

