/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.BlockLogicSignPainted;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.PacketSignUpdate;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.Nullability;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.lwjgl.input.Keyboard;

public class ScreenSignEditor
extends Screen {
    @NotNull
    private static final String ALLOWED_CHARACTERS = ChatAllowedCharacters.ALLOWED_CHARACTERS;
    @NotNull
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_sign.label.title");
    @NotNull
    private final TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;
    private int yOffset = 0;
    private static final float SMALL_SIGN_SIZE = 3.0f;
    private boolean inKeyboard = false;

    public ScreenSignEditor(@NotNull TileEntitySign sign) {
        this.entitySign = sign;
    }

    @Override
    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents(true);
        @NotNull Block<?> block = this.entitySign.getBlock();
        if (block == Blocks.SIGN_POST_PLANKS_OAK) {
            this.yOffset = 36;
        }
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, 200 + this.yOffset, I18n.getInstance().translateKey("gui.edit_sign.button.done")));
        boolean wallSign = false;
        if (Block.hasLogicClass(block, BlockLogicSign.class)) {
            wallSign = !((BlockLogicSign)block.getLogic()).isFreeStanding;
        }
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 67 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 0;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 79 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 1;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 91 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 2;
            this.inKeyboard = true;
        })).mute().hide();
        this.add(new ListenerButtonElement(30, this.width / 2 - 50, 103 + (wallSign ? 31 : 0), 100, 12, "").setActionListener(() -> {
            this.editLine = 3;
            this.inKeyboard = true;
        })).mute().hide();
        this.inKeyboard = ((Boolean)GameSettings.FORCE_ONSCREEN_KEYBOARD.value != false || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard);
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
        if (this.mc.currentWorld != null && this.mc.currentWorld.isClientSide) {
            Objects.requireNonNull(this.mc.getSendQueue()).addToSendQueue(new PacketSignUpdate(this.entitySign.x, this.entitySign.y, this.entitySign.z, this.entitySign.signText, this.entitySign.getPicture().getId(), this.entitySign.getColor().id));
        }
    }

    @Override
    public void tick() {
        ++this.updateCounter;
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.entitySign.setChanged();
            this.mc.displayScreen(null);
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.entitySign.setChanged();
            this.mc.displayScreen(null);
        }
        if (eventKey == Keyboard.KEY_UP) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (eventKey == Keyboard.KEY_DOWN || eventKey == Keyboard.KEY_PRINT_SCREEN || eventKey == Keyboard.KEY_NUMPADENTER) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (eventKey == Keyboard.KEY_BACK && !this.entitySign.signText[this.editLine].isEmpty()) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if ((ALLOWED_CHARACTERS.indexOf(eventCharacter) >= 0 || Character.isLetterOrDigit(eventCharacter)) && this.entitySign.signText[this.editLine].length() < 15) {
            int n = this.editLine;
            this.entitySign.signText[n] = this.entitySign.signText[n] + eventCharacter;
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        boolean isFreeStanding;
        super.mouseClicked(mx, my, buttonNum);
        int currentPictureIndex = Nullability.mapOr(this.entitySign.getPicture(), 0, EnumSignPicture::getId);
        int lastPictureIndex = currentPictureIndex <= 0 ? EnumSignPicture.values().length - 1 : currentPictureIndex - 1;
        @NotNull EnumSignPicture lastPicture = Objects.requireNonNull(EnumSignPicture.fromId(lastPictureIndex));
        int nextPictureIndex = currentPictureIndex >= EnumSignPicture.values().length - 1 ? 0 : currentPictureIndex + 1;
        @NotNull EnumSignPicture nextPicture = Objects.requireNonNull(EnumSignPicture.fromId(nextPictureIndex));
        Block<?> block = this.entitySign.getBlock();
        if (Block.hasLogicClass(block, BlockLogicSign.class)) {
            BlockLogicSign sign = (BlockLogicSign)block.getLogic();
            isFreeStanding = sign.isFreeStanding;
        } else {
            isFreeStanding = false;
        }
        int yOffset = isFreeStanding ? -29 : -2;
        double width = 72.0;
        double height = 72.0;
        int x = this.width / 2 - 36 - 108;
        int y = 99 + yOffset + 5;
        if (mx >= x && (double)mx <= (double)x + 72.0 && my >= y && (double)my <= (double)y + 72.0) {
            this.entitySign.setPicture(lastPicture);
            this.entitySign.setChanged();
            this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        x = this.width / 2 - 36 + 108;
        y = 99 + yOffset + 5;
        if (mx >= x && (double)mx <= (double)x + 72.0 && my >= y && (double)my <= (double)y + 72.0) {
            this.entitySign.setPicture(nextPicture);
            this.entitySign.setChanged();
            this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        boolean isFreeStanding;
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.inKeyboard && (((Boolean)GameSettings.FORCE_ONSCREEN_KEYBOARD.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard) && this.editLine < this.entitySign.signText.length) {
            ScreenKeyboard keyboard = new ScreenKeyboard(this, null, s -> {
                this.entitySign.signText[this.editLine] = s;
                if (this.editLine < this.entitySign.signText.length - 1) {
                    ++this.editLine;
                } else {
                    this.inKeyboard = false;
                }
            }, (c, k, s) -> {
                this.entitySign.signText[this.editLine] = s;
            }, s -> {
                this.entitySign.signText[this.editLine] = s;
            });
            keyboard.editor.setText(this.entitySign.signText[this.editLine]);
            keyboard.editor.setCursor(Integer.MAX_VALUE);
            this.mc.displayScreen(keyboard);
        }
        this.renderBackground();
        this.drawStringCenteredShadow(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)this.width / 2.0f, 0.0f, 50.0f);
        float scale = 93.75f;
        GLRenderer.modelM4f().scale(-93.75f, -93.75f, -93.75f);
        GLRenderer.modelM4f().rotateY((float)java.lang.Math.PI);
        Block<?> block = this.entitySign.getBlock();
        if (Block.hasLogicClass(block, BlockLogicSign.class)) {
            BlockLogicSign sign = (BlockLogicSign)block.getLogic();
            if (sign.isFreeStanding) {
                isFreeStanding = true;
                float signAngle = (float)((this.entitySign.getBlockMeta() & 0xF) * 360) / 16.0f;
                GLRenderer.modelM4f().rotateY(Math.toRadians(signAngle));
                GLRenderer.modelM4f().translate(0.0f, -1.0625f, 0.0f);
            } else {
                isFreeStanding = false;
                int meta = this.entitySign.getBlockMeta() & 0xF;
                float signAngle = 0.0f;
                if (meta == 2) {
                    signAngle = 180.0f;
                }
                if (meta == 4) {
                    signAngle = 90.0f;
                }
                if (meta == 5) {
                    signAngle = -90.0f;
                }
                GLRenderer.modelM4f().rotateY(Math.toRadians(signAngle));
                GLRenderer.modelM4f().translate(0.0f, -1.0625f, 0.0f);
            }
        } else {
            isFreeStanding = false;
        }
        if (this.updateCounter / 6 % 2 == 0) {
            this.entitySign.lineBeingEdited = this.editLine;
        }
        GLRenderer.enableState(State.BLEND);
        TileEntityRenderDispatcher.instance.renderTileEntity(GLRenderer.getTessellator(), this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        this.entitySign.lineBeingEdited = -1;
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
        this.zLevel = 100.0f;
        this.drawStringCenteredShadow(this.fontRenderer, I18n.getInstance().translateKey(this.entitySign.getPicture().getLanguageKey()), this.width / 2, 150 + this.yOffset, 0xFFFFFF);
        this.zLevel = 0.0f;
        int yOffset = isFreeStanding ? -29 : -2;
        int currentPictureIndex = Nullability.mapOr(this.entitySign.getPicture(), 0, EnumSignPicture::getId);
        int lastPictureIndex = currentPictureIndex <= 0 ? EnumSignPicture.values().length - 1 : currentPictureIndex - 1;
        @NotNull EnumSignPicture lastPicture = Objects.requireNonNull(EnumSignPicture.fromId(lastPictureIndex));
        int nextPictureIndex = currentPictureIndex >= EnumSignPicture.values().length - 1 ? 0 : currentPictureIndex + 1;
        @NotNull EnumSignPicture nextPicture = Objects.requireNonNull(EnumSignPicture.fromId(nextPictureIndex));
        this.drawFakeSign(this.width / 2 - 36 - 108, 99 + yOffset + 5, mx, my, block, this.entitySign.getBlockMeta(), lastPicture);
        this.drawFakeSign(this.width / 2 - 36 + 108, 99 + yOffset + 5, mx, my, block, this.entitySign.getBlockMeta(), nextPicture);
        super.render(mx, my, partialTick);
    }

    private void drawFakeSign(int x, int y, int mx, int my, @NotNull Block<?> block, int meta, @NotNull EnumSignPicture picture) {
        if (Block.hasLogicClass(block, BlockLogicSignPainted.class)) {
            @NotNull DyeColor c = ((IPainted)block.getLogic()).fromMetadata(meta);
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/entity/sign/" + c.colorID + ".png").bind();
        } else {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/entity/sign.png").bind();
        }
        boolean mouseOver = mx >= x && (float)mx <= (float)x + 72.0f && my >= y && (float)my <= (float)y + 36.0f;
        GLRenderer.pushFrame();
        if (!mouseOver) {
            GLRenderer.setColor4f(0.75f, 0.75f, 0.75f, 1.0f);
        } else {
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.drawTexturedModalRectDouble(x, y, 6.0, 6.0, 72.0, 36.0, 0.005208333333333333, 0.010416666666666666);
        if (picture != EnumSignPicture.NONE) {
            if (picture.isBlended()) {
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.ZERO, BlendFactor.SRC_COLOR);
            } else {
                GLRenderer.disableState(State.BLEND);
            }
            GLRenderer.setDepthMask(false);
            ScreenSignEditor.drawTexturedModalRect(x, y, 72.0, 36.0, TextureRegistry.getTexture(picture.getTextureKey()));
            GLRenderer.disableState(State.BLEND);
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.popFrame();
    }

    private static void drawTexturedModalRect(double x, double y, double width, double height, @NotNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setColor2i(0xFFFFFF, 64);
        tessellator.addVertexWithUV(x, y + height, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x, y, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x + width, y, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x + width, y + height, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.draw();
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
        if (controller.digitalPad.up.pressedThisFrame()) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (controller.digitalPad.down.pressedThisFrame()) {
            this.editLine = this.editLine + 1 & 3;
        }
    }
}

