/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicSignPainted
extends BlockLogicSign
implements IPainted {
    public static final int MASK_COLOR = 240;

    public BlockLogicSignPainted(@NotNull Block<?> block, boolean isFreeStanding) {
        super(block, isFreeStanding);
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((meta & 0xF0) >> 4);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xFFFFFF0F;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        world.setBlockDataNotify(tilePos, this.stripColorFromMetadata(world.getBlockData(tilePos)));
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        world.setBlockDataNotify(tilePos, color.blockMeta << 4 | this.stripColorFromMetadata(world.getBlockData(tilePos)));
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.SIGN_PAINTED, 1, this.fromMetadata((int)data).itemMeta)};
    }
}

