/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderProvider;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class ShaderGeometry
extends Shader {
    protected int geometryShader;

    @Override
    @NotNull
    public Shader compile(@NotNull ShaderProvider folder, @NotNull String name) {
        if (!this.supported) {
            return this;
        }
        OpenGLHelper.checkError("pre compile shader " + name);
        this.delete();
        String fragmentSource = folder.getShaderSource(name + ".fsh");
        String vertexSource = folder.getShaderSource(name + ".vsh");
        String geometrySource = folder.getShaderSource(name + ".gsh");
        if (fragmentSource == null) {
            return this;
        }
        if (vertexSource == null) {
            return this;
        }
        if (geometrySource == null) {
            return this;
        }
        this.vertexShader = GL41.glCreateShader(35633);
        this.fragmentShader = GL41.glCreateShader(35632);
        this.geometryShader = GL41.glCreateShader(36313);
        GL41.glShaderSource(this.vertexShader, (CharSequence)vertexSource);
        GL41.glShaderSource(this.fragmentShader, (CharSequence)fragmentSource);
        GL41.glShaderSource(this.geometryShader, (CharSequence)geometrySource);
        GL41.glCompileShader(this.vertexShader);
        GL41.glCompileShader(this.fragmentShader);
        GL41.glCompileShader(this.geometryShader);
        int vertexShaderCompileStatus = GL41.glGetShaderi(this.vertexShader, 35713);
        int fragmentShaderCompileStatus = GL41.glGetShaderi(this.fragmentShader, 35713);
        int geometryShaderCompileStatus = GL41.glGetShaderi(this.geometryShader, 35713);
        if (fragmentShaderCompileStatus != 1 || vertexShaderCompileStatus != 1 || geometryShaderCompileStatus != 1) {
            LOGGER.error("Shader {} compile error", (Object)name);
            if (vertexShaderCompileStatus != 1) {
                LOGGER.error("Vertex Shader Info Log: {}", (Object)GL41.glGetShaderInfoLog(this.vertexShader, GL41.glGetShaderi(this.vertexShader, 35716)));
            }
            if (fragmentShaderCompileStatus != 1) {
                LOGGER.error("Fragment Shader Info Log: {}", (Object)GL41.glGetShaderInfoLog(this.fragmentShader, GL41.glGetShaderi(this.fragmentShader, 35716)));
            }
            if (geometryShaderCompileStatus != 1) {
                LOGGER.error("Geometry Shader Info Log: {}", (Object)GL41.glGetShaderInfoLog(this.geometryShader, GL41.glGetShaderi(this.geometryShader, 35716)));
            }
            this.delete();
            return this;
        }
        this.program = GL41.glCreateProgram();
        GL41.glAttachShader(this.program, this.vertexShader);
        GL41.glAttachShader(this.program, this.fragmentShader);
        GL41.glAttachShader(this.program, this.geometryShader);
        GL41.glLinkProgram(this.program);
        int programLinkStatus = GL41.glGetProgrami(this.program, 35714);
        if (programLinkStatus != 1) {
            LOGGER.error("Program Link Error: ");
            LOGGER.error(GL41.glGetProgramInfoLog(this.program, GL41.glGetProgrami(this.program, 35716)));
            this.delete();
            return this;
        }
        GL41.glDeleteShader(this.vertexShader);
        GL41.glDeleteShader(this.fragmentShader);
        GL41.glDeleteShader(this.geometryShader);
        this.vertexShader = 0;
        this.fragmentShader = 0;
        this.geometryShader = 0;
        this.enabled = true;
        OpenGLHelper.checkError("compile shader " + name);
        return this;
    }
}

