/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.render.FrameBuffer;
import org.lwjgl.opengl.GL41;

public class FrameBufferMultisampled
extends FrameBuffer {
    private int blitId;

    @Override
    public boolean generate() {
        if (!super.generate()) {
            return false;
        }
        this.blitId = GL41.glGenFramebuffers();
        if (!this.isGenerated()) {
            throw new RuntimeException("Framebuffer not created!");
        }
        return true;
    }

    @Override
    public boolean delete() {
        if (!super.delete()) {
            return false;
        }
        GL41.glDeleteFramebuffers(this.blitId);
        this.blitId = 0;
        return true;
    }

    public boolean blit(int width, int height) {
        if (!this.isGenerated()) {
            return false;
        }
        GL41.glBindFramebuffer(36008, this.id);
        GL41.glBindFramebuffer(36009, this.blitId);
        GL41.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
        GL41.glBindFramebuffer(36008, 0);
        GL41.glBindFramebuffer(36009, 0);
        return true;
    }

    public boolean bindBlit() {
        if (!this.isGenerated()) {
            return false;
        }
        GL41.glBindFramebuffer(36160, this.blitId);
        return true;
    }

    @Override
    public boolean isGenerated() {
        return super.isGenerated() && this.blitId != 0;
    }
}

