/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicBonepile
extends BlockLogicFlower {
    public BlockLogicBonepile(@NotNull Block<?> block) {
        super(block);
        float f = 0.4f;
        this.setBlockBounds(0.09999999403953552, 0.0, 0.09999999403953552, 0.9f, 0.8f, 0.9f);
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.mayPlaceOn(world.getBlockType(tilePos.down(new TilePos())));
    }

    @Override
    public boolean mayPlaceOn(@NotNull Block<?> block) {
        return block.isSolidRender();
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int meta, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        int quantity = world.rand.nextInt(3) + 1;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                if (quantity == 0 || world.rand.nextInt(8) != 0) {
                    itemStackArray = null;
                    break;
                }
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(Items.BONE, quantity);
            }
        }
        return itemStackArray;
    }
}

