/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import java.util.Random;
import net.minecraft.client.render.block.color.BlockColorCustom;
import net.minecraft.client.render.colorizer.Colorizer;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;

public class BlockColorLeavesOak
extends BlockColorCustom {
    @NotNull
    private static final ImprovedPerlinNoise fallColorPerlin = new ImprovedPerlinNoise(new Random(0L));

    public BlockColorLeavesOak(Colorizer colorizer) {
        super(colorizer);
    }

    @Override
    public int getWorldColor(@NotNull WorldSource source, @NotNull TilePosc tilePos, int tintIndex) {
        int color = super.getWorldColor(source, tilePos, tintIndex);
        Season season = source.getSeasonManager().getCurrentSeason();
        if (season != null) {
            float progress = source.getSeasonManager().getSeasonProgress();
            if (season == Seasons.OVERWORLD_FALL) {
                float offsetIntensity = 1.0f - Math.abs(progress * 2.0f - 1.0f);
                float green = (float)((color & 0xFF00) >> 8) / 255.0f;
                float greenOffset = (float)fallColorPerlin.getValue((double)tilePos.x() / 10.0, (double)tilePos.y() / 10.0, (double)tilePos.z() / 10.0) * offsetIntensity * 0.5f;
                if (green + greenOffset > 0.8f) {
                    greenOffset = 0.8f - green;
                }
                if (green + greenOffset < 0.0f) {
                    greenOffset = -green;
                }
                int newGreen = (int)((green + greenOffset) * 255.0f) & 0xFF;
                color &= 0xFF00FF;
                color |= newGreen << 8;
            }
        }
        return color;
    }
}

