/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

public final class LightIndexHelper {
    private LightIndexHelper() {
    }

    public static byte lightIndex2i(int skyLight, int blockLight) {
        return (byte)((skyLight & 0xF) << 4 | blockLight & 0xF);
    }

    public static byte lightIndex2f(float skyLight, float blockLight) {
        return LightIndexHelper.lightIndex2i((int)(skyLight * 15.0f), (int)(blockLight * 15.0f));
    }

    public static int skyLightFromIndex(byte lightIndex) {
        return lightIndex >> 4 & 0xF;
    }

    public static int blockLightFromIndex(byte lightIndex) {
        return lightIndex & 0xF;
    }

    public static byte setSkyLight(byte lightIndex, int skyLight) {
        return (byte)((skyLight & 0xF) << 4 | lightIndex & 0xF);
    }

    public static byte setBlockLight(byte lightIndex, int blockLight) {
        return (byte)(lightIndex & 0xF0 | blockLight & 0xF);
    }

    public static byte max(byte lightIndex1, byte lightIndex2) {
        int sky1 = lightIndex1 >> 4 & 0xF;
        int sky2 = lightIndex2 >> 4 & 0xF;
        int block1 = lightIndex1 & 0xF;
        int block2 = lightIndex2 & 0xF;
        return (byte)(Math.max(sky1, sky2) << 4 | Math.max(block1, block2));
    }

    public static byte avg(byte lightIndex1, byte lightIndex2) {
        int sky0 = lightIndex1 >> 4 & 0xF;
        int sky1 = lightIndex2 >> 4 & 0xF;
        int block0 = lightIndex1 & 0xF;
        int block1 = lightIndex2 & 0xF;
        int sky = sky0 + sky1 >> 1;
        int block = block0 + block1 >> 1;
        return (byte)(sky << 4 | block);
    }

    public static byte avg(byte lightIndex1, byte lightIndex2, byte lightIndex3, byte lightIndex4) {
        return LightIndexHelper.avg(LightIndexHelper.avg(lightIndex1, lightIndex2), LightIndexHelper.avg(lightIndex3, lightIndex4));
    }
}

