/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.PositionSelector;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class PositionSelectors {
    public static PositionSelector MinY = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        return new TilePos(x, minY, z);
    };
    public static PositionSelector MaxY = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        return new TilePos(x, maxY, z);
    };
    public static PositionSelector HeightRangeUniform = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        int y = minY + random.nextInt(rangeY);
        return new TilePos(x, y, z);
    };
    public static PositionSelector HeightRangeUniformFromOcean = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        int y = world.getWorldType().getOceanY() + random.nextInt(rangeY - 8) + 4;
        return new TilePos(x, y, z);
    };
    public static PositionSelector UpperHeightRangeUniform = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        int y = rangeY / 2 + random.nextInt(rangeY - 8) + 4;
        return new TilePos(x, y, z);
    };
    public static PositionSelector HeightRangeBiasedTop = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        int y = minY + random.nextInt(random.nextInt(rangeY - rangeY / 16) + rangeY / 16);
        return new TilePos(x, y, z);
    };
    public static PositionSelector SurfaceBlock = (world, chunk, random, minY, maxY, rangeY) -> {
        int x = chunk.pos.x() * 16 + random.nextInt(16);
        int z = chunk.pos.z() * 16 + random.nextInt(16);
        int y = world.getHeightValue(x, z);
        return new TilePos(x, y, z);
    };

    public static class HeightRangeUniform
    implements PositionSelector {
        private final int range;

        public HeightRangeUniform(int range) {
            this.range = Math.min(range, 1);
        }

        @Override
        public TilePos getValue(@NotNull World world, @NotNull Chunk chunk, @NotNull Random random, int minY, int maxY, int rangeY) {
            int x = chunk.pos.x() * 16 + random.nextInt(16);
            int z = chunk.pos.z() * 16 + random.nextInt(16);
            int y = minY + random.nextInt(rangeY / this.range);
            return new TilePos(x, y, z);
        }
    }
}

